/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.util.HashMap;
import java.util.Map;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.javabuild.JavaBuildTool;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.collection.domain.JHipsterCollections;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JHipsterModuleContext {
    private final Map<String, Object> context;

    private JHipsterModuleContext(Map<String, Object> context) {
        this.context = JHipsterCollections.immutable(context);
    }

    public static JHipsterModuleContext empty() {
        return new JHipsterModuleContext(new HashMap<String, Object>());
    }

    public JHipsterModuleContext withJavaBuildTool(JavaBuildTool javaBuildTool) {
        Map<String, String> additionalValues = Map.of("projectBuildDirectory", javaBuildTool.buildDirectory().get());
        return new JHipsterModuleContext(JHipsterCollections.concat(this.context, additionalValues));
    }

    public static JHipsterModuleContextBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleContextBuilder(module);
    }

    public Map<String, Object> get() {
        return this.context;
    }

    public static final class JHipsterModuleContextBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Map<String, Object> context;

        private JHipsterModuleContextBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
            this.context = this.initialContext(module.properties());
        }

        private Map<String, Object> initialContext(JHipsterModuleProperties properties) {
            HashMap<String, Object> init = new HashMap<String, Object>();
            init.put("baseName", properties.projectBaseName().get());
            init.put("projectName", properties.projectName().get());
            init.put("packageName", properties.basePackage().get());
            init.put("serverPort", properties.serverPort().get());
            init.put("indentSize", properties.indentation().spacesCount());
            init.put("javaVersion", properties.javaVersion().get());
            init.put("projectBuildDirectory", JavaBuildTool.MAVEN.buildDirectory().get());
            init.put("springConfigurationFormat", properties.springConfigurationFormat().get());
            return init;
        }

        public JHipsterModuleContextBuilder put(String key, Object value) {
            Assert.notBlank("key", key);
            Assert.notNull("value", value);
            this.context.put(key, value);
            return this;
        }

        public JHipsterModuleContext build() {
            return new JHipsterModuleContext(this.context);
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }
    }
}

