/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.GeneratedProjectRepository;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterModuleApplied;
import tech.jhipster.lite.module.domain.JHipsterModuleChanges;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.module.domain.JHipsterModuleToApply;
import tech.jhipster.lite.module.domain.JHipsterModulesRepository;
import tech.jhipster.lite.module.domain.JHipsterModulesToApply;
import tech.jhipster.lite.module.domain.file.JHipsterModuleFile;
import tech.jhipster.lite.module.domain.file.JHipsterTemplatedFile;
import tech.jhipster.lite.module.domain.file.JHipsterTemplatedFiles;
import tech.jhipster.lite.module.domain.git.GitRepository;
import tech.jhipster.lite.module.domain.javabuild.JavaBuildTool;
import tech.jhipster.lite.module.domain.javabuild.ProjectJavaBuildToolRepository;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersionsRepository;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependenciesRepository;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.domain.properties.SpringConfigurationFormat;
import tech.jhipster.lite.module.domain.replacement.ContentReplacer;
import tech.jhipster.lite.module.domain.replacement.ContentReplacers;
import tech.jhipster.lite.module.domain.startupcommand.DockerComposeStartupCommandLine;
import tech.jhipster.lite.module.domain.startupcommand.GradleStartupCommandLine;
import tech.jhipster.lite.module.domain.startupcommand.JHipsterStartupCommand;
import tech.jhipster.lite.module.domain.startupcommand.JHipsterStartupCommands;
import tech.jhipster.lite.module.domain.startupcommand.MavenStartupCommandLine;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModulesApplyer {
    private final JHipsterModulesRepository modules;
    private final JavaDependenciesVersionsRepository javaVersions;
    private final ProjectJavaDependenciesRepository projectDependencies;
    private final ProjectJavaBuildToolRepository javaBuildTools;
    private final GitRepository git;
    private final GeneratedProjectRepository generatedProject;

    public JHipsterModulesApplyer(JHipsterModulesRepository modules, JavaDependenciesVersionsRepository currentVersions, ProjectJavaDependenciesRepository projectDependencies, ProjectJavaBuildToolRepository javaBuildTools, GitRepository git, GeneratedProjectRepository generatedProject) {
        this.modules = modules;
        this.javaVersions = currentVersions;
        this.projectDependencies = projectDependencies;
        this.javaBuildTools = javaBuildTools;
        this.git = git;
        this.generatedProject = generatedProject;
    }

    public Collection<JHipsterModuleApplied> apply(JHipsterModulesToApply modulesToApply) {
        Assert.notNull("modulesToApply", modulesToApply);
        return this.modules.landscape().sort(modulesToApply.slugs()).stream().map(this.toModuleToApply(modulesToApply)).map(this::apply).toList();
    }

    private Function<JHipsterModuleSlug, JHipsterModuleToApply> toModuleToApply(JHipsterModulesToApply modulesToApply) {
        return slug -> new JHipsterModuleToApply((JHipsterModuleSlug)slug, modulesToApply.properties());
    }

    public JHipsterModuleApplied apply(JHipsterModuleToApply moduleToApply) {
        Assert.notNull("moduleToApply", moduleToApply);
        JHipsterModule module = this.modules.resources().build(moduleToApply.slug(), moduleToApply.properties());
        JHipsterModuleChanges.JHipsterModuleChangesSpringPropertiesBuilder builder = JHipsterModuleChanges.builder().context(this.contextWithJavaBuildTool(module)).projectFolder(module.projectFolder()).indentation(module.indentation()).filesToAdd(this.buildTemplatedFiles(module)).filesToMove(module.filesToMove()).filesToDelete(module.filesToDelete()).replacers(this.buildReplacers(module)).startupCommands(this.buildStartupCommands(module)).javaBuildCommands(this.buildDependenciesChanges(module).merge(this.buildPluginsChanges(module)).merge(this.buildMavenBuildExtensionsChanges(module)).merge(this.buildPropertiesChanges(module)).merge(this.buildProfilesChanges(module)).merge(this.buildGradlePluginsChanges(module)).merge(this.buildGradleConfigurationsChanges(module))).packageJson(module.packageJson()).gitIgnore(module.gitIgnore()).preActions(module.preActions()).postActions(module.postActions()).springFactories(module.springFactories());
        JHipsterModuleChanges changes = moduleToApply.properties().springConfigurationFormat() == SpringConfigurationFormat.PROPERTIES ? builder.springProperties(module.springProperties()).springComments(module.springComments()) : builder.springYamlProperties(module.springProperties()).springYamlComments(module.springComments());
        this.modules.apply(changes);
        JHipsterModuleApplied moduleApplied = new JHipsterModuleApplied(moduleToApply.slug(), moduleToApply.properties(), Instant.now());
        this.modules.applied(moduleApplied);
        this.commitIfNeeded(moduleToApply);
        return moduleApplied;
    }

    private JHipsterModuleContext contextWithJavaBuildTool(JHipsterModule module) {
        return this.detectedJavaBuildTool(module).map(javaBuildTool -> module.context().withJavaBuildTool((JavaBuildTool)((Object)javaBuildTool))).orElse(module.context());
    }

    private Optional<JavaBuildTool> detectedJavaBuildTool(JHipsterModule module) {
        return this.javaBuildTools.detect(module.projectFolder()).or(() -> this.javaBuildTools.detect(module.files()));
    }

    private JHipsterTemplatedFiles buildTemplatedFiles(JHipsterModule module) {
        JHipsterModuleContext context = this.contextWithJavaBuildTool(module);
        List<JHipsterTemplatedFile> templatedFiles = module.filesToAdd().stream().map(file -> JHipsterTemplatedFile.builder().file((JHipsterModuleFile)file).context(context).build()).toList();
        return new JHipsterTemplatedFiles(templatedFiles);
    }

    private JHipsterStartupCommands buildStartupCommands(JHipsterModule module) {
        Optional<JavaBuildTool> javaBuildTool = this.detectedJavaBuildTool(module);
        if (javaBuildTool.isEmpty()) {
            return module.startupCommands();
        }
        List<JHipsterStartupCommand> filteredCommands = module.startupCommands().get().stream().filter(JHipsterModulesApplyer.isStartupCommandCompatibleWith(javaBuildTool.get())).toList();
        return new JHipsterStartupCommands(filteredCommands);
    }

    private static Predicate<JHipsterStartupCommand> isStartupCommandCompatibleWith(JavaBuildTool javaBuildTool) {
        return startupCommand -> {
            JHipsterStartupCommand jHipsterStartupCommand = startupCommand;
            Objects.requireNonNull(jHipsterStartupCommand);
            JHipsterStartupCommand selector0$temp = jHipsterStartupCommand;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MavenStartupCommandLine.class, GradleStartupCommandLine.class, DockerComposeStartupCommandLine.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    MavenStartupCommandLine __ = (MavenStartupCommandLine)selector0$temp;
                    if (javaBuildTool == JavaBuildTool.MAVEN) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    GradleStartupCommandLine __ = (GradleStartupCommandLine)selector0$temp;
                    if (javaBuildTool == JavaBuildTool.GRADLE) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    DockerComposeStartupCommandLine __ = (DockerComposeStartupCommandLine)selector0$temp;
                    yield true;
                }
            };
        };
    }

    private ContentReplacers buildReplacers(JHipsterModule module) {
        List<ContentReplacer> replacers = Stream.concat(module.mandatoryReplacements().replacers(), module.optionalReplacements().buildReplacers(module.projectFolder(), this.generatedProject)).toList();
        return new ContentReplacers(replacers);
    }

    private void commitIfNeeded(JHipsterModuleToApply moduleToApply) {
        if (moduleToApply.commitNeeded()) {
            JHipsterProjectFolder projectFolder = moduleToApply.properties().projectFolder();
            this.git.init(projectFolder);
            this.git.commitAll(projectFolder, this.commitMessage(moduleToApply));
        }
    }

    private String commitMessage(JHipsterModuleToApply moduleToApply) {
        return "Apply %s module".formatted(moduleToApply.slug().get());
    }

    private JavaBuildCommands buildGradlePluginsChanges(JHipsterModule module) {
        return module.gradlePlugins().buildChanges(this.javaVersions.get());
    }

    private JavaBuildCommands buildDependenciesChanges(JHipsterModule module) {
        return module.javaDependencies().buildChanges(this.javaVersions.get(), this.projectDependencies.get(module.projectFolder()));
    }

    private JavaBuildCommands buildPropertiesChanges(JHipsterModule module) {
        return module.javaBuildProperties().buildChanges();
    }

    private JavaBuildCommands buildProfilesChanges(JHipsterModule module) {
        return module.javaBuildProfiles().buildChanges(this.javaVersions.get(), this.projectDependencies.get(module.projectFolder()));
    }

    private JavaBuildCommands buildPluginsChanges(JHipsterModule module) {
        return module.mavenPlugins().buildChanges(this.javaVersions.get(), this.projectDependencies.get(module.projectFolder()));
    }

    private JavaBuildCommands buildGradleConfigurationsChanges(JHipsterModule module) {
        return module.gradleConfigurations().buildChanges();
    }

    private JavaBuildCommands buildMavenBuildExtensionsChanges(JHipsterModule module) {
        return module.mavenBuildExtensions().buildChanges(this.javaVersions.get());
    }
}

