/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.gitignore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.gitignore.GitIgnoreEntry;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JHipsterModuleGitIgnore {
    private final Collection<GitIgnoreEntry> entries;

    private JHipsterModuleGitIgnore(Collection<GitIgnoreEntry> entries) {
        Assert.field("entries", entries).notNull().noNullElement();
        this.entries = entries;
    }

    public void forEach(Consumer<GitIgnoreEntry> consumer) {
        Assert.notNull("consumer", consumer);
        this.entries.forEach(consumer);
    }

    public boolean isNotEmpty() {
        return !this.entries.isEmpty();
    }

    public String toString() {
        return this.entries.toString();
    }

    public static JHipsterModuleGitIgnoreBuilder builder(JHipsterModule.JHipsterModuleBuilder parentModuleBuilder) {
        return new JHipsterModuleGitIgnoreBuilder(parentModuleBuilder);
    }

    public static final class JHipsterModuleGitIgnoreBuilder {
        private final JHipsterModule.JHipsterModuleBuilder parentModuleBuilder;
        private final Collection<GitIgnoreEntry> entries = new ArrayList<GitIgnoreEntry>();

        private JHipsterModuleGitIgnoreBuilder(JHipsterModule.JHipsterModuleBuilder parentModuleBuilder) {
            Assert.notNull("module", parentModuleBuilder);
            this.parentModuleBuilder = parentModuleBuilder;
        }

        public JHipsterModuleGitIgnoreBuilder pattern(GitIgnoreEntry.GitIgnorePattern pattern) {
            Assert.notNull("pattern", pattern);
            this.entries.add(pattern);
            return this;
        }

        public JHipsterModuleGitIgnoreBuilder pattern(String pattern) {
            return this.pattern(new GitIgnoreEntry.GitIgnorePattern(pattern));
        }

        public JHipsterModuleGitIgnoreBuilder comment(GitIgnoreEntry.GitIgnoreComment comment) {
            Assert.notNull("comment", comment);
            this.entries.add(comment);
            return this;
        }

        public JHipsterModuleGitIgnoreBuilder comment(String comment) {
            return this.comment(new GitIgnoreEntry.GitIgnoreComment(comment));
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.parentModuleBuilder;
        }

        public JHipsterModuleGitIgnore build() {
            return new JHipsterModuleGitIgnore(this.entries);
        }
    }
}

