/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.gradleplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import tech.jhipster.lite.module.domain.gradleplugin.BuildGradleImport;
import tech.jhipster.lite.module.domain.gradleplugin.GradleMainBuildPlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginConfiguration;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginId;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginImports;
import tech.jhipster.lite.module.domain.gradleplugin.GradleProfilePlugin;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class GradleCorePlugin
implements GradleMainBuildPlugin,
GradleProfilePlugin {
    private final GradlePluginId id;
    private final GradlePluginImports imports;
    private final Optional<GradlePluginConfiguration> configuration;
    private final Optional<VersionSlug> toolVersionSlug;

    private GradleCorePlugin(GradleCorePluginBuilder builder) {
        Assert.notNull("id", builder.id);
        this.id = builder.id;
        this.imports = new GradlePluginImports(builder.imports);
        this.configuration = Optional.ofNullable(builder.configuration);
        this.toolVersionSlug = Optional.ofNullable(builder.toolVersionSlug);
    }

    @Override
    public GradlePluginId id() {
        return this.id;
    }

    @Override
    public GradlePluginImports imports() {
        return this.imports;
    }

    @Override
    public Optional<GradlePluginConfiguration> configuration() {
        return this.configuration;
    }

    public Optional<VersionSlug> toolVersionSlug() {
        return this.toolVersionSlug;
    }

    public static GradleCorePluginIdBuilder builder() {
        return new GradleCorePluginBuilder();
    }

    private static final class GradleCorePluginBuilder
    implements GradleCorePluginIdBuilder,
    GradleCorePluginOptionalBuilder {
        private GradlePluginId id;
        private final Collection<BuildGradleImport> imports = new ArrayList<BuildGradleImport>();
        private GradlePluginConfiguration configuration;
        private VersionSlug toolVersionSlug;

        private GradleCorePluginBuilder() {
        }

        @Override
        public GradleCorePluginOptionalBuilder id(GradlePluginId id) {
            this.id = id;
            return this;
        }

        @Override
        public GradleCorePluginOptionalBuilder withBuildGradleImport(BuildGradleImport gradleImport) {
            this.imports.add(gradleImport);
            return this;
        }

        @Override
        public GradleCorePluginOptionalBuilder configuration(GradlePluginConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public GradleCorePluginOptionalBuilder toolVersionSlug(VersionSlug versionSlug) {
            this.toolVersionSlug = versionSlug;
            return this;
        }

        @Override
        public GradleCorePlugin build() {
            return new GradleCorePlugin(this);
        }
    }

    public static interface GradleCorePluginOptionalBuilder {
        public GradleCorePluginOptionalBuilder withBuildGradleImport(BuildGradleImport var1);

        default public GradleCorePluginOptionalBuilder withBuildGradleImport(String gradleImport) {
            return this.withBuildGradleImport(new BuildGradleImport(gradleImport));
        }

        public GradleCorePluginOptionalBuilder configuration(GradlePluginConfiguration var1);

        default public GradleCorePluginOptionalBuilder configuration(String configuration) {
            return this.configuration(new GradlePluginConfiguration(configuration));
        }

        public GradleCorePluginOptionalBuilder toolVersionSlug(VersionSlug var1);

        default public GradleCorePluginOptionalBuilder toolVersionSlug(String versionSlug) {
            return this.toolVersionSlug(new VersionSlug(versionSlug));
        }

        public GradleCorePlugin build();
    }

    public static interface GradleCorePluginIdBuilder {
        public GradleCorePluginOptionalBuilder id(GradlePluginId var1);

        default public GradleCorePluginOptionalBuilder id(String id) {
            return this.id(new GradlePluginId(id));
        }
    }
}

