/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javabuildprofile;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaBuildProfile;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javabuildprofile.JHipsterModuleJavaBuildProfile;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependencies;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JHipsterModuleJavaBuildProfiles {
    private final Collection<JHipsterModuleJavaBuildProfile> profiles;

    private JHipsterModuleJavaBuildProfiles(JHipsterModuleJavaBuildProfilesBuilder builder) {
        this.profiles = builder.profiles.values().stream().map(JHipsterModuleJavaBuildProfile.JHipsterModuleJavaBuildProfileBuilder::build).toList();
    }

    public static JHipsterModuleJavaBuildProfilesBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleJavaBuildProfilesBuilder(module);
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions, ProjectJavaDependencies projectJavaDependencies) {
        Stream<JavaBuildCommand> addProfileCommands = this.profiles.stream().map(this.toAddProfileCommands());
        Stream<JavaBuildCommand> addPropertyCommands = this.profiles.stream().flatMap(this.toAddPropertyCommands());
        Stream<JavaBuildCommand> mavenPluginCommands = this.profiles.stream().flatMap(this.toMavenPluginCommands(versions, projectJavaDependencies));
        Stream<JavaBuildCommand> gradlePluginCommands = this.profiles.stream().flatMap(this.toGradlePluginCommands(versions));
        Stream<JavaBuildCommand> javaDependenciesCommands = this.profiles.stream().flatMap(this.toJavaDependenciesCommands(versions, projectJavaDependencies));
        List commands = Stream.of(addProfileCommands, addPropertyCommands, mavenPluginCommands, gradlePluginCommands, javaDependenciesCommands).flatMap(Function.identity()).toList();
        return new JavaBuildCommands(commands);
    }

    private Function<JHipsterModuleJavaBuildProfile, JavaBuildCommand> toAddProfileCommands() {
        return profile -> new AddJavaBuildProfile(profile.id(), profile.activation());
    }

    private Function<JHipsterModuleJavaBuildProfile, Stream<JavaBuildCommand>> toAddPropertyCommands() {
        return profile -> profile.properties().buildChanges(profile.id());
    }

    private Function<JHipsterModuleJavaBuildProfile, Stream<JavaBuildCommand>> toMavenPluginCommands(JavaDependenciesVersions versions, ProjectJavaDependencies projectJavaDependencies) {
        return profile -> profile.mavenPlugins().buildChanges(versions, projectJavaDependencies, profile.id()).get().stream();
    }

    private Function<JHipsterModuleJavaBuildProfile, Stream<JavaBuildCommand>> toGradlePluginCommands(JavaDependenciesVersions versions) {
        return profile -> profile.gradlePlugins().buildChanges(versions, profile.id()).get().stream();
    }

    private Function<JHipsterModuleJavaBuildProfile, Stream<JavaBuildCommand>> toJavaDependenciesCommands(JavaDependenciesVersions versions, ProjectJavaDependencies projectJavaDependencies) {
        return profile -> profile.javaDependencies().buildChanges(versions, projectJavaDependencies, profile.id()).get().stream();
    }

    public static final class JHipsterModuleJavaBuildProfilesBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Map<BuildProfileId, JHipsterModuleJavaBuildProfile.JHipsterModuleJavaBuildProfileBuilder> profiles = new HashMap<BuildProfileId, JHipsterModuleJavaBuildProfile.JHipsterModuleJavaBuildProfileBuilder>();

        private JHipsterModuleJavaBuildProfilesBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModuleJavaBuildProfile.JHipsterModuleJavaBuildProfileBuilder addProfile(BuildProfileId buildProfileId) {
            Assert.notNull("buildProfileId", buildProfileId);
            return this.profiles.computeIfAbsent(buildProfileId, id -> JHipsterModuleJavaBuildProfile.builder(this, buildProfileId));
        }

        public JHipsterModuleJavaBuildProfile.JHipsterModuleJavaBuildProfileBuilder addProfile(String buildProfileId) {
            return this.addProfile(new BuildProfileId(buildProfileId));
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModuleJavaBuildProfiles build() {
            return new JHipsterModuleJavaBuildProfiles(this);
        }
    }
}

