/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.packagejson;

import java.util.ArrayList;
import java.util.Collection;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependencies;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependency;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonType;
import tech.jhipster.lite.module.domain.packagejson.PackageName;
import tech.jhipster.lite.module.domain.packagejson.Script;
import tech.jhipster.lite.module.domain.packagejson.ScriptCommand;
import tech.jhipster.lite.module.domain.packagejson.ScriptKey;
import tech.jhipster.lite.module.domain.packagejson.Scripts;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JHipsterModulePackageJson {
    private final Scripts scripts;
    private final PackageJsonDependencies dependencies;
    private final PackageJsonDependencies dependenciesToRemove;
    private final PackageJsonDependencies devDependencies;
    private final PackageJsonDependencies devDependenciesToRemove;
    private final PackageJsonType type;

    private JHipsterModulePackageJson(JHipsterModulePackageJsonBuilder builder) {
        this.scripts = new Scripts(builder.scripts);
        this.dependencies = new PackageJsonDependencies(builder.dependencies);
        this.dependenciesToRemove = new PackageJsonDependencies(builder.dependenciesToRemove);
        this.devDependencies = new PackageJsonDependencies(builder.devDependencies);
        this.devDependenciesToRemove = new PackageJsonDependencies(builder.devDependenciesToRemove);
        this.type = new PackageJsonType(builder.type);
    }

    public static JHipsterModulePackageJsonBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModulePackageJsonBuilder(module);
    }

    public boolean isEmpty() {
        return this.scripts.isEmpty() && this.dependencies.isEmpty() && this.devDependencies.isEmpty() && this.dependenciesToRemove.isEmpty() && this.devDependenciesToRemove.isEmpty();
    }

    public Scripts scripts() {
        return this.scripts;
    }

    public PackageJsonDependencies devDependencies() {
        return this.devDependencies;
    }

    public PackageJsonDependencies dependencies() {
        return this.dependencies;
    }

    public PackageJsonDependencies devDependenciesToRemove() {
        return this.devDependenciesToRemove;
    }

    public PackageJsonDependencies dependenciesToRemove() {
        return this.dependenciesToRemove;
    }

    public PackageJsonType type() {
        return this.type;
    }

    public static final class JHipsterModulePackageJsonBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<Script> scripts = new ArrayList<Script>();
        private final Collection<PackageJsonDependency> dependencies = new ArrayList<PackageJsonDependency>();
        private final Collection<PackageJsonDependency> devDependencies = new ArrayList<PackageJsonDependency>();
        private final Collection<PackageJsonDependency> dependenciesToRemove = new ArrayList<PackageJsonDependency>();
        private final Collection<PackageJsonDependency> devDependenciesToRemove = new ArrayList<PackageJsonDependency>();
        private String type;

        private JHipsterModulePackageJsonBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModulePackageJsonBuilder addScript(ScriptKey key, ScriptCommand command) {
            this.scripts.add(new Script(key, command));
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDependency(PackageName packageName, VersionSource versionSource) {
            this.dependencies.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDependency(PackageName packageName, VersionSource versionSource, PackageName versionPackageName) {
            this.dependencies.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource).versionPackageName(versionPackageName).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder removeDependency(PackageName packageName, VersionSource versionSource) {
            this.dependenciesToRemove.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDevDependency(PackageName packageName, VersionSource versionSource) {
            this.devDependencies.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDevDependency(PackageName packageName, VersionSource versionSource, PackageName versionPackageName) {
            this.devDependencies.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource).versionPackageName(versionPackageName).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder removeDevDependency(PackageName packageName, VersionSource versionSource) {
            this.devDependenciesToRemove.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder addType(String t) {
            this.type = t;
            return this;
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModulePackageJson build() {
            return new JHipsterModulePackageJson(this);
        }
    }
}

