/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.javaproperties.SpringProperties;
import tech.jhipster.lite.module.domain.javaproperties.SpringProperty;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyType;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemJHipsterModulesRepository;
import tech.jhipster.lite.module.infrastructure.secondary.YamlFileSpringPropertiesHandler;
import tech.jhipster.lite.shared.error.domain.Assert;

@Service
class FileSystemYamlSpringPropertiesCommandsHandler {
    private static final Map<SpringPropertyType, List<String>> PROPERTIES_PATHS = FileSystemJHipsterModulesRepository.buildPaths();

    FileSystemYamlSpringPropertiesCommandsHandler() {
    }

    public void handle(Indentation indentation, JHipsterProjectFolder projectFolder, SpringProperties properties) {
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("properties", properties);
        properties.get().forEach(this.setProperty(indentation, projectFolder));
    }

    private Consumer<SpringProperty> setProperty(Indentation indentation, JHipsterProjectFolder projectFolder) {
        return property -> new YamlFileSpringPropertiesHandler(FileSystemYamlSpringPropertiesCommandsHandler.getPath(projectFolder, property), indentation).setValue(property.key(), property.value());
    }

    private static Path getPath(JHipsterProjectFolder projectFolder, SpringProperty property) {
        return PROPERTIES_PATHS.get((Object)property.type()).stream().map(FileSystemYamlSpringPropertiesCommandsHandler.toFilePath(projectFolder, property)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElseGet(FileSystemYamlSpringPropertiesCommandsHandler.defaultPropertiesFile(projectFolder, property));
    }

    private static Function<String, Path> toFilePath(JHipsterProjectFolder projectFolder, SpringProperty property) {
        return folder -> projectFolder.filePath(folder + FileSystemYamlSpringPropertiesCommandsHandler.yamlFilename(property));
    }

    private static Supplier<Path> defaultPropertiesFile(JHipsterProjectFolder projectFolder, SpringProperty property) {
        return switch (property.type()) {
            default -> throw new MatchException(null, null);
            case SpringPropertyType.MAIN_PROPERTIES, SpringPropertyType.MAIN_BOOTSTRAP_PROPERTIES -> () -> projectFolder.filePath("src/main/resources/config/" + FileSystemYamlSpringPropertiesCommandsHandler.yamlFilename(property));
            case SpringPropertyType.TEST_PROPERTIES, SpringPropertyType.TEST_BOOTSTRAP_PROPERTIES -> () -> projectFolder.filePath("src/test/resources/config/" + FileSystemYamlSpringPropertiesCommandsHandler.yamlFilename(property));
        };
    }

    private static String yamlFilename(SpringProperty property) {
        return property.filename() + ".yml";
    }
}

