/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.shared.error.infrastructure.primary;

import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import tech.jhipster.lite.shared.enumeration.domain.Enums;
import tech.jhipster.lite.shared.error.domain.ErrorKey;
import tech.jhipster.lite.shared.error.domain.GeneratorException;
import tech.jhipster.lite.shared.error.infrastructure.primary.ArgumentsReplacer;

@ControllerAdvice
@Order(value=2147482647)
class GeneratorErrorsHandler {
    private static final Logger log = LoggerFactory.getLogger(GeneratorErrorsHandler.class);
    private static final String MESSAGES_PREFIX = "error.";
    private final MessageSource messages;

    public GeneratorErrorsHandler(@Qualifier(value="generatorErrorMessageSource") MessageSource messages) {
        Locale.setDefault(Locale.ENGLISH);
        this.messages = messages;
    }

    @ExceptionHandler(value={GeneratorException.class})
    ProblemDetail handleGeneratorException(GeneratorException exception) {
        HttpStatus status = Optional.ofNullable(Enums.map(exception.status(), HttpStatus.class)).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
        ProblemDetail problem = ProblemDetail.forStatusAndDetail((HttpStatusCode)status, (String)this.buildDetail(exception));
        problem.setTitle(this.getMessage(exception.key(), "title"));
        problem.setProperty("key", (Object)exception.key().get());
        this.logException(exception, status);
        return problem;
    }

    private String buildDetail(GeneratorException exception) {
        String messageTemplate = this.getMessage(exception.key(), "detail");
        return ArgumentsReplacer.replaceParameters(messageTemplate, exception.parameters());
    }

    private String getMessage(ErrorKey key, String suffix) {
        return this.messages.getMessage(MESSAGES_PREFIX + key.get() + "." + suffix, null, this.locale());
    }

    private Locale locale() {
        return LocaleContextHolder.getLocale();
    }

    private void logException(GeneratorException exception, HttpStatus status) {
        if (status.is4xxClientError()) {
            log.info(exception.getMessage(), (Throwable)exception);
        } else {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }
}

