/*
 * Decompiled with CFR 0.152.
 */
package tech.kotlinlang.permission;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.kotlinlang.permission.AndroidPermissionHelper;
import tech.kotlinlang.permission.Permission;
import tech.kotlinlang.permission.PermissionHelper;
import tech.kotlinlang.permission.PermissionInitiation;
import tech.kotlinlang.permission.result.LocationPermissionResult;
import tech.kotlinlang.permission.result.NotificationPermissionResult;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0012\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Ltech/kotlinlang/permission/AndroidPermissionHelper;", "Ltech/kotlinlang/permission/PermissionHelper;", "permissionInitiation", "Ltech/kotlinlang/permission/PermissionInitiation;", "<init>", "(Ltech/kotlinlang/permission/PermissionInitiation;)V", "sharedPref", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "getSharedPref", "()Landroid/content/SharedPreferences;", "sharedPref$delegate", "Lkotlin/Lazy;", "checkIsPermissionGranted", "T", "permission", "Ltech/kotlinlang/permission/Permission;", "(Ltech/kotlinlang/permission/Permission;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requestForPermission", "checkNotificationPermission", "Ltech/kotlinlang/permission/result/NotificationPermissionResult;", "requestNotificationPermission", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkLocationPermission", "Ltech/kotlinlang/permission/result/LocationPermissionResult;", "requestLocationPermission", "permission_release"})
@SourceDebugExtension(value={"SMAP\nAndroidPermissionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPermissionHelper.kt\ntech/kotlinlang/permission/AndroidPermissionHelper\n+ 2 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,100:1\n41#2,12:101\n41#2,12:113\n*S KotlinDebug\n*F\n+ 1 AndroidPermissionHelper.kt\ntech/kotlinlang/permission/AndroidPermissionHelper\n*L\n65#1:101,12\n97#1:113,12\n*E\n"})
public final class AndroidPermissionHelper
implements PermissionHelper {
    @NotNull
    private final PermissionInitiation permissionInitiation;
    @NotNull
    private final Lazy sharedPref$delegate;

    public AndroidPermissionHelper(@NotNull PermissionInitiation permissionInitiation) {
        Intrinsics.checkNotNullParameter((Object)permissionInitiation, (String)"permissionInitiation");
        this.permissionInitiation = permissionInitiation;
        this.sharedPref$delegate = LazyKt.lazy(() -> AndroidPermissionHelper.sharedPref_delegate$lambda$0(this));
    }

    private final SharedPreferences getSharedPref() {
        Lazy lazy = this.sharedPref$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    @Override
    @Nullable
    public <T> Object checkIsPermissionGranted(@NotNull Permission<T> permission, @NotNull Continuation<? super T> $completion) {
        Object object;
        Permission<T> permission2 = permission;
        if (Intrinsics.areEqual(permission2, (Object)Permission.Location.INSTANCE)) {
            object = this.checkLocationPermission();
        } else if (Intrinsics.areEqual(permission2, (Object)Permission.Notification.INSTANCE)) {
            object = this.checkNotificationPermission();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Override
    @Nullable
    public <T> Object requestForPermission(@NotNull Permission<T> permission, @NotNull Continuation<? super T> $completion) {
        Object object;
        Permission<T> permission2 = permission;
        if (Intrinsics.areEqual(permission2, (Object)Permission.Location.INSTANCE)) {
            object = this.requestLocationPermission($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        } else if (Intrinsics.areEqual(permission2, (Object)Permission.Notification.INSTANCE)) {
            object = this.requestNotificationPermission($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final NotificationPermissionResult checkNotificationPermission() {
        if (Build.VERSION.SDK_INT < 33) {
            return NotificationPermissionResult.Granted.INSTANCE;
        }
        Activity activity = this.permissionInitiation.getActivity();
        boolean isUsed = this.getSharedPref().getBoolean("notification.permission", false);
        return ContextCompat.checkSelfPermission((Context)((Context)activity), (String)"android.permission.POST_NOTIFICATIONS") == 0 ? (NotificationPermissionResult)NotificationPermissionResult.Granted.INSTANCE : (isUsed && !ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.POST_NOTIFICATIONS") ? (NotificationPermissionResult)NotificationPermissionResult.NotAllowed.INSTANCE : (NotificationPermissionResult)NotificationPermissionResult.Denied.INSTANCE);
    }

    /*
     * Unable to fully structure code
     */
    private final Object requestNotificationPermission(Continuation<? super NotificationPermissionResult> $completion) {
        if (!($completion instanceof requestNotificationPermission.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AndroidPermissionHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AndroidPermissionHelper.access$requestNotificationPermission(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (Build.VERSION.SDK_INT < 33) {
                    return NotificationPermissionResult.Granted.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.permissionInitiation.requestPermission$permission_release("android.permission.POST_NOTIFICATIONS", (Continuation<? super Boolean>)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (AndroidPermissionHelper)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = this.getSharedPref();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"<get-sharedPref>(...)");
                $this$edit_u24default$iv = v1;
                commit$iv = false;
                $i$f$edit = false;
                $this$requestNotificationPermission_u24lambda_u241 = editor$iv = $this$edit_u24default$iv.edit();
                $i$a$-edit$default-AndroidPermissionHelper$requestNotificationPermission$2 = false;
                $this$requestNotificationPermission_u24lambda_u241.putBoolean("notification.permission", true);
                editor$iv.apply();
                return this.checkNotificationPermission();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final LocationPermissionResult checkLocationPermission() {
        Activity activity = this.permissionInitiation.getActivity();
        boolean isUsed = this.getSharedPref().getBoolean("location.permission", false);
        return ContextCompat.checkSelfPermission((Context)((Context)activity), (String)"android.permission.ACCESS_FINE_LOCATION") == 0 ? (LocationPermissionResult)LocationPermissionResult.Granted.Precise.INSTANCE : (ContextCompat.checkSelfPermission((Context)((Context)activity), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 ? (LocationPermissionResult)LocationPermissionResult.Granted.Approximate.INSTANCE : (isUsed && !ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.ACCESS_COARSE_LOCATION") ? (LocationPermissionResult)LocationPermissionResult.NotAllowed.INSTANCE : (LocationPermissionResult)LocationPermissionResult.Denied.INSTANCE));
    }

    /*
     * Unable to fully structure code
     */
    private final Object requestLocationPermission(Continuation<? super LocationPermissionResult> $completion) {
        if (!($completion instanceof requestLocationPermission.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AndroidPermissionHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AndroidPermissionHelper.access$requestLocationPermission(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.permissionInitiation.requestPermission$permission_release("android.permission.ACCESS_FINE_LOCATION", (Continuation<? super Boolean>)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (AndroidPermissionHelper)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = this.getSharedPref();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"<get-sharedPref>(...)");
                $this$edit_u24default$iv = v1;
                commit$iv = false;
                $i$f$edit = false;
                $this$requestLocationPermission_u24lambda_u242 = editor$iv = $this$edit_u24default$iv.edit();
                $i$a$-edit$default-AndroidPermissionHelper$requestLocationPermission$2 = false;
                $this$requestLocationPermission_u24lambda_u242.putBoolean("location.permission", true);
                editor$iv.apply();
                return this.checkLocationPermission();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final SharedPreferences sharedPref_delegate$lambda$0(AndroidPermissionHelper this$0) {
        Activity activity = this$0.permissionInitiation.getActivity();
        return activity.getSharedPreferences("PermissionPrefs", 0);
    }

    public static final /* synthetic */ Object access$requestNotificationPermission(AndroidPermissionHelper $this, Continuation $completion) {
        return $this.requestNotificationPermission((Continuation<? super NotificationPermissionResult>)$completion);
    }

    public static final /* synthetic */ Object access$requestLocationPermission(AndroidPermissionHelper $this, Continuation $completion) {
        return $this.requestLocationPermission((Continuation<? super LocationPermissionResult>)$completion);
    }
}

