/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.ext.jwt.admin;

import tech.mhuang.core.builder.BaseBuilder;
import tech.mhuang.ext.jwt.admin.JwtFramework;
import tech.mhuang.ext.jwt.admin.bean.Jwt;

public class JwtBuilder {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements BaseBuilder<JwtFramework> {
        private Jwt jwt = new Jwt();

        Builder() {
        }

        public ProducerBuilder createProducerBuilder() {
            return new ProducerBuilder();
        }

        public Builder bindProducer(String key, Jwt.JwtBean value) {
            this.jwt.getBeanMap().put(key, value);
            return this;
        }

        public JwtFramework builder() {
            return new JwtFramework(this.jwt);
        }
    }

    public static class ProducerBuilder
    implements BaseBuilder<Jwt.JwtBean> {
        private Jwt.JwtBean bean = new Jwt.JwtBean();

        public ProducerBuilder enable(boolean enable) {
            this.bean.setEnable(enable);
            return this;
        }

        public ProducerBuilder clientId(String clientId) {
            this.bean.setClientId(clientId);
            return this;
        }

        public ProducerBuilder secret(String secret) {
            this.bean.setSecret(secret);
            return this;
        }

        public ProducerBuilder name(String name) {
            this.bean.setName(name);
            return this;
        }

        public ProducerBuilder type(String type) {
            this.bean.setType(type);
            return this;
        }

        public ProducerBuilder headerName(String headerName) {
            this.bean.setHeaderName(headerName);
            return this;
        }

        public ProducerBuilder expireMinute(Long expireMinute) {
            this.bean.setExpireMinute(expireMinute);
            return this;
        }

        public Jwt.JwtBean builder() {
            return this.bean;
        }
    }
}

