/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.ext.jwt.admin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mhuang.core.check.CheckAssert;
import tech.mhuang.ext.jwt.admin.bean.Jwt;
import tech.mhuang.ext.jwt.admin.external.IJwtExternal;
import tech.mhuang.ext.jwt.admin.external.IJwtProducer;

public class JwtFramework {
    private static final Logger log = LoggerFactory.getLogger(JwtFramework.class);
    private Jwt jwt;
    private IJwtExternal external;
    private Map<String, IJwtProducer> producerMap = new ConcurrentHashMap<String, IJwtProducer>();

    public IJwtProducer getProducer(String key) {
        return this.producerMap.get(key);
    }

    public JwtFramework external(IJwtExternal external) {
        this.external = external;
        return this;
    }

    public JwtFramework(Jwt jwt) {
        this.jwt = jwt;
    }

    public void start() {
        log.info("\u6b63\u5728\u542f\u52a8JWT\u914d\u7f6e");
        if (this.external == null) {
            this.external = new IJwtExternal(){};
        }
        CheckAssert.check((Object)this.jwt, (Object)"\u6ca1\u6709\u627e\u5230JWT\u5bf9\u8c61\u914d\u7f6e");
        this.jwt.getBeanMap().forEach((key, bean) -> {
            IJwtProducer jwtProducer = this.external.create((String)key);
            jwtProducer.add((Jwt.JwtBean)bean);
            jwtProducer.name((String)key);
            this.producerMap.put((String)key, jwtProducer);
        });
        log.info("JWT\u542f\u52a8\u6210\u529f");
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public IJwtExternal getExternal() {
        return this.external;
    }

    public Map<String, IJwtProducer> getProducerMap() {
        return this.producerMap;
    }
}

