/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.base;

import java.io.File;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import tech.mlsql.common.utils.base.CharMatcher;
import tech.mlsql.common.utils.base.ProcessTool$;
import tech.mlsql.common.utils.log.Logging;
import tech.mlsql.common.utils.log.Logging$class;

public final class ProcessTool$
implements Logging {
    public static final ProcessTool$ MODULE$;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    static {
        new ProcessTool$();
    }

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public Option<String> getStderr(Process process, long timeoutMs) {
        boolean terminated = process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
        return terminated ? new Some((Object)Source$.MODULE$.fromInputStream(process.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n")) : None$.MODULE$;
    }

    public Option<Object> terminateProcess(Process process, long timeoutMs) {
        Option option;
        process.destroy();
        if (process.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
            option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
        } else {
            Process process2;
            try {
                process2 = process.destroyForcibly();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option2.get();
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Exception when attempting to kill process";
                    }
                }, e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                process2 = boxedUnit;
            }
            if (process.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
                option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
            } else {
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Timed out waiting to forcibly kill process";
                    }
                });
                option = None$.MODULE$;
            }
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> splitCommandString(String s) {
        void var2_2;
        ArrayBuffer buf = new ArrayBuffer();
        boolean inWord = false;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        StringBuilder curWord = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            BoxedUnit boxedUnit;
            char nextChar = s.charAt(i);
            if (inDoubleQuote) {
                if (nextChar == '\"') {
                    inDoubleQuote = false;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (nextChar == '\\') {
                    if (i < s.length() - 1) {
                        curWord.append(s.charAt(i + 1));
                        ++i;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = curWord.append(nextChar);
                continue;
            }
            if (inSingleQuote) {
                if (nextChar == '\'') {
                    inSingleQuote = false;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = curWord.append(nextChar);
                continue;
            }
            if (nextChar == '\"') {
                inWord = true;
                inDoubleQuote = true;
            } else if (nextChar == '\'') {
                inWord = true;
                inSingleQuote = true;
            } else if (CharMatcher.WHITESPACE.matches(nextChar)) {
                if (inWord && CharMatcher.WHITESPACE.matches(nextChar)) {
                    this.endWord$1(buf, curWord);
                    inWord = false;
                }
            } else {
                curWord.append(nextChar);
                inWord = true;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (inWord || inDoubleQuote || inSingleQuote) {
            this.endWord$1(buf, curWord);
        }
        return var2_2;
    }

    public Process executeCommand(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        Object object;
        ProcessBuilder builder = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).directory(workingDir);
        java.util.Map<String, String> environment = builder.environment();
        extraEnvironment.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(environment){
            public static final long serialVersionUID = 0L;
            private final java.util.Map environment$1;

            public final String apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    String string = this.environment$1.put(key, value);
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.environment$1 = environment$1;
            }
        });
        Process process = builder.start();
        if (redirectStderr) {
            String threadName = new StringBuilder().append((Object)"redirect stderr for command ").append(command.apply(0)).toString();
            object = this.processStreamByLine(threadName, process.getErrorStream(), (Function1<String, BoxedUnit>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String s) {
                    ProcessTool$.MODULE$.tech$mlsql$common$utils$base$ProcessTool$$log$1(s);
                }
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return process;
    }

    public File executeCommand$default$2() {
        return new File(".");
    }

    public Map<String, String> executeCommand$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean executeCommand$default$4() {
        return true;
    }

    public String executeAndGetOutput(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        Process process = this.executeCommand(command, workingDir, extraEnvironment, redirectStderr);
        StringBuilder output = new StringBuilder();
        String threadName = new StringBuilder().append((Object)"read stdout for ").append(command.apply(0)).toString();
        Thread stdoutThread = this.processStreamByLine(threadName, process.getInputStream(), (Function1<String, BoxedUnit>)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final StringBuilder output$1;

            public final void apply(String s) {
                ProcessTool$.MODULE$.tech$mlsql$common$utils$base$ProcessTool$$appendToOutput$1(s, this.output$1);
            }
            {
                this.output$1 = output$1;
            }
        });
        int exitCode = process.waitFor();
        stdoutThread.join();
        if (exitCode != 0) {
            this.logError((Function0<String>)new Serializable(command, output, exitCode){
                public static final long serialVersionUID = 0L;
                private final Seq command$1;
                private final StringBuilder output$1;
                private final int exitCode$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Process ", " exited with code ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command$1, BoxesRunTime.boxToInteger((int)this.exitCode$1), this.output$1}));
                }
                {
                    this.command$1 = command$1;
                    this.output$1 = output$1;
                    this.exitCode$1 = exitCode$1;
                }
            });
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Process ", " exited with code ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, BoxesRunTime.boxToInteger((int)exitCode)})));
        }
        return output.toString();
    }

    public File executeAndGetOutput$default$2() {
        return new File(".");
    }

    public Map<String, String> executeAndGetOutput$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean executeAndGetOutput$default$4() {
        return true;
    }

    public Thread processStreamByLine(String threadName, InputStream inputStream, Function1<String, BoxedUnit> processLine) {
        Thread t = new Thread(threadName, inputStream, processLine){
            private final InputStream inputStream$1;
            public final Function1 processLine$1;

            public void run() {
                Source$.MODULE$.fromInputStream(this.inputStream$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final void apply(String line) {
                        this.$outer.processLine$1.apply((Object)line);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.inputStream$1 = inputStream$1;
                this.processLine$1 = processLine$1;
                super(threadName$1);
            }
        };
        t.setDaemon(true);
        t.start();
        return t;
    }

    private final void endWord$1(ArrayBuffer buf$1, StringBuilder curWord$1) {
        buf$1.$plus$eq((Object)curWord$1.toString());
        curWord$1.clear();
    }

    public final void tech$mlsql$common$utils$base$ProcessTool$$log$1(String s) {
        this.logInfo((Function0<String>)new Serializable(s){
            public static final long serialVersionUID = 0L;
            private final String s$1;

            public final String apply() {
                return this.s$1;
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    public final void tech$mlsql$common$utils$base$ProcessTool$$appendToOutput$1(String s, StringBuilder output$1) {
        output$1.append(s).append("\n");
    }

    private ProcessTool$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

