/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.cluster.ml;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import tech.mlsql.common.utils.cluster.ml.ClusterSpecRequest;
import tech.mlsql.common.utils.cluster.ml.ClusterSpecResponse;
import tech.mlsql.common.utils.cluster.ml.JobStatusRequest;
import tech.mlsql.common.utils.cluster.ml.JobStatusResponse;
import tech.mlsql.common.utils.cluster.ml.MLClient;
import tech.mlsql.common.utils.cluster.ml.ReportToMasterRequest;
import tech.mlsql.common.utils.cluster.ml.ReportToMasterResponse;
import tech.mlsql.common.utils.cluster.ml.WorkerInfo;
import tech.mlsql.common.utils.distribute.socket.server.Request;
import tech.mlsql.common.utils.distribute.socket.server.SocketServerInExecutor;
import tech.mlsql.common.utils.log.Logging;
import tech.mlsql.common.utils.log.Logging$class;

@ScalaSignature(bytes="\u0006\u0001\u0005-a!B\u0001\u0003\u0003\u0003y!\u0001C'M\tJLg/\u001a:\u000b\u0005\r!\u0011AA7m\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011!B;uS2\u001c(BA\u0005\u000b\u0003\u0019\u0019w.\\7p]*\u00111\u0002D\u0001\u0006[2\u001c\u0018\u000f\u001c\u0006\u0002\u001b\u0005!A/Z2i\u0007\u0001)\"\u0001E\u000f\u0014\u0007\u0001\t\u0012\u0006E\u0002\u00133mi\u0011a\u0005\u0006\u0003)U\taa]3sm\u0016\u0014(B\u0001\f\u0018\u0003\u0019\u0019xnY6fi*\u0011\u0001DB\u0001\u000bI&\u001cHO]5ckR,\u0017B\u0001\u000e\u0014\u0005Y\u0019vnY6fiN+'O^3s\u0013:,\u00050Z2vi>\u0014\bC\u0001\u000f\u001e\u0019\u0001!QA\b\u0001C\u0002}\u0011\u0011\u0001V\t\u0003A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012qAT8uQ&tw\r\u0005\u0002\"O%\u0011\u0001F\t\u0002\u0004\u0003:L\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0007\u0003\rawnZ\u0005\u0003]-\u0012q\u0001T8hO&tw\r\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u00039!\u0018m]6D_:$X\r\u001f;SK\u001a\u00042AM\u001e\u001c\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0019\tGo\\7jG*\u0011agN\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001d:\u0003\u0011)H/\u001b7\u000b\u0003i\nAA[1wC&\u0011Ah\r\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dK\")a\b\u0001C\u0001\u007f\u00051A(\u001b8jiz\"\"\u0001\u0011\"\u0011\u0007\u0005\u00031$D\u0001\u0003\u0011\u0015\u0001T\b1\u00012\u0011\u001d!\u0005A1A\u0005\n\u0015\u000b1bY8o]\u0016\u001cG/[8ogV\ta\tE\u0002H\u0019:k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bq!\\;uC\ndWM\u0003\u0002LE\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055C%aC!se\u0006L()\u001e4gKJ\u0004\"a\u0014*\u000e\u0003AS!!U\u001d\u0002\u00079,G/\u0003\u0002T!\n11k\\2lKRDa!\u0016\u0001!\u0002\u00131\u0015\u0001D2p]:,7\r^5p]N\u0004\u0003bB,\u0001\u0001\u0004%I\u0001W\u0001\n[\u0006\u00148n\u00117pg\u0016,\u0012!\u0017\t\u0003eiK!aW\u001a\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u001di\u0006\u00011A\u0005\ny\u000bQ\"\\1sW\u000ecwn]3`I\u0015\fHCA0c!\t\t\u0003-\u0003\u0002bE\t!QK\\5u\u0011\u001d\u0019G,!AA\u0002e\u000b1\u0001\u001f\u00132\u0011\u0019)\u0007\u0001)Q\u00053\u0006QQ.\u0019:l\u00072|7/\u001a\u0011)\u0005\u0011<\u0007CA\u0011i\u0013\tI'E\u0001\u0005w_2\fG/\u001b7f\u0011\u001dY\u0007A1A\u0005\u00021\faa\u00197jK:$X#A7\u0011\u0005\u0005s\u0017BA8\u0003\u0005!iEj\u00117jK:$\bBB9\u0001A\u0003%Q.A\u0004dY&,g\u000e\u001e\u0011\t\u000fM\u0004!\u0019!C\u0001i\u00069qo\u001c:lKJ\u001cX#A;\u0011\u0007Y<\u00180D\u00016\u0013\tAXGA\nD_BLxJ\\,sSR,\u0017I\u001d:bsN+G\u000f\u0005\u0002Bu&\u00111P\u0001\u0002\u000b/>\u00148.\u001a:J]\u001a|\u0007BB?\u0001A\u0003%Q/\u0001\u0005x_J\\WM]:!\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005)1\r\\8tKR\tq\fC\u0004\u0002\u0006\u0001!\t%a\u0002\u0002!!\fg\u000e\u001a7f\u0007>tg.Z2uS>tGcA0\u0002\n!1a#a\u0001A\u00029\u0003")
public abstract class MLDriver<T>
extends SocketServerInExecutor<T>
implements Logging {
    private final ArrayBuffer<Socket> connections;
    private volatile AtomicBoolean markClose;
    private final MLClient client;
    private final CopyOnWriteArraySet<WorkerInfo> workers;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private ArrayBuffer<Socket> connections() {
        return this.connections;
    }

    private AtomicBoolean markClose() {
        return this.markClose;
    }

    private void markClose_$eq(AtomicBoolean x$1) {
        this.markClose = x$1;
    }

    public MLClient client() {
        return this.client;
    }

    public CopyOnWriteArraySet<WorkerInfo> workers() {
        return this.workers;
    }

    @Override
    public void close() {
        if (this.markClose().compareAndSet(false, true)) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MLDriver $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shutdown ", ". This may caused by the task is killed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.host()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleConnection(Socket socket) {
        this.connections().$plus$eq((Object)socket);
        socket.setKeepAlive(true);
        DataInputStream dIn = new DataInputStream(socket.getInputStream());
        DataOutputStream dOut = new DataOutputStream(socket.getOutputStream());
        while (true) {
            BoxedUnit boxedUnit;
            Request<?> request;
            if ((request = this.client().readRequest(dIn)) instanceof ReportToMasterRequest) {
                ReportToMasterRequest reportToMasterRequest = (ReportToMasterRequest)request;
                String host = reportToMasterRequest.host();
                int port = reportToMasterRequest.port();
                String jobName = reportToMasterRequest.jobName();
                int taskIndex = reportToMasterRequest.taskIndex();
                boolean isPs = reportToMasterRequest.isPs();
                this.workers().add(new WorkerInfo(host, port, jobName, taskIndex, isPs, false, false));
                this.client().sendResponse(dOut, new ReportToMasterResponse());
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (request instanceof ClusterSpecRequest) {
                this.client().sendResponse(dOut, new ClusterSpecResponse((List<WorkerInfo>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.workers()).asScala()).toList()));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (!(request instanceof JobStatusRequest)) {
                throw new MatchError(request);
            }
            JobStatusRequest jobStatusRequest = (JobStatusRequest)request;
            String jobName = jobStatusRequest.jobName();
            int taskIndex = jobStatusRequest.taskIndex();
            boolean done = jobStatusRequest.done();
            boolean success = jobStatusRequest.succcess();
            boolean shouldUpdate = jobStatusRequest.shouldUpdate();
            MLDriver mLDriver = this;
            synchronized (mLDriver) {
                Object object;
                if (shouldUpdate) {
                    WorkerInfo tempWorker = (WorkerInfo)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.workers()).asScala()).filter((Function1)new Serializable(this, jobName, taskIndex){
                        public static final long serialVersionUID = 0L;
                        private final String jobName$1;
                        private final int taskIndex$1;

                        public final boolean apply(WorkerInfo f) {
                            String string = f.jobName();
                            String string2 = this.jobName$1;
                            return !(string != null ? !string.equals(string2) : string2 != null) && f.taskIndex() == this.taskIndex$1;
                        }
                        {
                            this.jobName$1 = jobName$1;
                            this.taskIndex$1 = taskIndex$1;
                        }
                    })).head();
                    this.workers().remove(tempWorker);
                    boolean x$1 = done;
                    boolean x$2 = success;
                    String x$3 = tempWorker.copy$default$1();
                    int x$4 = tempWorker.copy$default$2();
                    String x$5 = tempWorker.copy$default$3();
                    int x$6 = tempWorker.copy$default$4();
                    boolean x$7 = tempWorker.copy$default$5();
                    object = BoxesRunTime.boxToBoolean((boolean)this.workers().add(tempWorker.copy(x$3, x$4, x$5, x$6, x$7, x$1, x$2)));
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MLDriver $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"update jobstat:").append((Object)new JobStatusResponse((List<WorkerInfo>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.workers()).asScala()).toList())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.client().sendResponse(dOut, new JobStatusResponse((List<WorkerInfo>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.workers()).asScala()).toList()));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl51 : MonitorExitStatement: MONITOREXIT : mLDriver
                boxedUnit = boxedUnit2;
            }
        }
    }

    public MLDriver(AtomicReference<T> taskContextRef) {
        super(taskContextRef, "tf-socket-server-in-driver");
        Logging$class.$init$(this);
        this.connections = new ArrayBuffer();
        this.markClose = new AtomicBoolean(false);
        this.client = new MLClient();
        this.workers = new CopyOnWriteArraySet();
    }
}

