/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.hdfs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import tech.mlsql.common.utils.Md5$;

public final class HDFSOperator$ {
    public static final HDFSOperator$ MODULE$;

    static {
        new HDFSOperator$();
    }

    public String readFile(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        BufferedReader br = null;
        String line = null;
        ArrayBuffer result = new ArrayBuffer();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(path))));
            line = br.readLine();
            return line;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public FileStatus getFileStatus(String path) {
        void var3_3;
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        FileStatus file = fs.getFileStatus(new Path(path));
        return var3_3;
    }

    public InputStream readAsInputStream(String fileName) {
        FSDataInputStream in;
        block2: {
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            Path src = new Path(fileName);
            in = null;
            try {
                in = fs.open(src);
            }
            catch (Exception exception) {
                if (in == null) break block2;
                in.close();
            }
        }
        return in;
    }

    public byte[] readBytes(String fileName) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        Path src = new Path(fileName);
        FSDataInputStream in = null;
        try {
            in = fs.open(src);
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)byteArrayOut, (int)1024, (boolean)true);
            return byteArrayOut.toByteArray();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public Seq<FileStatus> listModelDirectory(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(path))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus f) {
                return f.isDirectory();
            }
        }));
    }

    public Seq<FileStatus> listFiles(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return Predef$.MODULE$.wrapRefArray((Object[])fs.listStatus(new Path(path)));
    }

    public void saveBytesFile(String path, String fileName, byte[] bytes) {
        FSDataOutputStream dos = null;
        try {
            try {
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                Object object = fs.exists(new Path(path)) ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(new Path(path)));
                dos = fs.create(new Path(new File(path, fileName).getPath()), true);
                dos.write(bytes);
            }
            catch (Exception exception) {
                Predef$.MODULE$.println((Object)"file save exception");
            }
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception exception) {
                    Predef$.MODULE$.println((Object)"close exception");
                }
                dos.close();
            }
        }
    }

    public void saveStream(String path, String fileName, InputStream inputStream) {
        FSDataOutputStream dos = null;
        try {
            try {
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                Object object = fs.exists(new Path(path)) ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(new Path(path)));
                dos = fs.create(new Path(new File(path, fileName).getPath()), true);
                IOUtils.copyBytes((InputStream)inputStream, (OutputStream)dos, (int)0x400000);
            }
            catch (Exception exception) {
                Predef$.MODULE$.println((Object)"file save exception");
            }
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception exception) {
                    Predef$.MODULE$.println((Object)"close exception");
                }
                dos.close();
            }
        }
    }

    public void ceateEmptyFile(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        FSDataOutputStream dos = fs.create(new Path(path));
        dos.close();
    }

    public void saveFile(String path, String fileName, Iterator<Tuple2<String, String>> iterator) {
        ObjectRef dos = ObjectRef.create(null);
        try {
            try {
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                Object object = fs.exists(new Path(path)) ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(new Path(path)));
                dos.elem = fs.create(new Path(new StringBuilder().append((Object)path).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName}))).toString()), true);
                iterator.foreach((Function1)new Serializable(dos){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dos$1;

                    public final void apply(Tuple2<String, String> x) {
                        ((FSDataOutputStream)this.dos$1.elem).writeBytes(new StringBuilder().append((Object)((String)x._2())).append((Object)"\n").toString());
                    }
                    {
                        this.dos$1 = dos$1;
                    }
                });
            }
            catch (Exception exception) {
                Predef$.MODULE$.println((Object)"file save exception");
            }
        }
        finally {
            if ((FSDataOutputStream)dos.elem != null) {
                try {
                    ((FSDataOutputStream)dos.elem).close();
                }
                catch (Exception exception) {
                    Predef$.MODULE$.println((Object)"close exception");
                }
                ((FSDataOutputStream)dos.elem).close();
            }
        }
    }

    public String getFilePath(String path) {
        return new Path(path).toString();
    }

    public void copyToHDFS(String tempLocalPath, String path, boolean cleanTarget, boolean cleanSource) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        Object object = cleanTarget ? BoxesRunTime.boxToBoolean((boolean)fs.delete(new Path(path), true)) : BoxedUnit.UNIT;
        fs.copyFromLocalFile(new Path(tempLocalPath), new Path(path));
        if (cleanSource) {
            FileUtils.forceDelete((File)new File(tempLocalPath));
        }
    }

    public void copyToLocalFile(String tempLocalPath, String path, boolean clean) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        File tmpFile = new File(tempLocalPath);
        if (tmpFile.exists()) {
            FileUtils.forceDelete((File)tmpFile);
        }
        fs.copyToLocalFile(new Path(path), new Path(tempLocalPath));
    }

    public boolean deleteDir(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.delete(new Path(path), true);
    }

    public boolean isDir(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.isDirectory(new Path(path));
    }

    public boolean isFile(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.isFile(new Path(path));
    }

    public boolean fileExists(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.exists(new Path(path));
    }

    public boolean createDir(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.mkdirs(new Path(path));
    }

    /*
     * WARNING - void declaration
     */
    public String createTempModelLocalPath(String path, boolean autoCreateParentDir) {
        void var3_3;
        String dir = new StringBuilder().append((Object)"/tmp/train/").append((Object)Md5$.MODULE$.md5Hash(path)).toString();
        if (autoCreateParentDir) {
            FileUtils.forceMkdir((File)new File(dir));
        }
        return var3_3;
    }

    public boolean createTempModelLocalPath$default$2() {
        return true;
    }

    public ArrayBuffer<String> iteratorFiles(String path, boolean recursive) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        ArrayBuffer files = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this._iteratorFiles(fs, path, (ArrayBuffer<String>)files);
        return files;
    }

    public void _iteratorFiles(FileSystem fs, String path, ArrayBuffer<String> files) {
        Path p = new Path(path);
        FileStatus file = fs.getFileStatus(p);
        if (fs.exists(p)) {
            FileStatus[] fileStatusArr;
            if (file.isFile()) {
                files.$plus$eq((Object)p.toString());
            } else if (file.isDirectory() && (fileStatusArr = fs.listStatus(p)) != null && fileStatusArr.length > 0) {
                Predef$.MODULE$.refArrayOps((Object[])fileStatusArr).foreach((Function1)new Serializable(fs, files){
                    public static final long serialVersionUID = 0L;
                    private final FileSystem fs$1;
                    private final ArrayBuffer files$1;

                    public final void apply(FileStatus tempFile) {
                        HDFSOperator$.MODULE$._iteratorFiles(this.fs$1, tempFile.getPath().toString(), (ArrayBuffer<String>)this.files$1);
                    }
                    {
                        this.fs$1 = fs$1;
                        this.files$1 = files$1;
                    }
                });
            }
        }
    }

    private HDFSOperator$() {
        MODULE$ = this;
    }
}

