/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.hook;

import java.io.File;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import tech.mlsql.common.utils.hook.JVMShutdownHookManager;
import tech.mlsql.common.utils.io.IOTool$;
import tech.mlsql.common.utils.log.Logging;
import tech.mlsql.common.utils.log.Logging$class;

public final class JVMShutdownHookManager$
implements Logging {
    public static final JVMShutdownHookManager$ MODULE$;
    private final int DEFAULT_SHUTDOWN_PRIORITY;
    private final int TEMP_DIR_SHUTDOWN_PRIORITY;
    private JVMShutdownHookManager shutdownHooks;
    private final HashSet<String> tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new JVMShutdownHookManager$();
    }

    /*
     * WARNING - void declaration
     */
    private JVMShutdownHookManager shutdownHooks$lzycompute() {
        JVMShutdownHookManager$ jVMShutdownHookManager$ = this;
        synchronized (jVMShutdownHookManager$) {
            if (!this.bitmap$0) {
                void var2_2;
                JVMShutdownHookManager manager = new JVMShutdownHookManager();
                manager.install();
                this.shutdownHooks = var2_2;
                this.bitmap$0 = true;
            }
            return this.shutdownHooks;
        }
    }

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public int DEFAULT_SHUTDOWN_PRIORITY() {
        return this.DEFAULT_SHUTDOWN_PRIORITY;
    }

    public int TEMP_DIR_SHUTDOWN_PRIORITY() {
        return this.TEMP_DIR_SHUTDOWN_PRIORITY;
    }

    private JVMShutdownHookManager shutdownHooks() {
        return this.bitmap$0 ? this.shutdownHooks : this.shutdownHooks$lzycompute();
    }

    public HashSet<String> tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths() {
        return this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths;
    }

    public void registerShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths();
        synchronized (hashSet) {
            this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths().$plus$eq((Object)absolutePath);
            return;
        }
    }

    public void removeShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths();
        synchronized (hashSet) {
            BoxesRunTime.boxToBoolean((boolean)this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths().remove((Object)absolutePath));
            return;
        }
    }

    public boolean hasShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths();
        synchronized (hashSet) {
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths().contains((Object)absolutePath));
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRootAsShutdownDeleteDir(File file) {
        void var3_5;
        Boolean bl;
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths();
        synchronized (hashSet) {
            bl = BoxesRunTime.boxToBoolean((boolean)this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths().exists((Function1)new Serializable(absolutePath){
                public static final long serialVersionUID = 0L;
                private final String absolutePath$1;

                public final boolean apply(String path) {
                    return !this.absolutePath$1.equals(path) && this.absolutePath$1.startsWith(path);
                }
                {
                    this.absolutePath$1 = absolutePath$1;
                }
            }));
        }
        boolean retval = BoxesRunTime.unboxToBoolean((Object)bl);
        if (retval) {
            this.logInfo((Function0<String>)new Serializable(file){
                public static final long serialVersionUID = 0L;
                private final File file$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"path = ").append((Object)this.file$1).append((Object)", already present as root for deletion.").toString();
                }
                {
                    this.file$1 = file$1;
                }
            });
        }
        return (boolean)var3_5;
    }

    public boolean inShutdown() {
        try {
            Thread hook = new Thread(){

                public void run() {
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
            Runtime.getRuntime().removeShutdownHook(hook);
        }
        catch (IllegalStateException illegalStateException) {
            return true;
        }
        return false;
    }

    public Object addShutdownHook(Function0<BoxedUnit> hook) {
        return this.addShutdownHook(this.DEFAULT_SHUTDOWN_PRIORITY(), hook);
    }

    public Object addShutdownHook(int priority, Function0<BoxedUnit> hook) {
        return this.shutdownHooks().add(priority, hook);
    }

    public boolean removeShutdownHook(Object ref) {
        return this.shutdownHooks().remove(ref);
    }

    private JVMShutdownHookManager$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.DEFAULT_SHUTDOWN_PRIORITY = 100;
        this.TEMP_DIR_SHUTDOWN_PRIORITY = 25;
        this.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths = new HashSet();
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Adding shutdown hook";
            }
        });
        this.addShutdownHook(this.TEMP_DIR_SHUTDOWN_PRIORITY(), (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JVMShutdownHookManager$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Shutdown hook called";
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])JVMShutdownHookManager$.MODULE$.tech$mlsql$common$utils$hook$JVMShutdownHookManager$$shutdownDeletePaths().toArray(ClassTag$.MODULE$.apply(String.class))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String dirPath) {
                        try {
                            JVMShutdownHookManager$.MODULE$.logInfo((Function0<String>)new Serializable(this, dirPath){
                                public static final long serialVersionUID = 0L;
                                private final String dirPath$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Deleting directory ").append((Object)this.dirPath$1).toString();
                                }
                                {
                                    this.dirPath$1 = dirPath$1;
                                }
                            });
                            IOTool$.MODULE$.deleteRecursively(new File(dirPath));
                        }
                        catch (Exception exception) {
                            JVMShutdownHookManager$.MODULE$.logError((Function0<String>)new Serializable(this, dirPath){
                                public static final long serialVersionUID = 0L;
                                private final String dirPath$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while deleting Spark temp dir: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dirPath$1}));
                                }
                                {
                                    this.dirPath$1 = dirPath$1;
                                }
                            }, exception);
                        }
                    }
                });
            }
        });
    }
}

