/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import tech.mlsql.common.utils.base.TryTool$;
import tech.mlsql.common.utils.distribute.socket.server.JavaUtils;
import tech.mlsql.common.utils.hook.JVMShutdownHookManager$;
import tech.mlsql.common.utils.io.ByteStreams;
import tech.mlsql.common.utils.io.Files;
import tech.mlsql.common.utils.io.IOTool$;
import tech.mlsql.common.utils.log.Logging;
import tech.mlsql.common.utils.log.Logging$class;

public final class IOTool$
implements Logging {
    public static final IOTool$ MODULE$;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    static {
        new IOTool$();
    }

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public boolean doesDirectoryContainAnyNewFiles(File dir, long cutoff) {
        if (dir.isDirectory()) {
            File[] filesAndDirs = dir.listFiles();
            long cutoffTimeInMillis = System.currentTimeMillis() - cutoff * 1000L;
            return Predef$.MODULE$.refArrayOps((Object[])filesAndDirs).exists((Function1)new Serializable(cutoffTimeInMillis){
                public static final long serialVersionUID = 0L;
                private final long cutoffTimeInMillis$1;

                public final boolean apply(File x$1) {
                    return x$1.lastModified() > this.cutoffTimeInMillis$1;
                }
                {
                    this.cutoffTimeInMillis$1 = cutoffTimeInMillis$1;
                }
            }) || Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filesAndDirs).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$2) {
                    return x$2.isDirectory();
                }
            })).exists((Function1)new Serializable(cutoff){
                public static final long serialVersionUID = 0L;
                private final long cutoff$1;

                public final boolean apply(File subdir) {
                    return IOTool$.MODULE$.doesDirectoryContainAnyNewFiles(subdir, this.cutoff$1);
                }
                {
                    this.cutoff$1 = cutoff$1;
                }
            });
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a directory!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir})));
    }

    public void deleteRecursively(File file) {
        if (file != null) {
            JavaUtils.deleteRecursively(file);
            JVMShutdownHookManager$.MODULE$.removeShutdownDeleteDir(file);
        }
    }

    /*
     * WARNING - void declaration
     */
    public File createTempDir(String root, String namePrefix) {
        void var3_3;
        File dir = this.createDirectory(root, namePrefix, 10);
        JVMShutdownHookManager$.MODULE$.registerShutdownDeleteDir(dir);
        return var3_3;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public String createTempDir$default$2() {
        return "temp";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File createDirectory(String root, String namePrefix, int maxAttempts) {
        attempts = 0;
        dir = null;
        while (true) {
            if (dir != null) {
                return dir.getCanonicalFile();
            }
            if (++attempts <= maxAttempts) ** GOTO lbl-1000
            throw new IOException(new StringBuilder().append((Object)"Failed to create a temp directory (under ").append((Object)root).append((Object)") after ").append((Object)BoxesRunTime.boxToInteger((int)maxAttempts)).append((Object)" attempts!").toString());
lbl-1000:
            // 1 sources

            {
                dir = new File(root, new StringBuilder().append((Object)namePrefix).append((Object)"-").append((Object)UUID.randomUUID().toString()).toString());
                if (!dir.exists() && dir.mkdirs()) continue;
                dir = null;
                continue;
            }
            break;
        }
    }

    public String createDirectory$default$2() {
        return "temp";
    }

    public boolean chmod700(File file) {
        return file.setReadable(false, false) && file.setReadable(true, true) && file.setWritable(false, false) && file.setWritable(true, true) && file.setExecutable(false, false) && file.setExecutable(true, true);
    }

    public void writeByteBuffer(ByteBuffer bb, DataOutput out) {
        if (bb.hasArray()) {
            out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        } else {
            int originalPosition = bb.position();
            byte[] bbval = new byte[bb.remaining()];
            bb.get(bbval);
            out.write(bbval);
            bb.position(originalPosition);
        }
    }

    public void writeByteBuffer(ByteBuffer bb, OutputStream out) {
        if (bb.hasArray()) {
            out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        } else {
            int originalPosition = bb.position();
            byte[] bbval = new byte[bb.remaining()];
            bb.get(bbval);
            out.write(bbval);
            bb.position(originalPosition);
        }
    }

    public long copyStream(InputStream in, OutputStream out, boolean closeStreams, boolean transferToEnabled) {
        return BoxesRunTime.unboxToLong(TryTool$.MODULE$.tryWithSafeFinally(new Serializable(in, out, transferToEnabled){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;
            private final OutputStream out$1;
            private final boolean transferToEnabled$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            /*
             * WARNING - void declaration
             */
            public long apply$mcJ$sp() {
                long l;
                if (this.in$1 instanceof FileInputStream && this.out$1 instanceof FileOutputStream && this.transferToEnabled$1) {
                    void var3_3;
                    FileChannel inChannel = ((FileInputStream)this.in$1).getChannel();
                    FileChannel outChannel = ((FileOutputStream)this.out$1).getChannel();
                    long size = inChannel.size();
                    IOTool$.MODULE$.copyFileStreamNIO(inChannel, outChannel, 0L, size);
                    l = var3_3;
                } else {
                    long count = 0L;
                    byte[] buf = new byte[8192];
                    int n = 0;
                    while (n != -1) {
                        n = this.in$1.read(buf);
                        if (n == -1) continue;
                        this.out$1.write(buf, 0, n);
                        count += (long)n;
                    }
                    l = count;
                }
                return l;
            }
            {
                this.in$1 = in$1;
                this.out$1 = out$1;
                this.transferToEnabled$1 = transferToEnabled$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(in, out, closeStreams){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;
            private final OutputStream out$1;
            private final boolean closeStreams$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.closeStreams$1) {
                    this.in$1.close();
                }
                return;
                finally {
                    this.out$1.close();
                }
            }
            {
                this.in$1 = in$1;
                this.out$1 = out$1;
                this.closeStreams$1 = closeStreams$1;
            }
        }));
    }

    public boolean copyStream$default$3() {
        return false;
    }

    public boolean copyStream$default$4() {
        return false;
    }

    public void copyFileStreamNIO(FileChannel input, FileChannel output, long startPosition, long bytesToCopy) {
        long initialPos = output.position();
        LongRef count = LongRef.create((long)0L);
        while (count.elem < bytesToCopy) {
            count.elem += input.transferTo(count.elem + startPosition, bytesToCopy - count.elem, output);
        }
        Predef$.MODULE$.assert(count.elem == bytesToCopy, (Function0)new Serializable(bytesToCopy, count){
            public static final long serialVersionUID = 0L;
            private final long bytesToCopy$1;
            private final LongRef count$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request to copy ", " bytes, but actually copied ", " bytes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.bytesToCopy$1), BoxesRunTime.boxToLong((long)this.count$1.elem)}));
            }
            {
                this.bytesToCopy$1 = bytesToCopy$1;
                this.count$1 = count$1;
            }
        });
        long finalPos = output.position();
        long expectedPos = initialPos + bytesToCopy;
        Predef$.MODULE$.assert(finalPos == expectedPos, (Function0)new Serializable(finalPos, expectedPos){
            public static final long serialVersionUID = 0L;
            private final long finalPos$1;
            private final long expectedPos$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |Current position ", " do not equal to expected position ", "\n         |after transferTo, please check your kernel version to see if it is 2.6.32,\n         |this is a kernel bug which will lead to unexpected behavior when using transferTo.\n         |You can set spark.file.transferTo = false to disable this NIO feature.\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.finalPos$1), BoxesRunTime.boxToLong((long)this.expectedPos$1)})))).stripMargin();
            }
            {
                this.finalPos$1 = finalPos$1;
                this.expectedPos$1 = expectedPos$1;
            }
        });
    }

    public String encodeFileNameToURIRawPath(String fileName) {
        Predef$.MODULE$.require(!fileName.contains("/") && !fileName.contains("\\"));
        return new URI("file", null, "localhost", -1, new StringBuilder().append((Object)"/").append((Object)fileName).toString(), null, null).getRawPath().substring(1);
    }

    public String decodeFileNameInURI(URI uri) {
        String rawPath = uri.getRawPath();
        String rawFileName = (String)Predef$.MODULE$.refArrayOps((Object[])rawPath.split("/")).last();
        return new URI(new StringBuilder().append((Object)"file:///").append((Object)rawFileName).toString()).getPath().substring(1);
    }

    public <T> Tuple2<T, Object> timeTakenMs(Function0<T> body) {
        long startTime = System.nanoTime();
        Object result = body.apply();
        long endTime = System.nanoTime();
        return new Tuple2(result, (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(TimeUnit.NANOSECONDS.toMillis(endTime - startTime), 0L)));
    }

    private void downloadFile(String url, InputStream in, File destFile, boolean fileOverwrite) {
        File tempFile = File.createTempFile("fetchFileTemp", null, new File(destFile.getParentFile().getAbsolutePath()));
        this.logInfo((Function0<String>)new Serializable(url, tempFile){
            public static final long serialVersionUID = 0L;
            private final String url$1;
            private final File tempFile$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$1, this.tempFile$1}));
            }
            {
                this.url$1 = url$1;
                this.tempFile$1 = tempFile$1;
            }
        });
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            this.copyStream(in, out, true, this.copyStream$default$4());
            this.copyFile(url, tempFile, destFile, fileOverwrite, true);
            return;
        }
        finally {
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    private void copyFile(String url, File sourceFile, File destFile, boolean fileOverwrite, boolean removeSourceFile) {
        if (destFile.exists()) {
            if (this.tech$mlsql$common$utils$io$IOTool$$filesEqualRecursive(sourceFile, destFile)) {
                this.logInfo((Function0<String>)new Serializable(sourceFile, destFile){
                    public static final long serialVersionUID = 0L;
                    private final File sourceFile$1;
                    private final File destFile$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("%s has been previously copied to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sourceFile$1.getAbsolutePath(), this.destFile$1.getAbsolutePath()}));
                    }
                    {
                        this.sourceFile$1 = sourceFile$1;
                        this.destFile$1 = destFile$1;
                    }
                });
                return;
            }
            if (fileOverwrite) {
                this.logInfo((Function0<String>)new Serializable(url, destFile){
                    public static final long serialVersionUID = 0L;
                    private final String url$2;
                    private final File destFile$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " exists and does not match contents of ", ", replacing it with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.destFile$1, this.url$2, this.url$2}));
                    }
                    {
                        this.url$2 = url$2;
                        this.destFile$1 = destFile$1;
                    }
                });
                if (!destFile.delete()) {
                    throw new IOException(new StringOps(Predef$.MODULE$.augmentString("Failed to delete %s while attempting to overwrite it with %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destFile.getAbsolutePath(), sourceFile.getAbsolutePath()})));
                }
            } else {
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " exists and does not match contents of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destFile, url})));
            }
        }
        if (removeSourceFile) {
            java.nio.file.Files.move(sourceFile.toPath(), destFile.toPath(), new CopyOption[0]);
        } else {
            this.logInfo((Function0<String>)new Serializable(sourceFile, destFile){
                public static final long serialVersionUID = 0L;
                private final File sourceFile$1;
                private final File destFile$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copying ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sourceFile$1.getAbsolutePath(), this.destFile$1.getAbsolutePath()}));
                }
                {
                    this.sourceFile$1 = sourceFile$1;
                    this.destFile$1 = destFile$1;
                }
            });
            this.tech$mlsql$common$utils$io$IOTool$$copyRecursive(sourceFile, destFile);
        }
    }

    private boolean copyFile$default$5() {
        return false;
    }

    public boolean tech$mlsql$common$utils$io$IOTool$$filesEqualRecursive(File file1, File file2) {
        boolean bl;
        if (file1.isDirectory() && file2.isDirectory()) {
            File[] subfiles1 = file1.listFiles();
            File[] subfiles2 = file2.listFiles();
            if (Predef$.MODULE$.refArrayOps((Object[])subfiles1).size() != Predef$.MODULE$.refArrayOps((Object[])subfiles2).size()) {
                return false;
            }
            bl = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])subfiles1).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(File x$3) {
                    return x$3.getName();
                }
            }, (Ordering)Ordering.String$.MODULE$)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])subfiles2).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(File x$4) {
                    return x$4.getName();
                }
            }, (Ordering)Ordering.String$.MODULE$)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<File, File> x0$1) {
                    Tuple2<File, File> tuple2 = x0$1;
                    if (tuple2 != null) {
                        File f1 = (File)tuple2._1();
                        File f2 = (File)tuple2._2();
                        boolean bl = IOTool$.MODULE$.tech$mlsql$common$utils$io$IOTool$$filesEqualRecursive(f1, f2);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            });
        } else {
            bl = file1.isFile() && file2.isFile() ? Files.equal(file1, file2) : false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tech$mlsql$common$utils$io$IOTool$$copyRecursive(File source, File dest) {
        if (source.isDirectory()) {
            if (!dest.mkdir()) throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dest.getPath()})));
            File[] subfiles = source.listFiles();
            Predef$.MODULE$.refArrayOps((Object[])subfiles).foreach((Function1)new Serializable(dest){
                public static final long serialVersionUID = 0L;
                private final File dest$1;

                public final void apply(File f) {
                    IOTool$.MODULE$.tech$mlsql$common$utils$io$IOTool$$copyRecursive(f, new File(this.dest$1, f.getName()));
                }
                {
                    this.dest$1 = dest$1;
                }
            });
            return;
        } else {
            java.nio.file.Files.copy(source.toPath(), dest.toPath(), new CopyOption[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateURL(URI uri) throws MalformedURLException {
        String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "file";
            }
        });
        boolean bl = "http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string));
        if (!bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        try {
            uri.toURL();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException ex = new MalformedURLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"URI (", ") is not a valid URL."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.toString()})));
            ex.initCause(malformedURLException);
            throw ex;
        }
    }

    public File tempFileWith(File path) {
        return new File(new StringBuilder().append((Object)path.getAbsolutePath()).append((Object)".").append((Object)UUID.randomUUID()).toString());
    }

    public <T> Seq<T> randomize(TraversableOnce<T> seq, ClassTag<T> evidence$1) {
        return Predef$.MODULE$.genericWrapArray(this.randomizeInPlace(seq.toArray(evidence$1), this.randomizeInPlace$default$2()));
    }

    public <T> Object randomizeInPlace(Object arr, Random rand) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(arr) - 1), 1).by(-1).foreach$mVc$sp((Function1)new Serializable(arr, rand){
            public static final long serialVersionUID = 0L;
            private final Object arr$1;
            private final Random rand$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int j = this.rand$1.nextInt(i + 1);
                Object tmp = ScalaRunTime$.MODULE$.array_apply(this.arr$1, j);
                ScalaRunTime$.MODULE$.array_update(this.arr$1, j, ScalaRunTime$.MODULE$.array_apply(this.arr$1, i));
                ScalaRunTime$.MODULE$.array_update(this.arr$1, i, tmp);
            }
            {
                this.arr$1 = arr$1;
                this.rand$1 = rand$1;
            }
        });
        return arr;
    }

    public <T> Random randomizeInPlace$default$2() {
        return new Random();
    }

    public long getFileLength(File file) {
        return file.getName().endsWith(".gz") ? this.getCompressedFileLength(file) : file.length();
    }

    private long getCompressedFileLength(File file) {
        long l;
        block6: {
            GZIPInputStream gzInputStream = null;
            try {
                long fileSize = 0L;
                gzInputStream = new GZIPInputStream(new FileInputStream(file));
                int bufSize = 1024;
                byte[] buf = new byte[bufSize];
                int numBytes = ByteStreams.read(gzInputStream, buf, 0, bufSize);
                while (numBytes > 0) {
                    fileSize += (long)numBytes;
                    numBytes = ByteStreams.read(gzInputStream, buf, 0, bufSize);
                }
                l = fileSize;
                if (gzInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    this.logError((Function0<String>)new Serializable(file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot get file length of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                        }
                        {
                            this.file$1 = file$1;
                        }
                    }, throwable);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (gzInputStream != null) {
                        gzInputStream.close();
                    }
                    throw throwable2;
                }
            }
            gzInputStream.close();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public String offsetBytes(String path, long length, long start, long end) {
        File file = new File(path);
        long effectiveEnd = package$.MODULE$.min(length, end);
        long effectiveStart = package$.MODULE$.max(0L, start);
        byte[] buff = new byte[(int)(effectiveEnd - effectiveStart)];
        InputStream stream = path.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        try {
            ByteStreams.skipFully(stream, effectiveStart);
            ByteStreams.readFully(stream, buff);
        }
        catch (Throwable throwable) {
            void var14_9;
            var14_9.close();
            throw throwable;
        }
        stream.close();
        return Source$.MODULE$.fromBytes(buff, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String offsetBytes(Seq<File> files, Seq<Object> fileLengths, long start, long end) {
        Predef$.MODULE$.assert(files.length() == fileLengths.length());
        long startIndex = package$.MODULE$.max(start, 0L);
        long endIndex = package$.MODULE$.min(end, BoxesRunTime.unboxToLong((Object)fileLengths.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Map fileToLength = ((TraversableOnce)files.zip(fileLengths, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.logDebug((Function0<String>)new Serializable(fileToLength){
            public static final long serialVersionUID = 0L;
            private final Map fileToLength$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Log files: \n").append((Object)this.fileToLength$1.mkString("\n")).toString();
            }
            {
                this.fileToLength$1 = fileToLength$1;
            }
        });
        StringBuffer stringBuffer = new StringBuffer((int)(endIndex - startIndex));
        LongRef sum = LongRef.create((long)0L);
        ((IterableLike)files.zip(fileLengths, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(startIndex, endIndex, fileToLength, stringBuffer, sum){
            public static final long serialVersionUID = 0L;
            private final long startIndex$1;
            public final long endIndex$1;
            private final Map fileToLength$1;
            public final StringBuffer stringBuffer$1;
            private final LongRef sum$1;

            public final void apply(Tuple2<File, Object> x0$2) {
                Tuple2<File, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object object;
                    File file = (File)tuple2._1();
                    long fileLength = tuple2._2$mcJ$sp();
                    long startIndexOfFile = this.sum$1.elem;
                    long endIndexOfFile = this.sum$1.elem + BoxesRunTime.unboxToLong((Object)this.fileToLength$1.apply((Object)file));
                    IOTool$.MODULE$.logDebug((Function0<String>)new Serializable(this, file, startIndexOfFile){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.offsetBytes.2 $outer;
                        private final File file$2;
                        private final long startIndexOfFile$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing file ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with start index = ", ", end index = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startIndexOfFile$1), BoxesRunTime.boxToLong((long)this.$outer.endIndex$1)}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.file$2 = file$2;
                            this.startIndexOfFile$1 = startIndexOfFile$1;
                        }
                    });
                    if (this.startIndex$1 <= startIndexOfFile && this.endIndex$1 >= endIndexOfFile) {
                        object = this.stringBuffer$1.append(IOTool$.MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, 0L, BoxesRunTime.unboxToLong((Object)this.fileToLength$1.apply((Object)file))));
                    } else if (this.startIndex$1 > startIndexOfFile && this.startIndex$1 < endIndexOfFile) {
                        long effectiveStartIndex = this.startIndex$1 - startIndexOfFile;
                        long effectiveEndIndex = package$.MODULE$.min(this.endIndex$1 - startIndexOfFile, BoxesRunTime.unboxToLong((Object)this.fileToLength$1.apply((Object)file)));
                        object = this.stringBuffer$1.append(IOTool$.MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
                    } else if (this.endIndex$1 > startIndexOfFile && this.endIndex$1 < endIndexOfFile) {
                        long effectiveStartIndex = package$.MODULE$.max(this.startIndex$1 - startIndexOfFile, 0L);
                        long effectiveEndIndex = this.endIndex$1 - startIndexOfFile;
                        object = this.stringBuffer$1.append(IOTool$.MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.sum$1.elem += BoxesRunTime.unboxToLong((Object)this.fileToLength$1.apply((Object)file));
                    IOTool$.MODULE$.logDebug((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.offsetBytes.2 $outer;
                        private final File file$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"After processing file ", ", string built is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2, this.$outer.stringBuffer$1.toString()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.file$2 = file$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.startIndex$1 = startIndex$1;
                this.endIndex$1 = endIndex$1;
                this.fileToLength$1 = fileToLength$1;
                this.stringBuffer$1 = stringBuffer$1;
                this.sum$1 = sum$1;
            }
        });
        return stringBuffer.toString();
    }

    public void symlink(File src, File dst) {
        if (src.isAbsolute()) {
            if (dst.isAbsolute()) {
                throw new IOException("Destination must be relative");
            }
            java.nio.file.Files.createSymbolicLink(dst.toPath(), src.toPath(), new FileAttribute[0]);
            return;
        }
        throw new IOException("Source must be absolute");
    }

    public FileSystem getHadoopFileSystem(URI path, Configuration conf) {
        return FileSystem.get((URI)path, (Configuration)conf);
    }

    public FileSystem getHadoopFileSystem(String path, Configuration conf) {
        return this.getHadoopFileSystem(new URI(path), conf);
    }

    public boolean isInDirectory(File parent, File child) {
        while (true) {
            if (child == null || parent == null) {
                return false;
            }
            if (!child.exists() || !parent.exists() || !parent.isDirectory()) break;
            if (parent.equals(child)) {
                return true;
            }
            child = child.getParentFile();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getPropertiesFromFile(String filename) {
        Map map;
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Properties file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$3}));
            }
            {
                this.file$3 = file$3;
            }
        });
        Predef$.MODULE$.require(file.isFile(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Properties file ", " is not a normal file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$3}));
            }
            {
                this.file$3 = file$3;
            }
        });
        InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        try {
            Properties properties = new Properties();
            properties.load(inReader);
            map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1)new Serializable(properties){
                public static final long serialVersionUID = 0L;
                private final Properties properties$1;

                public final Tuple2<String, String> apply(String k) {
                    return new Tuple2((Object)k, (Object)IOTool$.MODULE$.tech$mlsql$common$utils$io$IOTool$$trimExceptCRLF(this.properties$1.getProperty(k)));
                }
                {
                    this.properties$1 = properties$1;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading Spark properties from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})), iOException);
            }
            catch (Throwable throwable) {
                void var3_3;
                var3_3.close();
                throw throwable;
            }
        }
        inReader.close();
        return map;
    }

    public String tech$mlsql$common$utils$io$IOTool$$trimExceptCRLF(String str) {
        Serializable nonSpaceOrNaturalLineDelimiter = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char ch) {
                return ch > ' ' || ch == '\r' || ch == '\n';
            }
        };
        int firstPos = new StringOps(Predef$.MODULE$.augmentString(str)).indexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        int lastPos = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        return firstPos >= 0 && lastPos >= 0 ? str.substring(firstPos, lastPos + 1) : "";
    }

    public void writeUTF(String str, DataOutputStream dataOut) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        dataOut.write(bytes);
    }

    private IOTool$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

