/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.kv;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import tech.mlsql.common.utils.base.Preconditions;
import tech.mlsql.common.utils.kv.KVIndex;

public class KVTypeInfo {
    private final Class<?> type;
    private final Map<String, KVIndex> indices;
    private final Map<String, Accessor> accessors;

    public KVTypeInfo(Class<?> type) throws Exception {
        KVIndex idx;
        this.type = type;
        this.accessors = new HashMap<String, Accessor>();
        this.indices = new HashMap<String, KVIndex>();
        for (Field field : type.getDeclaredFields()) {
            idx = field.getAnnotation(KVIndex.class);
            if (idx == null) continue;
            this.checkIndex(idx, this.indices);
            field.setAccessible(true);
            this.indices.put(idx.value(), idx);
            field.setAccessible(true);
            this.accessors.put(idx.value(), new FieldAccessor(field));
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            idx = ((Method)accessibleObject).getAnnotation(KVIndex.class);
            if (idx == null) continue;
            this.checkIndex(idx, this.indices);
            Preconditions.checkArgument(((Method)accessibleObject).getParameterTypes().length == 0, "Annotated method %s::%s should not have any parameters.", type.getName(), ((Method)accessibleObject).getName());
            ((Method)accessibleObject).setAccessible(true);
            this.indices.put(idx.value(), idx);
            ((Method)accessibleObject).setAccessible(true);
            this.accessors.put(idx.value(), new MethodAccessor((Method)accessibleObject));
        }
        Preconditions.checkArgument(this.indices.containsKey("__main__"), "No natural index defined for type %s.", type.getName());
        Preconditions.checkArgument(this.indices.get("__main__").parent().isEmpty(), "Natural index of %s cannot have a parent.", type.getName());
        for (KVIndex idx2 : this.indices.values()) {
            if (idx2.parent().isEmpty()) continue;
            KVIndex parent = this.indices.get(idx2.parent());
            Preconditions.checkArgument(parent != null, "Cannot find parent %s of index %s.", idx2.parent(), idx2.value());
            Preconditions.checkArgument(parent.parent().isEmpty(), "Parent index %s of index %s cannot be itself a child index.", idx2.parent(), idx2.value());
        }
    }

    private void checkIndex(KVIndex idx, Map<String, KVIndex> indices) {
        Preconditions.checkArgument(idx.value() != null && !idx.value().isEmpty(), "No name provided for index in type %s.", this.type.getName());
        Preconditions.checkArgument(!idx.value().startsWith("_") || idx.value().equals("__main__"), "Index name %s (in type %s) is not allowed.", idx.value(), this.type.getName());
        Preconditions.checkArgument(idx.parent().isEmpty() || !idx.parent().equals(idx.value()), "Index %s cannot be parent of itself.", idx.value());
        Preconditions.checkArgument(!indices.containsKey(idx.value()), "Duplicate index %s for type %s.", idx.value(), this.type.getName());
    }

    public Class<?> type() {
        return this.type;
    }

    public Object getIndexValue(String indexName, Object instance) throws Exception {
        return this.getAccessor(indexName).get(instance);
    }

    public Stream<KVIndex> indices() {
        return this.indices.values().stream();
    }

    Accessor getAccessor(String indexName) {
        Accessor a = this.accessors.get(indexName);
        Preconditions.checkArgument(a != null, "No index %s.", indexName);
        return a;
    }

    Accessor getParentAccessor(String indexName) {
        KVIndex index = this.indices.get(indexName);
        return index.parent().isEmpty() ? null : this.getAccessor(index.parent());
    }

    private class MethodAccessor
    implements Accessor {
        private final Method method;

        MethodAccessor(Method method) {
            this.method = method;
        }

        @Override
        public Object get(Object instance) throws Exception {
            return this.method.invoke(instance, new Object[0]);
        }
    }

    private class FieldAccessor
    implements Accessor {
        private final Field field;

        FieldAccessor(Field field) {
            this.field = field;
        }

        @Override
        public Object get(Object instance) throws Exception {
            return this.field.get(instance);
        }
    }

    static interface Accessor {
        public Object get(Object var1) throws Exception;
    }
}

