/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.lang.py;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class JythonUtils {
    public static Object toJava(PyObject pyObject) {
        try {
            Object javaObj = null;
            if (pyObject instanceof PyTuple) {
                PyTuple pyTuple = (PyTuple)pyObject;
                Object[] tuple = new Object[pyTuple.size()];
                int i = 0;
                for (PyObject tupleObject : pyTuple.getArray()) {
                    tuple[i++] = JythonUtils.toJava(tupleObject);
                }
                javaObj = Arrays.asList(tuple);
            } else if (pyObject instanceof PyList) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (PyObject bagTuple : ((PyList)pyObject).asIterable()) {
                    list.add(JythonUtils.toJava(bagTuple));
                }
                javaObj = list;
            } else if (pyObject instanceof PyDictionary) {
                java.util.Map map = (java.util.Map)Py.tojava((PyObject)pyObject, java.util.Map.class);
                HashMap newMap = new HashMap();
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() instanceof PyObject) {
                        newMap.put(entry.getKey(), JythonUtils.toJava((PyObject)entry.getValue()));
                        continue;
                    }
                    newMap.put(entry.getKey(), entry.getValue());
                }
                javaObj = newMap;
            } else if (pyObject instanceof PyLong) {
                javaObj = pyObject.__tojava__(Long.class);
            } else if (pyObject instanceof PyInteger) {
                javaObj = pyObject.__tojava__(Integer.class);
            } else if (pyObject instanceof PyFloat) {
                javaObj = pyObject.__tojava__(Double.class);
            } else if (pyObject instanceof PyString) {
                javaObj = pyObject.__tojava__(String.class);
            } else if (pyObject instanceof PyBoolean) {
                javaObj = pyObject.__tojava__(Boolean.class);
            } else {
                if (pyObject instanceof PyNone) {
                    return null;
                }
                javaObj = pyObject.__tojava__(byte[].class);
                if (!(javaObj instanceof byte[])) {
                    throw new RuntimeException("Non supported pig datatype found, cast failed: " + (pyObject == null ? null : pyObject.getClass().getName()));
                }
            }
            if (javaObj.equals(Py.NoConversion)) {
                throw new RuntimeException("Cannot cast into any pig supported type: " + (pyObject == null ? null : pyObject.getClass().getName()));
            }
            return javaObj;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert jython type (" + (pyObject == null ? null : pyObject.getClass().getName()) + ") to pig datatype " + e, e);
        }
    }

    public static PyObject toPy(Object o) {
        if (o instanceof List) {
            Iterator converter = ((List)o).stream().map(JythonUtils::toPy).iterator();
            return new PyList(converter);
        }
        if (o instanceof Seq) {
            Collection converter = JavaConverters.asJavaCollectionConverter((Iterable)((Seq)o)).asJavaCollection();
            return JythonUtils.toPy(new ArrayList(converter));
        }
        if (o instanceof scala.collection.immutable.Map) {
            java.util.Map converter = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)((scala.collection.immutable.Map)o)).asJava();
            return JythonUtils.toPy(converter);
        }
        if (o instanceof java.util.Map) {
            PyDictionary dictionary = new PyDictionary();
            ((java.util.Map)o).entrySet().stream().map(v -> new AbstractMap.SimpleEntry<PyObject, PyObject>(JythonUtils.toPy(v.getKey()), JythonUtils.toPy(v.getValue()))).forEach(v -> dictionary.put(v.getKey(), v.getValue()));
            return dictionary;
        }
        if (o instanceof Integer) {
            return new PyInteger(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return new PyLong(((Long)o).longValue());
        }
        if (o instanceof Float) {
            return new PyFloat(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new PyFloat(((Double)o).doubleValue());
        }
        if (o instanceof Boolean) {
            return new PyBoolean(((Boolean)o).booleanValue());
        }
        if (o == null) {
            return Py.None;
        }
        if (o instanceof Character) {
            return Py.newStringOrUnicode((String)((Character)o).toString());
        }
        if (o instanceof String) {
            return Py.newStringOrUnicode((String)((String)o));
        }
        throw new RuntimeException(o.getClass().getCanonicalName() + " can not been converted to python object");
    }
}

