/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.shell;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import tech.mlsql.common.utils.log.Logging;
import tech.mlsql.common.utils.log.Logging$class;
import tech.mlsql.common.utils.shell.AsyncShellCommand;
import tech.mlsql.common.utils.shell.ShellExecuteStatus;

public final class AsyncShellCommand$
implements Logging {
    public static final AsyncShellCommand$ MODULE$;
    private final HashMap<String, Tuple2<AsyncShellCommand, Object>> shellsInfo;
    private final ArrayBuffer<String> removeList;
    private final ScheduledExecutorService schedule;
    private final int maxTimeIdle;
    private final long defaultTimeOut;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    static {
        new AsyncShellCommand$();
    }

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public HashMap<String, Tuple2<AsyncShellCommand, Object>> shellsInfo() {
        return this.shellsInfo;
    }

    public ArrayBuffer<String> removeList() {
        return this.removeList;
    }

    public ScheduledExecutorService schedule() {
        return this.schedule;
    }

    public int maxTimeIdle() {
        return this.maxTimeIdle;
    }

    public long defaultTimeOut() {
        return this.defaultTimeOut;
    }

    public String start(String command, String token, boolean isInteractive) {
        return this.startWithTimeout(command, token, this.defaultTimeOut(), isInteractive);
    }

    public boolean start$default$3() {
        return false;
    }

    public String startWithTimeout(String command, String token, long timeout, boolean isInteractive) {
        return this.startWithUserAndTimeout("", command, token, timeout, isInteractive);
    }

    public boolean startWithTimeout$default$4() {
        return false;
    }

    public String startWithUserAndTimeout(String user, String command, String token, long timeout, boolean isInteractive) {
        if (isInteractive) {
            this.logInfo((Function0<String>)new Serializable(command, token){
                public static final long serialVersionUID = 0L;
                private final String command$1;
                private final String token$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initial interactive shell ", " with token ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command$1, this.token$1}));
                }
                {
                    this.command$1 = command$1;
                    this.token$1 = token$1;
                }
            });
        }
        AsyncShellCommand shellCommand = new AsyncShellCommand(user, command, token, timeout, isInteractive);
        this.shellsInfo().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)shellCommand.taskId()), (Object)new Tuple2((Object)shellCommand, (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()))));
        return shellCommand.taskId();
    }

    public boolean startWithUserAndTimeout$default$5() {
        return false;
    }

    public Tuple2<ShellExecuteStatus, Tuple2<Object, String>> progress(String taskId, long offset) {
        Tuple2 tuple2;
        if (this.shellsInfo().contains((Object)taskId)) {
            AsyncShellCommand isc = (AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1();
            tuple2 = new Tuple2((Object)new ShellExecuteStatus(isc.isFinished().get(), isc.isTimeout().get(), isc.exitValue().get() != 0), ((AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1()).progress(offset));
        } else {
            tuple2 = new Tuple2((Object)new ShellExecuteStatus(false, false, false), (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)-1L), (Object)"no message"));
        }
        return tuple2;
    }

    public long progress$default$2() {
        return 0L;
    }

    public void execute(String taskId, String line) {
        this.logInfo((Function0<String>)new Serializable(taskId, line){
            public static final long serialVersionUID = 0L;
            private final String taskId$1;
            private final String line$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"task ", " in interactive mode. execute input ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskId$1, this.line$1}));
            }
            {
                this.taskId$1 = taskId$1;
                this.line$1 = line$1;
            }
        });
        try {
            ((AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1()).execute(line);
            return;
        }
        finally {
            this.shellsInfo().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)taskId), (Object)new Tuple2(((Tuple2)this.shellsInfo().apply((Object)taskId))._1(), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()))));
        }
    }

    public void close(String taskId) {
        if (this.shellsInfo().contains((Object)taskId)) {
            ((AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1()).close();
        }
    }

    public void close(String taskId, String command) {
        if (this.shellsInfo().contains((Object)taskId)) {
            ((AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1()).closeWithExitCommand(command);
        }
    }

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    private AsyncShellCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.shellsInfo = new HashMap();
        this.removeList = new ArrayBuffer();
        this.schedule = Executors.newScheduledThreadPool(1000);
        this.maxTimeIdle = 10800000;
        this.defaultTimeOut = 300000L;
        this.schedule().schedule(new Runnable(){

            public void run() {
                try {
                    AsyncShellCommand$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"schedule to clean up tasks expired without any operation in 3 hours"})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    ((IterableLike)((TraversableLike)AsyncShellCommand$.MODULE$.shellsInfo().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, Tuple2<AsyncShellCommand, Object>> f) {
                            return System.currentTimeMillis() - ((Tuple2)f._2())._2$mcJ$sp() > (long)AsyncShellCommand$.MODULE$.maxTimeIdle();
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, Tuple2<AsyncShellCommand, Object>> f) {
                            return (String)f._1();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(String f) {
                            Option option;
                            block4: {
                                Object object;
                                block3: {
                                    block2: {
                                        AsyncShellCommand$.MODULE$.logInfo((Function0<String>)new Serializable(this, f){
                                            public static final long serialVersionUID = 0L;
                                            private final String f$1;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"clean up task ", " cause this task without any operation in 3 hours"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f$1}));
                                            }
                                            {
                                                this.f$1 = f$1;
                                            }
                                        });
                                        option = AsyncShellCommand$.MODULE$.shellsInfo().remove((Object)f);
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        Tuple2 i = (Tuple2)some.x();
                                        ((AsyncShellCommand)i._1()).close();
                                        object = ((AsyncShellCommand)i._1()).removeTempFile();
                                        break block3;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block4;
                                    object = BoxedUnit.UNIT;
                                }
                                return object;
                            }
                            throw new MatchError((Object)option);
                        }
                    });
                }
                catch (Exception exception) {
                    AsyncShellCommand$.MODULE$.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "schedule to clean up tasks expired without any operation in 3 hours failed,please check error log";
                        }
                    }, exception);
                }
            }
        }, 10L, TimeUnit.SECONDS);
    }
}

