/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.cluster.ml;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import tech.mlsql.common.utils.cluster.ml.ClusterSpecRequest;
import tech.mlsql.common.utils.cluster.ml.ClusterSpecResponse;
import tech.mlsql.common.utils.cluster.ml.JobStatusRequest;
import tech.mlsql.common.utils.cluster.ml.JobStatusResponse;
import tech.mlsql.common.utils.cluster.ml.MLClient;
import tech.mlsql.common.utils.cluster.ml.ReportToMasterRequest;
import tech.mlsql.common.utils.cluster.ml.ReportToMasterResponse;
import tech.mlsql.common.utils.cluster.ml.WorkerInfo;
import tech.mlsql.common.utils.log.Logging;

@ScalaSignature(bytes="\u0006\u0001\u0005}c!B\f\u0019\u0003\u0003)\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011y\u0002!\u0011!Q\u0001\n}BQA\u0011\u0001\u0005\u0002\rCq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0003Q\u0006BB1\u0001A\u0003%1\fC\u0004c\u0001\t\u0007I\u0011A2\t\r\u001d\u0004\u0001\u0015!\u0003e\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u00159\b\u0001\"\u0001y\u0011\u0015a\bA\"\u0001~\u0011\u0019\tI\u0001\u0001D\u0001{\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011%\tY\u0004AI\u0001\n\u0003\ti\u0004C\u0004\u0002T\u0001!\t!!\u0016\t\u0013\u0005u\u0003!%A\u0005\u0002\u0005u\"!D'M/>\u00148.\u001a:Qe>D\u0018P\u0003\u0002\u001a5\u0005\u0011Q\u000e\u001c\u0006\u00037q\tqa\u00197vgR,'O\u0003\u0002\u001e=\u0005)Q\u000f^5mg*\u0011q\u0004I\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005\u0012\u0013!B7mgFd'\"A\u0012\u0002\tQ,7\r[\u0002\u0001'\r\u0001a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=b\u0012a\u00017pO&\u0011\u0011G\f\u0002\b\u0019><w-\u001b8h\u0003)i\u0017m\u001d;fe\"{7\u000f\u001e\t\u0003imr!!N\u001d\u0011\u0005YBS\"A\u001c\u000b\u0005a\"\u0013A\u0002\u001fs_>$h(\u0003\u0002;Q\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQ\u0004&\u0001\u0006nCN$XM\u001d)peR\u0004\"a\n!\n\u0005\u0005C#aA%oi\u00061A(\u001b8jiz\"2\u0001\u0012$H!\t)\u0005!D\u0001\u0019\u0011\u0015\u00114\u00011\u00014\u0011\u0015q4\u00011\u0001@\u00031i\u0017m\u001d;fe\u000ec\u0017.\u001a8u+\u0005Q\u0005CA#L\u0013\ta\u0005D\u0001\u0005N\u0019\u000ec\u0017.\u001a8u\u00035i\u0017m\u001d;fe\u000ec\u0017.\u001a8uA\u000511o\\2lKR,\u0012\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000b1A\\3u\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\rM{7m[3u\u0003\u001d\u0019xnY6fi\u0002\n!\u0003\u001a:jm\u0016\u0014x*\u001e;qkR\u001cFO]3b[V\t1\f\u0005\u0002]?6\tQL\u0003\u0002_)\u0006\u0011\u0011n\\\u0005\u0003Av\u0013\u0001\u0003R1uC>+H\u000f];u'R\u0014X-Y7\u0002'\u0011\u0014\u0018N^3s\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0011\u0002#\u0011\u0014\u0018N^3s\u0013:\u0004X\u000f^*ue\u0016\fW.F\u0001e!\taV-\u0003\u0002g;\nyA)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\nee&4XM]%oaV$8\u000b\u001e:fC6\u0004\u0013!B2m_N,W#\u00016\u0011\u0005\u001dZ\u0017B\u00017)\u0005\u0011)f.\u001b;\u0002\u001dI,\u0007o\u001c:u)>l\u0015m\u001d;feR\u0011qN\u001d\t\u0003\u000bBL!!\u001d\r\u0003-I+\u0007o\u001c:u)>l\u0015m\u001d;feJ+7\u000f]8og\u0016DQa]\u0007A\u0002Q\f1A\u001d;s!\t)U/\u0003\u0002w1\t)\"+\u001a9peR$v.T1ti\u0016\u0014(+Z9vKN$\u0018\u0001\u00054fi\u000eD7\t\\;ti\u0016\u00148\u000b]3d)\u0005I\bCA#{\u0013\tY\bDA\nDYV\u001cH/\u001a:Ta\u0016\u001c'+Z:q_:\u001cX-\u0001\bx_J\\WM\u001d+bg.t\u0015-\\3\u0015\u0003y\u0004RaJ@\u0002\u0004MJ1!!\u0001)\u0005%1UO\\2uS>t\u0017\u0007E\u0002F\u0003\u000bI1!a\u0002\u0019\u0005)9vN]6fe&sgm\\\u0001\u0018a\u0006\u0014\u0018-\\3uKJ\u001cVM\u001d<feR\u000b7o\u001b(b[\u0016\fQB]3q_J$8+^2dKN\u001cH\u0003BA\b\u0003+\u00012!RA\t\u0013\r\t\u0019\u0002\u0007\u0002\u0012\u0015>\u00147\u000b^1ukN\u0014Vm\u001d9p]N,\u0007bBA\f#\u0001\u0007\u0011\u0011D\u0001\u0004UN\u0014\bcA#\u0002\u001c%\u0019\u0011Q\u0004\r\u0003!){'m\u0015;biV\u001c(+Z9vKN$\u0018a\u0003:fa>\u0014HOR1jYN$B!a\u0004\u0002$!9\u0011q\u0003\nA\u0002\u0005e\u0011AD<bSR$uN\\3Pe\u001a\u000b\u0017\u000e\u001c\u000b\bU\u0006%\u0012QFA\u0019\u0011\u0019\tYc\u0005a\u0001\u007f\u0005iA/\u0019:hKR<vN]6feNDq!a\f\u0014\u0001\u0004\tI\"A\u0005dkJ,g\u000e\u001e&T%\"I\u00111G\n\u0011\u0002\u0003\u0007\u0011QG\u0001\bi&lWm\\;u!\r9\u0013qG\u0005\u0004\u0003sA#\u0001\u0002'p]\u001e\f\u0001d^1ji\u0012{g.Z(s\r\u0006LG\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\tyD\u000b\u0003\u00026\u0005\u00053FAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055\u0003&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0015\u0002H\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0015]\f\u0017\u000e^(uQ\u0016\u00148\u000fF\u0003k\u0003/\nY\u0006\u0003\u0004\u0002ZU\u0001\raP\u0001\u0010Kb\u0004Xm\u0019;fIN+'O^3sg\"I\u00111G\u000b\u0011\u0002\u0003\u0007\u0011QG\u0001\u0015o\u0006LGo\u0014;iKJ\u001cH\u0005Z3gCVdG\u000f\n\u001a")
public abstract class MLWorkerProxy
implements Logging {
    private final MLClient masterClient;
    private final Socket socket;
    private final DataOutputStream driverOutputStream;
    private final DataInputStream driverInputStream;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    public MLClient masterClient() {
        return this.masterClient;
    }

    public Socket socket() {
        return this.socket;
    }

    public DataOutputStream driverOutputStream() {
        return this.driverOutputStream;
    }

    public DataInputStream driverInputStream() {
        return this.driverInputStream;
    }

    public void close() {
        this.socket().close();
    }

    public ReportToMasterResponse reportToMaster(ReportToMasterRequest rtr) {
        this.masterClient().sendRequest(this.driverOutputStream(), rtr);
        return (ReportToMasterResponse)this.masterClient().readResponse(this.driverInputStream());
    }

    public ClusterSpecResponse fetchClusterSpec() {
        this.masterClient().sendRequest(this.driverOutputStream(), new ClusterSpecRequest());
        return (ClusterSpecResponse)this.masterClient().readResponse(this.driverInputStream());
    }

    public abstract Function1<WorkerInfo, String> workerTaskName();

    public abstract Function1<WorkerInfo, String> parameterServerTaskName();

    public JobStatusResponse reportSuccess(JobStatusRequest jsr) {
        this.masterClient().sendRequest(this.driverOutputStream(), jsr);
        return (JobStatusResponse)this.masterClient().readResponse(this.driverInputStream());
    }

    public JobStatusResponse reportFails(JobStatusRequest jsr) {
        this.masterClient().sendRequest(this.driverOutputStream(), jsr);
        return (JobStatusResponse)this.masterClient().readResponse(this.driverInputStream());
    }

    public void waitDoneOrFail(int targetWorkers, JobStatusRequest curentJSR, long timeout) {
        boolean shouldWait = true;
        while (shouldWait) {
            JobStatusResponse response = this.fetchClusterStatusFromMaster$1(curentJSR);
            int workSize = ((SeqLike)response.jobStatus().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MLWorkerProxy.$anonfun$waitDoneOrFail$1(f)))).size();
            if (workSize == targetWorkers) {
                shouldWait = false;
            }
            try {
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                shouldWait = false;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n           |PS check worker is all finished.\n           |targetSize:  ").append(targetWorkers).append("\n           |currentSize: ").append(workSize).append("\n            ").toString())).stripMargin());
        }
    }

    public long waitDoneOrFail$default$3() {
        return 86400000L;
    }

    public void waitOthers(int expectedServers, long timeout) {
        IntRef waitCount = IntRef.create((int)0);
        int maxWaitCount = 100;
        boolean noWait = false;
        AtomicReference<ClusterSpecResponse> clusterSpecRef = new AtomicReference<ClusterSpecResponse>();
        while (!noWait && waitCount.elem < maxWaitCount) {
            ClusterSpecResponse response = this.fetchClusterSpec();
            int totalRegistered = response.workerTaskNames(this.workerTaskName()).size() + response.parameterServerTaskNames(this.parameterServerTaskName()).size();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(311).append("\n           |\n             |----------------------------------\n           |Waiting all worker/ps started\n           |__________________________________\n           |Wait times: ").append(waitCount$1.elem).append(" times.\n           |Target: ").append(expectedServers).append("\n           |totalRegistered: ").append(totalRegistered).append("\n           |\n           |PS: ").append(response.parameterServers()).append("\n           |Workers: ").append(response.workers()).append("\n           |\n           ").toString())).stripMargin());
            if (totalRegistered == expectedServers) {
                clusterSpecRef.set(response);
                noWait = true;
                continue;
            }
            Thread.sleep(5000L);
            ++waitCount.elem;
        }
    }

    public long waitOthers$default$2() {
        return 600000L;
    }

    private final JobStatusResponse fetchClusterStatusFromMaster$1(JobStatusRequest curentJSR$1) {
        this.masterClient().sendRequest(this.driverOutputStream(), curentJSR$1);
        return (JobStatusResponse)this.masterClient().readResponse(this.driverInputStream());
    }

    public static final /* synthetic */ boolean $anonfun$waitDoneOrFail$1(WorkerInfo f) {
        return f.done() && !f.isPs();
    }

    public MLWorkerProxy(String masterHost, int masterPort) {
        Logging.$init$(this);
        this.masterClient = new MLClient();
        this.socket = new Socket(masterHost, masterPort);
        this.driverOutputStream = new DataOutputStream(this.socket().getOutputStream());
        this.driverInputStream = new DataInputStream(this.socket().getInputStream());
    }
}

