/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.hdfs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import tech.mlsql.common.utils.Md5$;

public final class HDFSOperator$ {
    public static HDFSOperator$ MODULE$;

    static {
        new HDFSOperator$();
    }

    public String readFile(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        BufferedReader br = null;
        String line = null;
        ArrayBuffer result = new ArrayBuffer();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(path))));
            line = br.readLine();
            while (line != null) {
                result.$plus$eq((Object)line);
                line = br.readLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return result.mkString("\n");
    }

    /*
     * WARNING - void declaration
     */
    public FileStatus getFileStatus(String path) {
        void var3_3;
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        FileStatus file = fs.getFileStatus(new Path(path));
        return var3_3;
    }

    public InputStream readAsInputStream(String fileName) {
        FSDataInputStream in;
        block2: {
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            Path src = new Path(fileName);
            in = null;
            try {
                in = fs.open(src);
            }
            catch (Exception e) {
                if (in == null) break block2;
                in.close();
            }
        }
        return in;
    }

    public byte[] readBytes(String fileName) {
        byte[] byArray;
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        Path src = new Path(fileName);
        try (FSDataInputStream in = null;){
            in = fs.open(src);
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)byteArrayOut, (int)1024, (boolean)true);
            byArray = byteArrayOut.toByteArray();
        }
        return byArray;
    }

    public Seq<FileStatus> listModelDirectory(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(path)))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.isDirectory())));
    }

    public Seq<FileStatus> listFiles(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return Predef$.MODULE$.wrapRefArray((Object[])fs.listStatus(new Path(path)));
    }

    public void saveBytesFile(String path, String fileName, byte[] bytes) {
        FSDataOutputStream dos = null;
        try {
            try {
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                Object object = !fs.exists(new Path(path)) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(new Path(path))) : BoxedUnit.UNIT;
                dos = fs.create(new Path(new File(path, fileName).getPath()), true);
                dos.write(bytes);
            }
            catch (Exception ex) {
                Predef$.MODULE$.println((Object)"file save exception");
            }
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception ex) {
                    Predef$.MODULE$.println((Object)"close exception");
                }
                dos.close();
            }
        }
    }

    public void saveStream(String path, String fileName, InputStream inputStream) {
        FSDataOutputStream dos = null;
        try {
            try {
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                Object object = !fs.exists(new Path(path)) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(new Path(path))) : BoxedUnit.UNIT;
                dos = fs.create(new Path(new File(path, fileName).getPath()), true);
                IOUtils.copyBytes((InputStream)inputStream, (OutputStream)dos, (int)0x400000);
            }
            catch (Exception ex) {
                Predef$.MODULE$.println((Object)"file save exception");
            }
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception ex) {
                    Predef$.MODULE$.println((Object)"close exception");
                }
                dos.close();
            }
        }
    }

    public void ceateEmptyFile(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        FSDataOutputStream dos = fs.create(new Path(path));
        dos.close();
    }

    public void saveFile(String path, String fileName, Iterator<Tuple2<String, String>> iterator) {
        ObjectRef dos = ObjectRef.create(null);
        try {
            try {
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                Object object = !fs.exists(new Path(path)) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(new Path(path))) : BoxedUnit.UNIT;
                dos.elem = fs.create(new Path(new StringBuilder(1).append(path).append("/").append(fileName).toString()), true);
                iterator.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    HDFSOperator$.$anonfun$saveFile$1(dos, x);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception ex) {
                Predef$.MODULE$.println((Object)"file save exception");
            }
        }
        finally {
            if ((FSDataOutputStream)dos.elem != null) {
                try {
                    ((FSDataOutputStream)dos.elem).close();
                }
                catch (Exception ex) {
                    Predef$.MODULE$.println((Object)"close exception");
                }
                ((FSDataOutputStream)dos.elem).close();
            }
        }
    }

    public String getFilePath(String path) {
        return new Path(path).toString();
    }

    public void copyToHDFS(String tempLocalPath, String path, boolean cleanTarget, boolean cleanSource) {
        block0: {
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            Object object = cleanTarget ? BoxesRunTime.boxToBoolean((boolean)fs.delete(new Path(path), true)) : BoxedUnit.UNIT;
            fs.copyFromLocalFile(new Path(tempLocalPath), new Path(path));
            if (!cleanSource) break block0;
            FileUtils.forceDelete((File)new File(tempLocalPath));
        }
    }

    public void copyToLocalFile(String tempLocalPath, String path, boolean clean) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        File tmpFile = new File(tempLocalPath);
        if (tmpFile.exists()) {
            FileUtils.forceDelete((File)tmpFile);
        }
        fs.copyToLocalFile(new Path(path), new Path(tempLocalPath));
    }

    public boolean deleteDir(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.delete(new Path(path), true);
    }

    public boolean isDir(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.isDirectory(new Path(path));
    }

    public boolean isFile(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.isFile(new Path(path));
    }

    public boolean fileExists(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.exists(new Path(path));
    }

    public boolean createDir(String path) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return fs.mkdirs(new Path(path));
    }

    /*
     * WARNING - void declaration
     */
    public String createTempModelLocalPath(String path, boolean autoCreateParentDir) {
        void var3_3;
        block0: {
            String dir = new StringBuilder(11).append("/tmp/train/").append(Md5$.MODULE$.md5Hash(path)).toString();
            if (!autoCreateParentDir) break block0;
            FileUtils.forceMkdir((File)new File(dir));
        }
        return var3_3;
    }

    public boolean createTempModelLocalPath$default$2() {
        return true;
    }

    public ArrayBuffer<String> iteratorFiles(String path, boolean recursive) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        ArrayBuffer files = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this._iteratorFiles(fs, path, (ArrayBuffer<String>)files);
        return files;
    }

    public void _iteratorFiles(FileSystem fs, String path, ArrayBuffer<String> files) {
        block0: {
            FileStatus[] fileStatusArr;
            FileStatus file;
            Path p;
            block1: {
                p = new Path(path);
                file = fs.getFileStatus(p);
                if (!fs.exists(p)) break block0;
                if (!file.isFile()) break block1;
                files.$plus$eq((Object)p.toString());
                break block0;
            }
            if (!file.isDirectory() || (fileStatusArr = fs.listStatus(p)) == null || fileStatusArr.length <= 0) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatusArr)).foreach((Function1 & Serializable & scala.Serializable)tempFile -> {
                HDFSOperator$.MODULE$._iteratorFiles(fs, tempFile.getPath().toString(), (ArrayBuffer<String>)files);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$saveFile$1(ObjectRef dos$1, Tuple2 x) {
        ((FSDataOutputStream)dos$1.elem).writeBytes(new StringBuilder(1).append((String)x._2()).append("\n").toString());
    }

    private HDFSOperator$() {
        MODULE$ = this;
    }
}

