/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.kv;

import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.iq80.leveldb.WriteBatch;
import tech.mlsql.common.utils.base.Preconditions;
import tech.mlsql.common.utils.kv.KVIndex;
import tech.mlsql.common.utils.kv.KVTypeInfo;
import tech.mlsql.common.utils.kv.LevelDB;
import tech.mlsql.common.utils.kv.LevelDBIterator;

class LevelDBTypeInfo {
    static final byte[] END_MARKER = new byte[]{45};
    static final byte ENTRY_PREFIX = 43;
    static final byte KEY_SEPARATOR = 0;
    static byte TRUE = (byte)49;
    static byte FALSE = (byte)48;
    private static final byte SECONDARY_IDX_PREFIX = 46;
    private static final byte POSITIVE_MARKER = 61;
    private static final byte NEGATIVE_MARKER = 42;
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private final LevelDB db;
    private final Class<?> type;
    private final Map<String, Index> indices;
    private final byte[] typePrefix;

    LevelDBTypeInfo(LevelDB db, Class<?> type, byte[] alias) throws Exception {
        this.db = db;
        this.type = type;
        this.indices = new HashMap<String, Index>();
        KVTypeInfo ti = new KVTypeInfo(type);
        ti.indices().forEach(idx -> {
            if (idx.parent().isEmpty()) {
                this.indices.put(idx.value(), new Index((KVIndex)idx, ti.getAccessor(idx.value()), null));
            }
        });
        ti.indices().forEach(idx -> {
            if (!idx.parent().isEmpty()) {
                this.indices.put(idx.value(), new Index((KVIndex)idx, ti.getAccessor(idx.value()), this.indices.get(idx.parent())));
            }
        });
        this.typePrefix = alias;
    }

    Class<?> type() {
        return this.type;
    }

    byte[] keyPrefix() {
        return this.typePrefix;
    }

    Index naturalIndex() {
        return this.index("__main__");
    }

    Index index(String name) {
        Index i = this.indices.get(name);
        Preconditions.checkArgument(i != null, "Index %s does not exist for type %s.", name, this.type.getName());
        return i;
    }

    Collection<Index> indices() {
        return this.indices.values();
    }

    byte[] buildKey(byte[] ... components) {
        return this.buildKey(true, components);
    }

    byte[] buildKey(boolean addTypePrefix, byte[] ... components) {
        int len = 0;
        if (addTypePrefix) {
            len += this.typePrefix.length + 1;
        }
        for (byte[] comp : components) {
            len += comp.length;
        }
        byte[] dest = new byte[len += components.length - 1];
        int written = 0;
        if (addTypePrefix) {
            System.arraycopy(this.typePrefix, 0, dest, 0, this.typePrefix.length);
            dest[this.typePrefix.length] = 0;
            written += this.typePrefix.length + 1;
        }
        for (byte[] comp : components) {
            System.arraycopy(comp, 0, dest, written, comp.length);
            if ((written += comp.length) >= dest.length) continue;
            dest[written] = 0;
            ++written;
        }
        return dest;
    }

    class Index {
        private final boolean copy;
        private final boolean isNatural;
        private final byte[] name;
        private final KVTypeInfo.Accessor accessor;
        private final Index parent;

        private Index(KVIndex self, KVTypeInfo.Accessor accessor, Index parent) {
            byte[] name = self.value().getBytes(StandardCharsets.UTF_8);
            if (parent != null) {
                byte[] child = new byte[name.length + 1];
                child[0] = 46;
                System.arraycopy(name, 0, child, 1, name.length);
            }
            this.name = name;
            this.isNatural = self.value().equals("__main__");
            this.copy = this.isNatural || self.copy();
            this.accessor = accessor;
            this.parent = parent;
        }

        boolean isCopy() {
            return this.copy;
        }

        boolean isChild() {
            return this.parent != null;
        }

        Index parent() {
            return this.parent;
        }

        byte[] childPrefix(Object value) {
            Preconditions.checkState(this.parent == null, "Not a parent index.");
            return LevelDBTypeInfo.this.buildKey(this.name, this.toParentKey(value));
        }

        Object getValue(Object entity) throws Exception {
            return this.accessor.get(entity);
        }

        private void checkParent(byte[] prefix) {
            if (prefix != null) {
                Preconditions.checkState(this.parent != null, "Parent prefix provided for parent index.");
            } else {
                Preconditions.checkState(this.parent == null, "Parent prefix missing for child index.");
            }
        }

        byte[] keyPrefix(byte[] prefix) {
            this.checkParent(prefix);
            return this.parent != null ? LevelDBTypeInfo.this.buildKey(false, (byte[][])new byte[][]{prefix, this.name}) : LevelDBTypeInfo.this.buildKey(new byte[][]{this.name});
        }

        byte[] start(byte[] prefix, Object value) {
            this.checkParent(prefix);
            return this.parent != null ? LevelDBTypeInfo.this.buildKey(false, (byte[][])new byte[][]{prefix, this.name, this.toKey(value)}) : LevelDBTypeInfo.this.buildKey(this.name, this.toKey(value));
        }

        byte[] end(byte[] prefix) {
            this.checkParent(prefix);
            return this.parent != null ? LevelDBTypeInfo.this.buildKey(false, (byte[][])new byte[][]{prefix, this.name, END_MARKER}) : LevelDBTypeInfo.this.buildKey(this.name, END_MARKER);
        }

        byte[] end(byte[] prefix, Object value) {
            this.checkParent(prefix);
            return this.parent != null ? LevelDBTypeInfo.this.buildKey(false, (byte[][])new byte[][]{prefix, this.name, this.toKey(value), END_MARKER}) : LevelDBTypeInfo.this.buildKey(this.name, this.toKey(value), END_MARKER);
        }

        byte[] entityKey(byte[] prefix, Object entity) throws Exception {
            Object indexValue = this.getValue(entity);
            Preconditions.checkNotNull(indexValue, "Null index value for %s in type %s.", this.name, LevelDBTypeInfo.this.type.getName());
            byte[] entityKey = this.start(prefix, indexValue);
            if (!this.isNatural) {
                entityKey = LevelDBTypeInfo.this.buildKey(false, (byte[][])new byte[][]{entityKey, this.toKey(LevelDBTypeInfo.this.naturalIndex().getValue(entity))});
            }
            return entityKey;
        }

        private void updateCount(WriteBatch batch, byte[] key, long delta) {
            long updated = this.getCount(key) + delta;
            if (updated > 0L) {
                batch.put(key, ((LevelDBTypeInfo)LevelDBTypeInfo.this).db.serializer.serialize(updated));
            } else {
                batch.delete(key);
            }
        }

        private void addOrRemove(WriteBatch batch, Object entity, Object existing, byte[] data, byte[] naturalKey, byte[] prefix) throws Exception {
            boolean needCountUpdate;
            Object indexValue = this.getValue(entity);
            Preconditions.checkNotNull(indexValue, "Null index value for %s in type %s.", this.name, LevelDBTypeInfo.this.type.getName());
            byte[] entityKey = this.start(prefix, indexValue);
            if (!this.isNatural) {
                entityKey = LevelDBTypeInfo.this.buildKey(false, (byte[][])new byte[][]{entityKey, naturalKey});
            }
            boolean bl = needCountUpdate = existing == null;
            if (existing != null && !this.isNatural) {
                boolean removeExisting;
                byte[] oldPrefix = null;
                Object oldIndexedValue = this.getValue(existing);
                boolean bl2 = removeExisting = !indexValue.equals(oldIndexedValue);
                if (!removeExisting && this.isChild()) {
                    oldPrefix = this.parent().childPrefix(this.parent().getValue(existing));
                    boolean bl3 = removeExisting = LevelDBIterator.compare(prefix, oldPrefix) != 0;
                }
                if (removeExisting) {
                    if (oldPrefix == null && this.isChild()) {
                        oldPrefix = this.parent().childPrefix(this.parent().getValue(existing));
                    }
                    byte[] oldKey = this.entityKey(oldPrefix, existing);
                    batch.delete(oldKey);
                    if (!this.isChild()) {
                        byte[] oldCountKey = this.end(null, oldIndexedValue);
                        this.updateCount(batch, oldCountKey, -1L);
                        needCountUpdate = true;
                    }
                }
            }
            if (data != null) {
                byte[] stored = this.copy ? data : naturalKey;
                batch.put(entityKey, stored);
            } else {
                batch.delete(entityKey);
            }
            if (needCountUpdate && !this.isChild()) {
                long delta = data != null ? 1L : -1L;
                byte[] countKey = this.isNatural ? this.end(prefix) : this.end(prefix, indexValue);
                this.updateCount(batch, countKey, delta);
            }
        }

        void add(WriteBatch batch, Object entity, Object existing, byte[] data, byte[] naturalKey, byte[] prefix) throws Exception {
            this.addOrRemove(batch, entity, existing, data, naturalKey, prefix);
        }

        void remove(WriteBatch batch, Object entity, byte[] naturalKey, byte[] prefix) throws Exception {
            this.addOrRemove(batch, entity, null, null, naturalKey, prefix);
        }

        long getCount(byte[] key) {
            byte[] data = LevelDBTypeInfo.this.db.db().get(key);
            return data != null ? ((LevelDBTypeInfo)LevelDBTypeInfo.this).db.serializer.deserializeLong(data) : 0L;
        }

        byte[] toParentKey(Object value) {
            return this.toKey(value, (byte)46);
        }

        byte[] toKey(Object value) {
            return this.toKey(value, (byte)43);
        }

        byte[] toKey(Object value, byte prefix) {
            byte[] result;
            if (value instanceof String) {
                byte[] str = ((String)value).getBytes(StandardCharsets.UTF_8);
                result = new byte[str.length + 1];
                result[0] = prefix;
                System.arraycopy(str, 0, result, 1, str.length);
            } else if (value instanceof Boolean) {
                result = new byte[]{prefix, (Boolean)value != false ? TRUE : FALSE};
            } else if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                byte[][] components = new byte[length][];
                for (int i = 0; i < length; ++i) {
                    components[i] = this.toKey(Array.get(value, i));
                }
                result = LevelDBTypeInfo.this.buildKey(false, (byte[][])components);
            } else {
                int bytes;
                if (value instanceof Integer) {
                    bytes = 32;
                } else if (value instanceof Long) {
                    bytes = 64;
                } else if (value instanceof Short) {
                    bytes = 16;
                } else if (value instanceof Byte) {
                    bytes = 8;
                } else {
                    throw new IllegalArgumentException(String.format("Type %s not allowed as key.", value.getClass().getName()));
                }
                byte[] key = new byte[(bytes /= 8) * 2 + 2];
                long longValue = ((Number)value).longValue();
                key[0] = prefix;
                key[1] = longValue >= 0L ? 61 : 42;
                for (int i = 0; i < key.length - 2; ++i) {
                    int masked = (int)(longValue >>> 4 * i & 0xFL);
                    key[key.length - i - 1] = HEX_BYTES[masked];
                }
                result = key;
            }
            return result;
        }
    }
}

