/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.net;

import io.netty.channel.unix.Errors;
import java.io.Serializable;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.MultiException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.matching.Regex;
import tech.mlsql.common.utils.log.Logging;
import tech.mlsql.common.utils.net.InetAddresses;
import tech.mlsql.common.utils.network.NetUtils;
import tech.mlsql.common.utils.os.SystemUtils;

public final class NetTool$
implements Logging {
    public static NetTool$ MODULE$;
    private InetAddress localIpAddress;
    private Option<String> customHostname;
    private final boolean isWindows;
    private final boolean isMac;
    private final Regex windowsDrive;
    private final ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new NetTool$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    private Option<String> customHostname() {
        return this.customHostname;
    }

    private void customHostname_$eq(Option<String> x$1) {
        this.customHostname = x$1;
    }

    private InetAddress localIpAddress$lzycompute() {
        NetTool$ netTool$ = this;
        synchronized (netTool$) {
            if (!this.bitmap$0) {
                this.localIpAddress = this.findLocalInetAddress();
                this.bitmap$0 = true;
            }
        }
        return this.localIpAddress;
    }

    private InetAddress localIpAddress() {
        return !this.bitmap$0 ? this.localIpAddress$lzycompute() : this.localIpAddress;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMac() {
        return this.isMac;
    }

    public Regex windowsDrive() {
        return this.windowsDrive;
    }

    /*
     * WARNING - void declaration
     */
    private InetAddress findLocalInetAddress() {
        InetAddress inetAddress;
        Object object = new Object();
        try {
            String defaultIpOverride = System.getenv("LOCAL_IP");
            if (defaultIpOverride != null) {
                inetAddress = InetAddress.getByName(defaultIpOverride);
            } else {
                void var3_3;
                InetAddress address = InetAddress.getLocalHost();
                if (address.isLoopbackAddress()) {
                    Seq activeNetworkIFs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toSeq();
                    Seq reOrderedNetworkIFs = this.isWindows() ? activeNetworkIFs : (Seq)activeNetworkIFs.reverse();
                    reOrderedNetworkIFs.foreach((Function1 & Serializable & scala.Serializable)ni -> {
                        NetTool$.$anonfun$findLocalInetAddress$1(address, object, ni);
                        return BoxedUnit.UNIT;
                    });
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("Your hostname, ").append(InetAddress.getLocalHost().getHostName()).append(" resolves to").append(" a loopback address: ").append(address.getHostAddress()).append(", but we couldn't find any").append(" external IP address!").toString());
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Set LOCAL_IP if you need to bind to another address");
                }
                inetAddress = var3_3;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                inetAddress = (InetAddress)ex.value();
            }
            throw ex;
        }
        return inetAddress;
    }

    public void setCustomHostname(String hostname) {
        this.checkHost(hostname);
        this.customHostname_$eq((Option<String>)new Some((Object)hostname));
    }

    public String localCanonicalHostName() {
        return (String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.localIpAddress().getCanonicalHostName());
    }

    public String localHostName() {
        return (String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.localIpAddress().getHostAddress());
    }

    public String localHostNameForURI() {
        return (String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> InetAddresses.toUriString(MODULE$.localIpAddress()));
    }

    public void checkHost(String host) {
        Predef$.MODULE$.assert(host != null && host.indexOf(58) == -1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Expected hostname (not IP) but got ").append(host).toString());
    }

    public void checkHostPort(String hostPort) {
        Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf(58) != -1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Expected host and port but got ").append(hostPort).toString());
    }

    private ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults() {
        return this.hostPortParseResults;
    }

    public Tuple2<String, Object> parseHostPort(String hostPort) {
        Tuple2<String, Object> cached = this.hostPortParseResults().get(hostPort);
        if (cached != null) {
            return cached;
        }
        int indx = hostPort.lastIndexOf(58);
        if (-1 == indx) {
            Tuple2 retval = new Tuple2((Object)hostPort, (Object)BoxesRunTime.boxToInteger((int)0));
            this.hostPortParseResults().put(hostPort, (Tuple2<String, Object>)retval);
            return retval;
        }
        Tuple2 retval = new Tuple2((Object)hostPort.substring(0, indx).trim(), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(hostPort.substring(indx + 1).trim())).toInt()));
        this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retval);
        return this.hostPortParseResults().get(hostPort);
    }

    public int userPort(int base, int offset) {
        return (base + offset - 1024) % 64512 + 1024;
    }

    public <T> Tuple2<T, Object> startServiceOnPort(int startPort, Function1<Object, Tuple2<T, Object>> startService, int portMaxRetries, String serviceName) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(startPort == 0 || 1024 <= startPort && startPort < 65536, (Function0 & Serializable & scala.Serializable)() -> "startPort should be between 1024 and 65535 (inclusive), or 0 for a random free port.");
            String serviceString = serviceName.isEmpty() ? "" : new StringBuilder(3).append(" '").append(serviceName).append("'").toString();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), portMaxRetries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
                int tryPort = startPort == 0 ? startPort : MODULE$.userPort(startPort, offset);
                try {
                    Tuple2 tuple2 = (Tuple2)startService.apply((Object)BoxesRunTime.boxToInteger((int)tryPort));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object service = tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2(service, (Object)BoxesRunTime.boxToInteger((int)port));
                    Tuple2 tuple23 = tuple22;
                    Object service2 = tuple23._1();
                    int port2 = tuple23._2$mcI$sp();
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Successfully started service").append(serviceString).append(" on port ").append(port2).append(".").toString());
                    throw new NonLocalReturnControl(object, (Object)new Tuple2(service2, (Object)BoxesRunTime.boxToInteger((int)port2)));
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit;
                    Exception exception;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof Exception && MODULE$.isBindCollision(exception = (Exception)throwable2)) {
                        if (offset >= portMaxRetries) {
                            String exceptionMessage = startPort == 0 ? new StringBuilder(219).append(exception.getMessage()).append(": Service").append(serviceString).append(" failed after ").append(portMaxRetries).append(" retries (on a random free port)! ").append("Consider explicitly setting the appropriate binding address for ").append("the service").append(serviceString).append(" (for example spark.driver.bindAddress ").append("for SparkDriver) to the correct binding address.").toString() : new StringBuilder(212).append(exception.getMessage()).append(": Service").append(serviceString).append(" failed after ").append(portMaxRetries).append(" retries (starting from ").append(startPort).append(")! Consider explicitly setting ").append("the appropriate port for the service").append(serviceString).append(" (for example spark.ui.port ").append("for SparkUI) to an available port or increasing spark.port.maxRetries.").toString();
                            BindException exception2 = new BindException(exceptionMessage);
                            exception2.setStackTrace(exception.getStackTrace());
                            throw exception2;
                        }
                        if (startPort == 0) {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Service").append(serviceString).append(" could not bind on a random free port. ").append("You may check whether configuring an appropriate binding address.").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Service").append(serviceString).append(" could not bind on port ").append(tryPort).append(". ").append("Attempting port ").append(tryPort + 1).append(".").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
            });
            throw new RuntimeException(new StringBuilder(32).append("Failed to start service").append(serviceString).append(" on port ").append(startPort).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public <T> String startServiceOnPort$default$4() {
        return "";
    }

    public boolean isBindCollision(Throwable exception2) {
        boolean bl;
        block6: {
            while (true) {
                Throwable throwable;
                if ((throwable = exception2) instanceof BindException) {
                    BindException bindException = (BindException)throwable;
                    if (bindException.getMessage() != null) {
                        return true;
                    }
                    exception2 = bindException.getCause();
                    continue;
                }
                if (throwable instanceof MultiException) {
                    MultiException multiException = (MultiException)throwable;
                    bl = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiException.getThrowables()).asScala()).exists((Function1 & Serializable & scala.Serializable)exception -> BoxesRunTime.boxToBoolean((boolean)NetTool$.MODULE$.isBindCollision(exception)));
                    break block6;
                }
                if (throwable instanceof Errors.NativeIoException) {
                    Errors.NativeIoException nativeIoException = (Errors.NativeIoException)throwable;
                    if (nativeIoException.getMessage() == null || !nativeIoException.getMessage().startsWith("bind() failed: ")) {
                        exception2 = nativeIoException.getCause();
                        continue;
                    }
                    bl = true;
                    break block6;
                }
                if (!(throwable instanceof Exception)) break;
                Exception exception3 = (Exception)throwable;
                exception2 = exception3.getCause();
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public ServerSocket lockPort(int min, int max) {
        void var3_3;
        ServerSocket ss = NetUtils.availableAndReturn(min, max);
        return var3_3;
    }

    public void releasePort(ServerSocket ss) {
        block2: {
            if (ss == null) break block2;
            try {
                ss.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$2(InetAddress addr) {
        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$3(InetAddress x$1) {
        return x$1 instanceof Inet4Address;
    }

    public static final /* synthetic */ void $anonfun$findLocalInetAddress$1(InetAddress address$1, Object nonLocalReturnKey1$1, NetworkInterface ni) {
        Seq addresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ni.getInetAddresses()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)NetTool$.$anonfun$findLocalInetAddress$2(addr))).toSeq();
        if (addresses.nonEmpty()) {
            InetAddress addr2 = (InetAddress)addresses.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NetTool$.$anonfun$findLocalInetAddress$3(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (InetAddress)addresses.head());
            InetAddress strippedAddress = InetAddress.getByAddress(addr2.getAddress());
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Your hostname, ").append(InetAddress.getLocalHost().getHostName()).append(" resolves to").append(" a loopback address: ").append(address$1.getHostAddress()).append("; using ").append(strippedAddress.getHostAddress()).append(" instead (on interface ").append(ni.getName()).append(")").toString());
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Set LOCAL_IP if you need to bind to another address");
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)strippedAddress);
        }
    }

    private NetTool$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.customHostname = package$.MODULE$.env().get((Object)"LOCAL_HOSTNAME");
        this.isWindows = SystemUtils.IS_OS_WINDOWS;
        this.isMac = SystemUtils.IS_OS_MAC_OSX;
        this.windowsDrive = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z])")).r();
        this.hostPortParseResults = new ConcurrentHashMap();
    }
}

