/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.shell;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import tech.mlsql.common.utils.log.Logging;
import tech.mlsql.common.utils.shell.AsyncShellCommand;
import tech.mlsql.common.utils.shell.AsyncShellCommand$;
import tech.mlsql.common.utils.shell.ShellExecuteStatus;

public final class AsyncShellCommand$
implements Logging {
    public static AsyncShellCommand$ MODULE$;
    private final HashMap<String, Tuple2<AsyncShellCommand, Object>> shellsInfo;
    private final ArrayBuffer<String> removeList;
    private final ScheduledExecutorService schedule;
    private final int maxTimeIdle;
    private final long defaultTimeOut;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    static {
        new AsyncShellCommand$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    public HashMap<String, Tuple2<AsyncShellCommand, Object>> shellsInfo() {
        return this.shellsInfo;
    }

    public ArrayBuffer<String> removeList() {
        return this.removeList;
    }

    public ScheduledExecutorService schedule() {
        return this.schedule;
    }

    public int maxTimeIdle() {
        return this.maxTimeIdle;
    }

    public long defaultTimeOut() {
        return this.defaultTimeOut;
    }

    public String start(String command, String token, boolean isInteractive) {
        return this.startWithTimeout(command, token, this.defaultTimeOut(), isInteractive);
    }

    public boolean start$default$3() {
        return false;
    }

    public String startWithTimeout(String command, String token, long timeout, boolean isInteractive) {
        return this.startWithUserAndTimeout("", command, token, timeout, isInteractive);
    }

    public boolean startWithTimeout$default$4() {
        return false;
    }

    public String startWithUserAndTimeout(String user, String command, String token, long timeout, boolean isInteractive) {
        if (isInteractive) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("initial interactive shell ").append(command).append(" with token ").append(token).toString());
        }
        AsyncShellCommand shellCommand = new AsyncShellCommand(user, command, token, timeout, isInteractive);
        this.shellsInfo().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)shellCommand.taskId()), (Object)new Tuple2((Object)shellCommand, (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()))));
        return shellCommand.taskId();
    }

    public boolean startWithUserAndTimeout$default$5() {
        return false;
    }

    public Tuple2<ShellExecuteStatus, Tuple2<Object, String>> progress(String taskId, long offset) {
        Tuple2 tuple2;
        if (!this.shellsInfo().contains((Object)taskId)) {
            tuple2 = new Tuple2((Object)new ShellExecuteStatus(false, false, false), (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)-1L), (Object)"no message"));
        } else {
            AsyncShellCommand isc = (AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1();
            tuple2 = new Tuple2((Object)new ShellExecuteStatus(isc.isFinished().get(), isc.isTimeout().get(), isc.exitValue().get() != 0), ((AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1()).progress(offset));
        }
        return tuple2;
    }

    public long progress$default$2() {
        return 0L;
    }

    public void execute(String taskId, String line) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("task ").append(taskId).append(" in interactive mode. execute input ").append(line).toString());
        try {
            ((AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1()).execute(line);
        }
        finally {
            this.shellsInfo().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)taskId), (Object)new Tuple2(((Tuple2)this.shellsInfo().apply((Object)taskId))._1(), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()))));
        }
    }

    public void close(String taskId) {
        block0: {
            if (!this.shellsInfo().contains((Object)taskId)) break block0;
            ((AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1()).close();
        }
    }

    public void close(String taskId, String command) {
        block0: {
            if (!this.shellsInfo().contains((Object)taskId)) break block0;
            ((AsyncShellCommand)((Tuple2)this.shellsInfo().apply((Object)taskId))._1()).closeWithExitCommand(command);
        }
    }

    private AsyncShellCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.shellsInfo = new HashMap();
        this.removeList = new ArrayBuffer();
        this.schedule = Executors.newScheduledThreadPool(1000);
        this.maxTimeIdle = 10800000;
        this.defaultTimeOut = 300000L;
        this.schedule().schedule(new Runnable(){

            public void run() {
                try {
                    AsyncShellCommand$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "schedule to clean up tasks expired without any operation in 3 hours");
                    ((IterableLike)((TraversableLike)AsyncShellCommand$.MODULE$.shellsInfo().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)anon.3.$anonfun$run$3(f)))).map((Function1 & Serializable & scala.Serializable)f -> (String)f._1(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)f -> {
                        Object object;
                        AsyncShellCommand$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("clean up task ").append((String)f).append(" cause this task without any operation in 3 hours").toString());
                        Option option = AsyncShellCommand$.MODULE$.shellsInfo().remove(f);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Tuple2 i = (Tuple2)some.value();
                            ((AsyncShellCommand)i._1()).close();
                            object = ((AsyncShellCommand)i._1()).removeTempFile();
                        } else if (None$.MODULE$.equals(option)) {
                            object = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return object;
                    });
                }
                catch (Exception e) {
                    AsyncShellCommand$.MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "schedule to clean up tasks expired without any operation in 3 hours failed,please check error log", e);
                }
            }

            public static final /* synthetic */ boolean $anonfun$run$3(Tuple2 f) {
                return System.currentTimeMillis() - ((Tuple2)f._2())._2$mcJ$sp() > (long)AsyncShellCommand$.MODULE$.maxTimeIdle();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2(), $anonfun$run$3$adapted(scala.Tuple2 ), $anonfun$run$4(scala.Tuple2 ), $anonfun$run$5(java.lang.String ), $anonfun$run$7(), $anonfun$run$6(java.lang.String )}, serializedLambda);
            }
        }, 10L, TimeUnit.SECONDS);
    }
}

