/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.base;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;
import tech.mlsql.common.utils.base.CharMatcher;
import tech.mlsql.common.utils.base.ProcessTool$;
import tech.mlsql.common.utils.log.Logging;

public final class ProcessTool$
implements Logging {
    public static ProcessTool$ MODULE$;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    static {
        new ProcessTool$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    public Option<String> getStderr(Process process, long timeoutMs) {
        boolean terminated = process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
        return terminated ? new Some((Object)Source$.MODULE$.fromInputStream(process.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n")) : None$.MODULE$;
    }

    public Option<Object> terminateProcess(Process process, long timeoutMs) {
        Option option;
        process.destroy();
        if (process.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
            option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
        } else {
            Process process2;
            try {
                process2 = process.destroyForcibly();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option2.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when attempting to kill process", e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                process2 = boxedUnit;
            }
            if (process.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
                option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting to forcibly kill process");
                option = None$.MODULE$;
            }
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> splitCommandString(String s) {
        void var2_2;
        block14: {
            ArrayBuffer buf = new ArrayBuffer();
            boolean inWord = false;
            boolean inSingleQuote = false;
            boolean inDoubleQuote = false;
            scala.collection.mutable.StringBuilder curWord = new scala.collection.mutable.StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                BoxedUnit boxedUnit;
                char nextChar = s.charAt(i);
                if (inDoubleQuote) {
                    if (nextChar == '\"') {
                        inDoubleQuote = false;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (nextChar == '\\') {
                        if (i < s.length() - 1) {
                            curWord.append(s.charAt(i + 1));
                            ++i;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = curWord.append(nextChar);
                    continue;
                }
                if (inSingleQuote) {
                    if (nextChar == '\'') {
                        inSingleQuote = false;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = curWord.append(nextChar);
                    continue;
                }
                if (nextChar == '\"') {
                    inWord = true;
                    inDoubleQuote = true;
                } else if (nextChar == '\'') {
                    inWord = true;
                    inSingleQuote = true;
                } else if (!CharMatcher.WHITESPACE.matches(nextChar)) {
                    curWord.append(nextChar);
                    inWord = true;
                } else if (inWord && CharMatcher.WHITESPACE.matches(nextChar)) {
                    ProcessTool$.endWord$1(buf, curWord);
                    inWord = false;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!inWord && !inDoubleQuote && !inSingleQuote) break block14;
            ProcessTool$.endWord$1(buf, curWord);
        }
        return var2_2;
    }

    public Process executeCommand(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        Object object;
        ProcessBuilder builder = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).directory(workingDir);
        java.util.Map<String, String> environment = builder.environment();
        extraEnvironment.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProcessTool$.$anonfun$executeCommand$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = environment.put(key, value);
            return string;
        });
        Process process = builder.start();
        if (redirectStderr) {
            String threadName = new StringBuilder(28).append("redirect stderr for command ").append(command.apply(0)).toString();
            object = this.processStreamByLine(threadName, process.getErrorStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
                this.log$1(s);
                return BoxedUnit.UNIT;
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return process;
    }

    public File executeCommand$default$2() {
        return new File(".");
    }

    public Map<String, String> executeCommand$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean executeCommand$default$4() {
        return true;
    }

    public String executeAndGetOutput(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        Process process = this.executeCommand(command, workingDir, extraEnvironment, redirectStderr);
        scala.collection.mutable.StringBuilder output = new scala.collection.mutable.StringBuilder();
        String threadName = new StringBuilder(16).append("read stdout for ").append(command.apply(0)).toString();
        Thread stdoutThread = this.processStreamByLine(threadName, process.getInputStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            ProcessTool$.appendToOutput$1(s, output);
            return BoxedUnit.UNIT;
        });
        int exitCode = process.waitFor();
        stdoutThread.join();
        if (exitCode != 0) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Process ").append(command).append(" exited with code ").append(exitCode).append(": ").append((CharSequence)output).toString());
            throw new RuntimeException(new StringBuilder(26).append("Process ").append(command).append(" exited with code ").append(exitCode).toString());
        }
        return output.toString();
    }

    public File executeAndGetOutput$default$2() {
        return new File(".");
    }

    public Map<String, String> executeAndGetOutput$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean executeAndGetOutput$default$4() {
        return true;
    }

    public Thread processStreamByLine(String threadName, InputStream inputStream, Function1<String, BoxedUnit> processLine) {
        Thread t = new Thread(threadName, inputStream, processLine){
            private final InputStream inputStream$1;
            private final Function1 processLine$1;

            public void run() {
                Source$.MODULE$.fromInputStream(this.inputStream$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
                    anon.1.$anonfun$run$1(this, line);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$1(anon.1 $this, String line) {
                $this.processLine$1.apply((Object)line);
            }
            {
                this.inputStream$1 = inputStream$1;
                this.processLine$1 = processLine$1;
                super(threadName$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(tech.mlsql.common.utils.base.ProcessTool$$anon$1 java.lang.String )}, serializedLambda);
            }
        };
        t.setDaemon(true);
        t.start();
        return t;
    }

    private static final void endWord$1(ArrayBuffer buf$1, scala.collection.mutable.StringBuilder curWord$1) {
        buf$1.$plus$eq((Object)curWord$1.toString());
        curWord$1.clear();
    }

    public static final /* synthetic */ boolean $anonfun$executeCommand$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private final void log$1(String s) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> s);
    }

    private static final void appendToOutput$1(String s, scala.collection.mutable.StringBuilder output$1) {
        output$1.append(s).append("\n");
    }

    private ProcessTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

