/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import tech.mlsql.common.utils.collect.AbstractMapBasedMultiset;
import tech.mlsql.common.utils.collect.Iterables;
import tech.mlsql.common.utils.collect.Maps;
import tech.mlsql.common.utils.collect.Multisets;
import tech.mlsql.common.utils.collect.Serialization;

public final class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return new HashMultiset<E>();
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private HashMultiset() {
        super(new HashMap());
    }

    private HashMultiset(int distinctElements) {
        super(Maps.newHashMapWithExpectedSize(distinctElements));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int distinctElements = Serialization.readCount(stream);
        this.setBackingMap(Maps.newHashMapWithExpectedSize(distinctElements));
        Serialization.populateMultiset(this, stream, distinctElements);
    }
}

