/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.collect;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import tech.mlsql.common.utils.collect.ImmutableAsList;
import tech.mlsql.common.utils.collect.ImmutableCollection;
import tech.mlsql.common.utils.collect.ImmutableList;
import tech.mlsql.common.utils.collect.ImmutableMap;
import tech.mlsql.common.utils.collect.ImmutableSet;
import tech.mlsql.common.utils.collect.Iterators;
import tech.mlsql.common.utils.collect.Maps;
import tech.mlsql.common.utils.collect.UnmodifiableIterator;

final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return Maps.valueIterator(((ImmutableSet)this.map.entrySet()).iterator());
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return object != null && Iterators.contains(this.iterator(), object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    ImmutableList<V> createAsList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<V>(){

            @Override
            public V get(int index) {
                return ((Map.Entry)entryList.get(index)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return ImmutableMapValues.this;
            }
        };
    }

    @Override
    Object writeReplace() {
        return new SerializedForm<V>(this.map);
    }

    private static class SerializedForm<V>
    implements Serializable {
        final ImmutableMap<?, V> map;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, V> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

