/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsClassLoader
extends ClassLoader {
    public static final String ATTEMPT_LOCAL_LOAD_FIRST = "hdfs.classloader.attemptLocalFirst";
    private static final Log LOG = LogFactory.getLog(HdfsClassLoader.class);
    private final Configuration configuration;
    private final Path jar;

    public HdfsClassLoader(Configuration configuration, Path jar) {
        super(HdfsClassLoader.class.getClassLoader());
        this.configuration = configuration;
        this.jar = jar;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this.configuration.getBoolean(ATTEMPT_LOCAL_LOAD_FIRST, false)) {
            try {
                return this.findClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.loadClass(className);
    }

    public Class findClass(String className) throws ClassNotFoundException {
        String classPath = this.convertNameToPath(className);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Searching for class %s (%s) in path %s", className, classPath, this.jar));
        }
        FileSystem fs = null;
        JarInputStream jarIn = null;
        try {
            fs = this.jar.getFileSystem(this.configuration);
            jarIn = new JarInputStream((InputStream)fs.open(this.jar));
            JarEntry currentEntry = null;
            while ((currentEntry = jarIn.getNextJarEntry()) != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)String.format("Comparing %s to entry %s", classPath, currentEntry.getName()));
                }
                if (!currentEntry.getName().equals(classPath)) continue;
                byte[] classBytes = this.readEntry(jarIn);
                Class<?> clazz = this.defineClass(className, classBytes, 0, classBytes.length);
                this.closeQuietly(jarIn);
                return clazz;
            }
            this.closeQuietly(jarIn);
        }
        catch (IOException ioe) {
            try {
                throw new ClassNotFoundException("Unable to find " + className + " in path " + this.jar, ioe);
            }
            catch (Throwable throwable) {
                this.closeQuietly(jarIn);
                throw throwable;
            }
        }
        throw new ClassNotFoundException("Unable to find " + className + " in path " + this.jar);
    }

    private String convertNameToPath(String className) {
        String classPath = className.replace('.', '/');
        classPath = classPath + ".class";
        return classPath;
    }

    private byte[] readEntry(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, read);
        }
        out.flush();
        out.close();
        return out.toByteArray();
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

