/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import tech.mlsql.common.utils.base.Preconditions;
import tech.mlsql.common.utils.io.CharStreams;
import tech.mlsql.common.utils.io.Closer;
import tech.mlsql.common.utils.io.OutputSupplier;

public abstract class CharSink
implements OutputSupplier<Writer> {
    protected CharSink() {
    }

    public abstract Writer openStream() throws IOException;

    @Override
    @Deprecated
    public final Writer getOutput() throws IOException {
        return this.openStream();
    }

    public Writer openBufferedStream() throws IOException {
        Writer writer = this.openStream();
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public void write(CharSequence charSequence) throws IOException {
        Preconditions.checkNotNull(charSequence);
        try (Closer closer = Closer.create();){
            Writer out = closer.register(this.openStream());
            out.append(charSequence);
            out.flush();
        }
    }

    public void writeLines(Iterable<? extends CharSequence> lines) throws IOException {
        this.writeLines(lines, System.getProperty("line.separator"));
    }

    public void writeLines(Iterable<? extends CharSequence> lines, String lineSeparator) throws IOException {
        Preconditions.checkNotNull(lines);
        Preconditions.checkNotNull(lineSeparator);
        try (Closer closer = Closer.create();){
            Writer out = closer.register(this.openBufferedStream());
            for (CharSequence charSequence : lines) {
                out.append(charSequence).append(lineSeparator);
            }
            out.flush();
        }
    }

    public long writeFrom(Readable readable) throws IOException {
        Preconditions.checkNotNull(readable);
        try (Closer closer = Closer.create();){
            Writer out = closer.register(this.openStream());
            long written = CharStreams.copy(readable, (Appendable)out);
            out.flush();
            long l = written;
            return l;
        }
    }
}

