/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import tech.mlsql.common.utils.base.TryTool$;
import tech.mlsql.common.utils.distribute.socket.server.JavaUtils;
import tech.mlsql.common.utils.hook.JVMShutdownHookManager$;
import tech.mlsql.common.utils.io.ByteStreams;
import tech.mlsql.common.utils.io.Files;
import tech.mlsql.common.utils.log.Logging;

public final class IOTool$
implements Logging {
    public static IOTool$ MODULE$;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    static {
        new IOTool$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    @Override
    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    public boolean doesDirectoryContainAnyNewFiles(File dir, long cutoff) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(new StringBuilder(20).append(dir).append(" is not a directory!").toString());
        }
        File[] filesAndDirs = dir.listFiles();
        long cutoffTimeInMillis = System.currentTimeMillis() - cutoff * 1000L;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesAndDirs)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)IOTool$.$anonfun$doesDirectoryContainAnyNewFiles$1(cutoffTimeInMillis, x$1))) || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesAndDirs)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory())))).exists((Function1 & Serializable & scala.Serializable)subdir -> BoxesRunTime.boxToBoolean((boolean)IOTool$.MODULE$.doesDirectoryContainAnyNewFiles(subdir, cutoff)));
    }

    public void deleteRecursively(File file) {
        block0: {
            if (file == null) break block0;
            JavaUtils.deleteRecursively(file);
            JVMShutdownHookManager$.MODULE$.removeShutdownDeleteDir(file);
        }
    }

    /*
     * WARNING - void declaration
     */
    public File createTempDir(String root, String namePrefix) {
        void var3_3;
        File dir = this.createDirectory(root, namePrefix, 10);
        JVMShutdownHookManager$.MODULE$.registerShutdownDeleteDir(dir);
        return var3_3;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public String createTempDir$default$2() {
        return "temp";
    }

    public File createDirectory(String root, String namePrefix, int maxAttempts) {
        int attempts = 0;
        File dir = null;
        while (dir == null) {
            if (++attempts > maxAttempts) {
                throw new IOException(new StringBuilder(59).append("Failed to create a temp directory (under ").append(root).append(") after ").append(maxAttempts).append(" attempts!").toString());
            }
            try {
                dir = new File(root, new StringBuilder(1).append(namePrefix).append("-").append(UUID.randomUUID().toString()).toString());
                if (!dir.exists() && dir.mkdirs()) continue;
                dir = null;
            }
            catch (SecurityException e) {
                dir = null;
            }
        }
        return dir.getCanonicalFile();
    }

    public String createDirectory$default$2() {
        return "temp";
    }

    public boolean chmod700(File file) {
        return file.setReadable(false, false) && file.setReadable(true, true) && file.setWritable(false, false) && file.setWritable(true, true) && file.setExecutable(false, false) && file.setExecutable(true, true);
    }

    public void writeByteBuffer(ByteBuffer bb, DataOutput out) {
        if (bb.hasArray()) {
            out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        } else {
            int originalPosition = bb.position();
            byte[] bbval = new byte[bb.remaining()];
            bb.get(bbval);
            out.write(bbval);
            bb.position(originalPosition);
        }
    }

    public void writeByteBuffer(ByteBuffer bb, OutputStream out) {
        if (bb.hasArray()) {
            out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        } else {
            int originalPosition = bb.position();
            byte[] bbval = new byte[bb.remaining()];
            bb.get(bbval);
            out.write(bbval);
            bb.position(originalPosition);
        }
    }

    public long copyStream(InputStream in, OutputStream out, boolean closeStreams, boolean transferToEnabled) {
        return BoxesRunTime.unboxToLong(TryTool$.MODULE$.tryWithSafeFinally((JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            long l;
            if (in instanceof FileInputStream && out instanceof FileOutputStream && transferToEnabled) {
                FileChannel inChannel = ((FileInputStream)in).getChannel();
                FileChannel outChannel = ((FileOutputStream)out).getChannel();
                long size = inChannel.size();
                MODULE$.copyFileStreamNIO(inChannel, outChannel, 0L, size);
                l = size;
            } else {
                long count = 0L;
                byte[] buf = new byte[8192];
                int n = 0;
                while (n != -1) {
                    n = in.read(buf);
                    if (n == -1) continue;
                    out.write(buf, 0, n);
                    count += (long)n;
                }
                l = count;
            }
            return l;
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (closeStreams) {
                try {
                    in.close();
                }
                finally {
                    out.close();
                }
            }
        }));
    }

    public boolean copyStream$default$3() {
        return false;
    }

    public boolean copyStream$default$4() {
        return false;
    }

    public void copyFileStreamNIO(FileChannel input, FileChannel output, long startPosition, long bytesToCopy) {
        long initialPos = output.position();
        LongRef count = LongRef.create((long)0L);
        while (count.elem < bytesToCopy) {
            count.elem += input.transferTo(count.elem + startPosition, bytesToCopy - count.elem, output);
        }
        Predef$.MODULE$.assert(count.elem == bytesToCopy, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("request to copy ").append(bytesToCopy).append(" bytes, but actually copied ").append(count$1.elem).append(" bytes.").toString());
        long finalPos = output.position();
        long expectedPos = initialPos + bytesToCopy;
        Predef$.MODULE$.assert(finalPos == expectedPos, (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(334).append("\n         |Current position ").append(finalPos).append(" do not equal to expected position ").append(expectedPos).append("\n         |after transferTo, please check your kernel version to see if it is 2.6.32,\n         |this is a kernel bug which will lead to unexpected behavior when using transferTo.\n         |You can set spark.file.transferTo = false to disable this NIO feature.\n           ").toString())).stripMargin());
    }

    public String encodeFileNameToURIRawPath(String fileName) {
        Predef$.MODULE$.require(!fileName.contains("/") && !fileName.contains("\\"));
        return new URI("file", null, "localhost", -1, new StringBuilder(1).append("/").append(fileName).toString(), null, null).getRawPath().substring(1);
    }

    public String decodeFileNameInURI(URI uri) {
        String rawPath = uri.getRawPath();
        String rawFileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rawPath.split("/"))).last();
        return new URI(new StringBuilder(8).append("file:///").append(rawFileName).toString()).getPath().substring(1);
    }

    public <T> Tuple2<T, Object> timeTakenMs(Function0<T> body) {
        long startTime = System.nanoTime();
        Object result = body.apply();
        long endTime = System.nanoTime();
        return new Tuple2(result, (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(TimeUnit.NANOSECONDS.toMillis(endTime - startTime), 0L)));
    }

    private void downloadFile(String url, InputStream in, File destFile, boolean fileOverwrite) {
        File tempFile = File.createTempFile("fetchFileTemp", null, new File(destFile.getParentFile().getAbsolutePath()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Fetching ").append(url).append(" to ").append(tempFile).toString());
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            this.copyStream(in, out, true, this.copyStream$default$4());
            this.copyFile(url, tempFile, destFile, fileOverwrite, true);
        }
        finally {
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(String url, File sourceFile, File destFile, boolean fileOverwrite, boolean removeSourceFile) {
        if (destFile.exists()) {
            if (!this.filesEqualRecursive(sourceFile, destFile)) {
                if (!fileOverwrite) throw new IOException(new StringBuilder(44).append("File ").append(destFile).append(" exists and does not match contents of ").append(url).toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("File ").append(destFile).append(" exists and does not match contents of ").append(url).append(", replacing it with ").append(url).toString());
                if (!destFile.delete()) {
                    throw new IOException(new StringOps(Predef$.MODULE$.augmentString("Failed to delete %s while attempting to overwrite it with %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destFile.getAbsolutePath(), sourceFile.getAbsolutePath()})));
                }
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("%s has been previously copied to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceFile.getAbsolutePath(), destFile.getAbsolutePath()})));
                return;
            }
        }
        if (removeSourceFile) {
            java.nio.file.Files.move(sourceFile.toPath(), destFile.toPath(), new CopyOption[0]);
            return;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Copying ").append(sourceFile.getAbsolutePath()).append(" to ").append(destFile.getAbsolutePath()).toString());
            this.copyRecursive(sourceFile, destFile);
        }
    }

    private boolean copyFile$default$5() {
        return false;
    }

    private boolean filesEqualRecursive(File file1, File file2) {
        boolean bl;
        if (file1.isDirectory() && file2.isDirectory()) {
            File[] subfiles1 = file1.listFiles();
            File[] subfiles2 = file2.listFiles();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles1)).size() != new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles2)).size()) {
                return false;
            }
            bl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles1)).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), (Ordering)Ordering.String$.MODULE$))).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles2)).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), (Ordering)Ordering.String$.MODULE$)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IOTool$.$anonfun$filesEqualRecursive$3(x0$1)));
        } else {
            bl = file1.isFile() && file2.isFile() ? Files.equal(file1, file2) : false;
        }
        return bl;
    }

    private void copyRecursive(File source, File dest) {
        if (source.isDirectory()) {
            if (!dest.mkdir()) {
                throw new IOException(new StringBuilder(27).append("Failed to create directory ").append(dest.getPath()).toString());
            }
            File[] subfiles = source.listFiles();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles)).foreach((Function1 & Serializable & scala.Serializable)f -> {
                IOTool$.MODULE$.copyRecursive(f, new File(dest, f.getName()));
                return BoxedUnit.UNIT;
            });
        } else {
            java.nio.file.Files.copy(source.toPath(), dest.toPath(), new CopyOption[0]);
        }
    }

    public void validateURL(URI uri) throws MalformedURLException {
        String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "file");
        boolean bl = "http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string));
        if (bl) {
            BoxedUnit boxedUnit;
            try {
                uri.toURL();
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (MalformedURLException e) {
                MalformedURLException ex = new MalformedURLException(new StringBuilder(26).append("URI (").append(uri.toString()).append(") is not a valid URL.").toString());
                ex.initCause(e);
                throw ex;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public File tempFileWith(File path) {
        return new File(new StringBuilder(1).append(path.getAbsolutePath()).append(".").append(UUID.randomUUID()).toString());
    }

    public <T> Seq<T> randomize(TraversableOnce<T> seq, ClassTag<T> evidence$1) {
        return Predef$.MODULE$.genericWrapArray(this.randomizeInPlace(seq.toArray(evidence$1), this.randomizeInPlace$default$2()));
    }

    public <T> Object randomizeInPlace(Object arr, Random rand) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(arr) - 1), 1).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int j = rand.nextInt(i + 1);
            Object tmp = ScalaRunTime$.MODULE$.array_apply(arr, j);
            ScalaRunTime$.MODULE$.array_update(arr, j, ScalaRunTime$.MODULE$.array_apply(arr, i));
            ScalaRunTime$.MODULE$.array_update(arr, i, tmp);
        });
        return arr;
    }

    public <T> Random randomizeInPlace$default$2() {
        return new Random();
    }

    public long getFileLength(File file) {
        return file.getName().endsWith(".gz") ? this.getCompressedFileLength(file) : file.length();
    }

    /*
     * WARNING - void declaration
     */
    private long getCompressedFileLength(File file) {
        void v0;
        try (GZIPInputStream gzInputStream = null;){
            try {
                void var3_3;
                long fileSize = 0L;
                gzInputStream = new GZIPInputStream(new FileInputStream(file));
                int bufSize = 1024;
                byte[] buf = new byte[bufSize];
                int numBytes = ByteStreams.read(gzInputStream, buf, 0, bufSize);
                while (numBytes > 0) {
                    fileSize += (long)numBytes;
                    numBytes = ByteStreams.read(gzInputStream, buf, 0, bufSize);
                }
                v0 = var3_3;
            }
            catch (Throwable e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Cannot get file length of ").append(file).toString(), e);
                throw e;
            }
        }
        return (long)v0;
    }

    public String offsetBytes(String path, long length, long start, long end) {
        File file = new File(path);
        long effectiveEnd = package$.MODULE$.min(length, end);
        long effectiveStart = package$.MODULE$.max(0L, start);
        byte[] buff = new byte[(int)(effectiveEnd - effectiveStart)];
        try (InputStream stream = path.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);){
            ByteStreams.skipFully(stream, effectiveStart);
            ByteStreams.readFully(stream, buff);
        }
        return Source$.MODULE$.fromBytes(buff, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String offsetBytes(Seq<File> files, Seq<Object> fileLengths, long start, long end) {
        Predef$.MODULE$.assert(files.length() == fileLengths.length());
        long startIndex = package$.MODULE$.max(start, 0L);
        long endIndex = package$.MODULE$.min(end, BoxesRunTime.unboxToLong((Object)fileLengths.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Map fileToLength = ((TraversableOnce)files.zip(fileLengths, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Log files: \n").append(fileToLength.mkString("\n")).toString());
        StringBuffer stringBuffer = new StringBuffer((int)(endIndex - startIndex));
        LongRef sum = LongRef.create((long)0L);
        ((IterableLike)files.zip(fileLengths, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IOTool$.$anonfun$offsetBytes$2(sum, fileToLength, endIndex, startIndex, stringBuffer, x0$1);
            return BoxedUnit.UNIT;
        });
        return stringBuffer.toString();
    }

    public void symlink(File src, File dst) {
        if (!src.isAbsolute()) {
            throw new IOException("Source must be absolute");
        }
        if (dst.isAbsolute()) {
            throw new IOException("Destination must be relative");
        }
        java.nio.file.Files.createSymbolicLink(dst.toPath(), src.toPath(), new FileAttribute[0]);
    }

    public FileSystem getHadoopFileSystem(URI path, Configuration conf) {
        return FileSystem.get((URI)path, (Configuration)conf);
    }

    public FileSystem getHadoopFileSystem(String path, Configuration conf) {
        return this.getHadoopFileSystem(new URI(path), conf);
    }

    public boolean isInDirectory(File parent, File child) {
        while (child != null && parent != null) {
            if (!(child.exists() && parent.exists() && parent.isDirectory())) {
                return false;
            }
            if (parent.equals(child)) {
                return true;
            }
            child = child.getParentFile();
        }
        return false;
    }

    public Map<String, String> getPropertiesFromFile(String filename) {
        Map map;
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Properties file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Properties file ").append(file).append(" is not a normal file").toString());
        try (InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            try {
                Properties properties = new Properties();
                properties.load(inReader);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)MODULE$.trimExceptCRLF(properties.getProperty((String)k))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            catch (IOException e) {
                throw new RuntimeException(new StringBuilder(42).append("Failed when loading Spark properties from ").append(filename).toString(), e);
            }
        }
        return map;
    }

    private String trimExceptCRLF(String str) {
        Function1 & Serializable & scala.Serializable nonSpaceOrNaturalLineDelimiter = (Function1 & Serializable & scala.Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)IOTool$.$anonfun$trimExceptCRLF$1(BoxesRunTime.unboxToChar((Object)ch)));
        int firstPos = new StringOps(Predef$.MODULE$.augmentString(str)).indexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        int lastPos = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        return firstPos >= 0 && lastPos >= 0 ? str.substring(firstPos, lastPos + 1) : "";
    }

    public void writeUTF(String str, DataOutputStream dataOut) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        dataOut.write(bytes);
    }

    public static final /* synthetic */ boolean $anonfun$doesDirectoryContainAnyNewFiles$1(long cutoffTimeInMillis$1, File x$1) {
        return x$1.lastModified() > cutoffTimeInMillis$1;
    }

    public static final /* synthetic */ boolean $anonfun$filesEqualRecursive$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File f1 = (File)tuple2._1();
        File f2 = (File)tuple2._2();
        boolean bl = MODULE$.filesEqualRecursive(f1, f2);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$offsetBytes$2(LongRef sum$1, Map fileToLength$1, long endIndex$1, long startIndex$1, StringBuffer stringBuffer$1, Tuple2 x0$1) {
        File file;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object object;
            file = (File)tuple2._1();
            long fileLength = tuple2._2$mcJ$sp();
            long startIndexOfFile = sum$1.elem;
            long endIndexOfFile = sum$1.elem + BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file));
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Processing file ").append(file).append(", ").append("with start index = ").append(startIndexOfFile).append(", end index = ").append(endIndex$1).toString());
            if (startIndex$1 <= startIndexOfFile && endIndex$1 >= endIndexOfFile) {
                object = stringBuffer$1.append(MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, 0L, BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file))));
            } else if (startIndex$1 > startIndexOfFile && startIndex$1 < endIndexOfFile) {
                long effectiveStartIndex = startIndex$1 - startIndexOfFile;
                long effectiveEndIndex = package$.MODULE$.min(endIndex$1 - startIndexOfFile, BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file)));
                object = stringBuffer$1.append(MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
            } else if (endIndex$1 > startIndexOfFile && endIndex$1 < endIndexOfFile) {
                long effectiveStartIndex = package$.MODULE$.max(startIndex$1 - startIndexOfFile, 0L);
                long effectiveEndIndex = endIndex$1 - startIndexOfFile;
                object = stringBuffer$1.append(MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
            } else {
                object = BoxedUnit.UNIT;
            }
            sum$1.elem += BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file));
        } else {
            throw new MatchError((Object)tuple2);
        }
        MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("After processing file ").append(file).append(", string built is ").append(stringBuffer$1.toString()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$trimExceptCRLF$1(char ch) {
        return ch > ' ' || ch == '\r' || ch == '\n';
    }

    private IOTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

