/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.kv;

import java.util.Arrays;
import tech.mlsql.common.utils.base.Preconditions;

class ArrayWrappers {
    ArrayWrappers() {
    }

    public static Comparable<Object> forArray(Object a) {
        Comparable<ComparableIntArray> ret;
        Preconditions.checkArgument(a.getClass().isArray());
        if (a instanceof int[]) {
            ret = new ComparableIntArray((int[])a);
        } else if (a instanceof long[]) {
            ret = new ComparableLongArray((long[])a);
        } else if (a instanceof byte[]) {
            ret = new ComparableByteArray((byte[])a);
        } else {
            Preconditions.checkArgument(!a.getClass().getComponentType().isPrimitive());
            ret = new ComparableObjectArray((Object[])a);
        }
        return ret;
    }

    private static class ComparableObjectArray
    implements Comparable<ComparableObjectArray> {
        private final Object[] array;

        ComparableObjectArray(Object[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableObjectArray)) {
                return false;
            }
            return Arrays.equals(this.array, ((ComparableObjectArray)other).array);
        }

        public int hashCode() {
            int code = 0;
            for (int i = 0; i < this.array.length; ++i) {
                code = code * 31 + this.array[i].hashCode();
            }
            return code;
        }

        @Override
        public int compareTo(ComparableObjectArray other) {
            int len = Math.min(this.array.length, other.array.length);
            for (int i = 0; i < len; ++i) {
                int diff = ((Comparable)this.array[i]).compareTo((Comparable)other.array[i]);
                if (diff == 0) continue;
                return diff;
            }
            return this.array.length - other.array.length;
        }
    }

    private static class ComparableByteArray
    implements Comparable<ComparableByteArray> {
        private final byte[] array;

        ComparableByteArray(byte[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableByteArray)) {
                return false;
            }
            return Arrays.equals(this.array, ((ComparableByteArray)other).array);
        }

        public int hashCode() {
            int code = 0;
            for (int i = 0; i < this.array.length; ++i) {
                code = code * 31 + this.array[i];
            }
            return code;
        }

        @Override
        public int compareTo(ComparableByteArray other) {
            int len = Math.min(this.array.length, other.array.length);
            for (int i = 0; i < len; ++i) {
                int diff = this.array[i] - other.array[i];
                if (diff == 0) continue;
                return diff;
            }
            return this.array.length - other.array.length;
        }
    }

    private static class ComparableLongArray
    implements Comparable<ComparableLongArray> {
        private final long[] array;

        ComparableLongArray(long[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableLongArray)) {
                return false;
            }
            return Arrays.equals(this.array, ((ComparableLongArray)other).array);
        }

        public int hashCode() {
            int code = 0;
            for (int i = 0; i < this.array.length; ++i) {
                code = code * 31 + (int)this.array[i];
            }
            return code;
        }

        @Override
        public int compareTo(ComparableLongArray other) {
            int len = Math.min(this.array.length, other.array.length);
            for (int i = 0; i < len; ++i) {
                long diff = this.array[i] - other.array[i];
                if (diff == 0L) continue;
                return diff > 0L ? 1 : -1;
            }
            return this.array.length - other.array.length;
        }
    }

    private static class ComparableIntArray
    implements Comparable<ComparableIntArray> {
        private final int[] array;

        ComparableIntArray(int[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableIntArray)) {
                return false;
            }
            return Arrays.equals(this.array, ((ComparableIntArray)other).array);
        }

        public int hashCode() {
            int code = 0;
            for (int i = 0; i < this.array.length; ++i) {
                code = code * 31 + this.array[i];
            }
            return code;
        }

        @Override
        public int compareTo(ComparableIntArray other) {
            int len = Math.min(this.array.length, other.array.length);
            for (int i = 0; i < len; ++i) {
                int diff = this.array[i] - other.array[i];
                if (diff == 0) continue;
                return diff;
            }
            return this.array.length - other.array.length;
        }
    }
}

