/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.kv;

import tech.mlsql.common.utils.base.Preconditions;
import tech.mlsql.common.utils.kv.KVStoreIterator;

public abstract class KVStoreView<T>
implements Iterable<T> {
    final Class<T> type;
    boolean ascending = true;
    String index = "__main__";
    Object first = null;
    Object last = null;
    Object parent = null;
    long skip = 0L;
    long max = Long.MAX_VALUE;

    public KVStoreView(Class<T> type) {
        this.type = type;
    }

    public KVStoreView<T> reverse() {
        this.ascending = !this.ascending;
        return this;
    }

    public KVStoreView<T> index(String name) {
        this.index = Preconditions.checkNotNull(name);
        return this;
    }

    public KVStoreView<T> parent(Object value) {
        this.parent = value;
        return this;
    }

    public KVStoreView<T> first(Object value) {
        this.first = value;
        return this;
    }

    public KVStoreView<T> last(Object value) {
        this.last = value;
        return this;
    }

    public KVStoreView<T> max(long max) {
        Preconditions.checkArgument(max > 0L, "max must be positive.");
        this.max = max;
        return this;
    }

    public KVStoreView<T> skip(long n) {
        this.skip = n;
        return this;
    }

    public KVStoreIterator<T> closeableIterator() throws Exception {
        return (KVStoreIterator)this.iterator();
    }
}

