/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.kv;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import tech.mlsql.common.utils.annotations.VisibleForTesting;
import tech.mlsql.common.utils.base.Preconditions;
import tech.mlsql.common.utils.base.Throwables;
import tech.mlsql.common.utils.kv.KVStore;
import tech.mlsql.common.utils.kv.KVStoreSerializer;
import tech.mlsql.common.utils.kv.KVStoreView;
import tech.mlsql.common.utils.kv.LevelDBIterator;
import tech.mlsql.common.utils.kv.LevelDBTypeInfo;
import tech.mlsql.common.utils.kv.UnsupportedStoreVersionException;

public class LevelDB
implements KVStore {
    @VisibleForTesting
    static final long STORE_VERSION = 1L;
    @VisibleForTesting
    static final byte[] STORE_VERSION_KEY = "__version__".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METADATA_KEY = "__meta__".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TYPE_ALIASES_KEY = "__types__".getBytes(StandardCharsets.UTF_8);
    final AtomicReference<DB> _db;
    final KVStoreSerializer serializer;
    private final ConcurrentMap<String, byte[]> typeAliases;
    private final ConcurrentMap<Class<?>, LevelDBTypeInfo> types;

    public LevelDB(File path) throws Exception {
        this(path, new KVStoreSerializer());
    }

    public LevelDB(File path, KVStoreSerializer serializer) throws Exception {
        Map<Object, Object> aliases;
        this.serializer = serializer;
        this.types = new ConcurrentHashMap();
        Options options = new Options();
        options.createIfMissing(true);
        this._db = new AtomicReference<DB>(JniDBFactory.factory.open(path, options));
        byte[] versionData = this.db().get(STORE_VERSION_KEY);
        if (versionData != null) {
            long version = serializer.deserializeLong(versionData);
            if (version != 1L) {
                this.close();
                throw new UnsupportedStoreVersionException();
            }
        } else {
            this.db().put(STORE_VERSION_KEY, serializer.serialize(1L));
        }
        try {
            aliases = this.get((byte[])LevelDB.TYPE_ALIASES_KEY, TypeAliases.class).aliases;
        }
        catch (NoSuchElementException e) {
            aliases = new HashMap();
        }
        this.typeAliases = new ConcurrentHashMap<String, byte[]>(aliases);
    }

    @Override
    public <T> T getMetadata(Class<T> klass) throws Exception {
        try {
            return this.get(METADATA_KEY, klass);
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    @Override
    public void setMetadata(Object value) throws Exception {
        if (value != null) {
            this.put(METADATA_KEY, value);
        } else {
            this.db().delete(METADATA_KEY);
        }
    }

    <T> T get(byte[] key, Class<T> klass) throws Exception {
        byte[] data = this.db().get(key);
        if (data == null) {
            throw new NoSuchElementException(new String(key, StandardCharsets.UTF_8));
        }
        return this.serializer.deserialize(data, klass);
    }

    private void put(byte[] key, Object value) throws Exception {
        Preconditions.checkArgument(value != null, "Null values are not allowed.");
        this.db().put(key, this.serializer.serialize(value));
    }

    @Override
    public <T> T read(Class<T> klass, Object naturalKey) throws Exception {
        Preconditions.checkArgument(naturalKey != null, "Null keys are not allowed.");
        byte[] key = this.getTypeInfo(klass).naturalIndex().start(null, naturalKey);
        return this.get(key, klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object value) throws Exception {
        Preconditions.checkArgument(value != null, "Null values are not allowed.");
        LevelDBTypeInfo ti = this.getTypeInfo(value.getClass());
        try (WriteBatch batch = this.db().createWriteBatch();){
            byte[] data = this.serializer.serialize(value);
            LevelDBTypeInfo levelDBTypeInfo = ti;
            synchronized (levelDBTypeInfo) {
                Object existing;
                try {
                    existing = this.get(ti.naturalIndex().entityKey(null, value), value.getClass());
                }
                catch (NoSuchElementException e) {
                    existing = null;
                }
                PrefixCache cache = new PrefixCache(value);
                byte[] naturalKey = ti.naturalIndex().toKey(ti.naturalIndex().getValue(value));
                for (LevelDBTypeInfo.Index idx : ti.indices()) {
                    byte[] prefix = cache.getPrefix(idx);
                    idx.add(batch, value, existing, data, naturalKey, prefix);
                }
                this.db().write(batch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Class<?> type, Object naturalKey) throws Exception {
        Preconditions.checkArgument(naturalKey != null, "Null keys are not allowed.");
        try (WriteBatch batch = this.db().createWriteBatch();){
            LevelDBTypeInfo ti = this.getTypeInfo(type);
            byte[] key = ti.naturalIndex().start(null, naturalKey);
            LevelDBTypeInfo levelDBTypeInfo = ti;
            synchronized (levelDBTypeInfo) {
                byte[] data = this.db().get(key);
                if (data != null) {
                    Object existing = this.serializer.deserialize(data, type);
                    PrefixCache cache = new PrefixCache(existing);
                    byte[] keyBytes = ti.naturalIndex().toKey(ti.naturalIndex().getValue(existing));
                    for (LevelDBTypeInfo.Index idx : ti.indices()) {
                        idx.remove(batch, existing, keyBytes, cache.getPrefix(idx));
                    }
                    this.db().write(batch);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public <T> KVStoreView<T> view(Class<T> type) throws Exception {
        return new KVStoreView<T>(type){

            @Override
            public Iterator<T> iterator() {
                try {
                    return new LevelDBIterator(LevelDB.this, this);
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            }
        };
    }

    @Override
    public long count(Class<?> type) throws Exception {
        LevelDBTypeInfo.Index idx = this.getTypeInfo(type).naturalIndex();
        return idx.getCount(idx.end(null));
    }

    @Override
    public long count(Class<?> type, String index, Object indexedValue) throws Exception {
        LevelDBTypeInfo.Index idx = this.getTypeInfo(type).index(index);
        return idx.getCount(idx.end(null, indexedValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        AtomicReference<DB> atomicReference = this._db;
        synchronized (atomicReference) {
            DB _db = this._db.getAndSet(null);
            if (_db == null) {
                return;
            }
            try {
                _db.close();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeIterator(LevelDBIterator<?> it) throws IOException {
        AtomicReference<DB> atomicReference = this._db;
        synchronized (atomicReference) {
            DB _db = this._db.get();
            if (_db != null) {
                it.close();
            }
        }
    }

    LevelDBTypeInfo getTypeInfo(Class<?> type) throws Exception {
        LevelDBTypeInfo tmp;
        LevelDBTypeInfo ti = (LevelDBTypeInfo)this.types.get(type);
        if (ti == null && (ti = this.types.putIfAbsent(type, tmp = new LevelDBTypeInfo(this, type, this.getTypeAlias(type)))) == null) {
            ti = tmp;
        }
        return ti;
    }

    DB db() {
        DB _db = this._db.get();
        if (_db == null) {
            throw new IllegalStateException("DB is closed.");
        }
        return _db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getTypeAlias(Class<?> klass) throws Exception {
        byte[] alias = (byte[])this.typeAliases.get(klass.getName());
        if (alias == null) {
            ConcurrentMap<String, byte[]> concurrentMap = this.typeAliases;
            synchronized (concurrentMap) {
                byte[] tmp = String.valueOf(this.typeAliases.size()).getBytes(StandardCharsets.UTF_8);
                alias = this.typeAliases.putIfAbsent(klass.getName(), tmp);
                if (alias == null) {
                    alias = tmp;
                    this.put(TYPE_ALIASES_KEY, new TypeAliases(this.typeAliases));
                }
            }
        }
        return alias;
    }

    private static class PrefixCache {
        private final Object entity;
        private final Map<LevelDBTypeInfo.Index, byte[]> prefixes;

        PrefixCache(Object entity) {
            this.entity = entity;
            this.prefixes = new HashMap<LevelDBTypeInfo.Index, byte[]>();
        }

        byte[] getPrefix(LevelDBTypeInfo.Index idx) throws Exception {
            byte[] prefix = null;
            if (idx.isChild() && (prefix = this.prefixes.get(idx.parent())) == null) {
                prefix = idx.parent().childPrefix(idx.parent().getValue(this.entity));
                this.prefixes.put(idx.parent(), prefix);
            }
            return prefix;
        }
    }

    public static class TypeAliases {
        public Map<String, byte[]> aliases;

        TypeAliases(Map<String, byte[]> aliases) {
            this.aliases = aliases;
        }

        TypeAliases() {
            this(null);
        }
    }
}

