/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.kv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.iq80.leveldb.DBIterator;
import tech.mlsql.common.utils.annotations.VisibleForTesting;
import tech.mlsql.common.utils.base.Preconditions;
import tech.mlsql.common.utils.base.Throwables;
import tech.mlsql.common.utils.kv.KVStoreIterator;
import tech.mlsql.common.utils.kv.KVStoreView;
import tech.mlsql.common.utils.kv.LevelDB;
import tech.mlsql.common.utils.kv.LevelDBTypeInfo;

class LevelDBIterator<T>
implements KVStoreIterator<T> {
    private final LevelDB db;
    private final boolean ascending;
    private final DBIterator it;
    private final Class<T> type;
    private final LevelDBTypeInfo ti;
    private final LevelDBTypeInfo.Index index;
    private final byte[] indexKeyPrefix;
    private final byte[] end;
    private final long max;
    private boolean checkedNext;
    private byte[] next;
    private boolean closed;
    private long count;

    LevelDBIterator(LevelDB db, KVStoreView<T> params) throws Exception {
        this.db = db;
        this.ascending = params.ascending;
        this.it = db.db().iterator();
        this.type = params.type;
        this.ti = db.getTypeInfo(this.type);
        this.index = this.ti.index(params.index);
        this.max = params.max;
        Preconditions.checkArgument(!this.index.isChild() || params.parent != null, "Cannot iterate over child index %s without parent value.", params.index);
        byte[] parent = this.index.isChild() ? this.index.parent().childPrefix(params.parent) : null;
        this.indexKeyPrefix = this.index.keyPrefix(parent);
        byte[] firstKey = params.first != null ? (this.ascending ? this.index.start(parent, params.first) : this.index.end(parent, params.first)) : (this.ascending ? this.index.keyPrefix(parent) : this.index.end(parent));
        this.it.seek(firstKey);
        byte[] end = null;
        if (this.ascending) {
            end = params.last != null ? this.index.end(parent, params.last) : this.index.end(parent);
        } else {
            byte[] nextKey;
            if (params.last != null) {
                end = this.index.start(parent, params.last);
            }
            if (this.it.hasNext() && LevelDBIterator.compare(nextKey = (byte[])this.it.peekNext().getKey(), this.indexKeyPrefix) <= 0) {
                this.it.next();
            }
        }
        this.end = end;
        if (params.skip > 0L) {
            this.skip(params.skip);
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.checkedNext && !this.closed) {
            this.next = this.loadNext();
            this.checkedNext = true;
        }
        if (!this.closed && this.next == null) {
            try {
                this.close();
            }
            catch (IOException ioe) {
                throw Throwables.propagate(ioe);
            }
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.checkedNext = false;
        try {
            T ret;
            if (this.index == null || this.index.isCopy()) {
                ret = this.db.serializer.deserialize(this.next, this.type);
            } else {
                byte[] key = this.ti.buildKey(false, (byte[][])new byte[][]{this.ti.naturalIndex().keyPrefix(null), this.next});
                ret = this.db.get(key, this.type);
            }
            this.next = null;
            return ret;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> next(int max) {
        ArrayList<T> list = new ArrayList<T>(max);
        while (this.hasNext() && list.size() < max) {
            list.add(this.next());
        }
        return list;
    }

    @Override
    public boolean skip(long n) {
        long skipped = 0L;
        while (skipped < n) {
            boolean hasNext;
            if (this.next != null) {
                this.checkedNext = false;
                this.next = null;
                ++skipped;
                continue;
            }
            boolean bl = hasNext = this.ascending ? this.it.hasNext() : this.it.hasPrev();
            if (!hasNext) {
                this.checkedNext = true;
                return false;
            }
            Map.Entry e = this.ascending ? (Map.Entry)this.it.next() : this.it.prev();
            if (this.isEndMarker((byte[])e.getKey())) continue;
            ++skipped;
        }
        return this.hasNext();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.it.close();
            this.closed = true;
        }
    }

    protected void finalize() throws Throwable {
        this.db.closeIterator(this);
    }

    private byte[] loadNext() {
        if (this.count >= this.max) {
            return null;
        }
        try {
            int comp;
            Map.Entry nextEntry;
            byte[] nextKey;
            do {
                boolean hasNext;
                boolean bl = hasNext = this.ascending ? this.it.hasNext() : this.it.hasPrev();
                if (!hasNext) {
                    return null;
                }
                try {
                    nextEntry = this.ascending ? (Map.Entry)this.it.next() : this.it.prev();
                }
                catch (NoSuchElementException e) {
                    return null;
                }
                nextKey = (byte[])nextEntry.getKey();
                if (LevelDBIterator.startsWith(nextKey, this.indexKeyPrefix)) continue;
                return null;
            } while (this.isEndMarker(nextKey));
            if (this.end != null && (comp = LevelDBIterator.compare(nextKey, this.end) * (this.ascending ? 1 : -1)) > 0) {
                return null;
            }
            ++this.count;
            return (byte[])nextEntry.getValue();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @VisibleForTesting
    static boolean startsWith(byte[] key, byte[] prefix) {
        if (key.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (key[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isEndMarker(byte[] key) {
        return key.length > 2 && key[key.length - 2] == 0 && key[key.length - 1] == LevelDBTypeInfo.END_MARKER[0];
    }

    static int compare(byte[] a, byte[] b) {
        int diff = 0;
        int minLen = Math.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            if ((diff += a[i] - b[i]) == 0) continue;
            return diff;
        }
        return a.length - b.length;
    }
}

