/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.network;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class NetUtils {
    public static List<Integer> getPorts(int number, int MIN_PORT_NUMBER, int MAX_PORT_NUMBER) {
        int start = MIN_PORT_NUMBER + 1;
        boolean stop = false;
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (!stop && start < MAX_PORT_NUMBER) {
            if (!NetUtils.available(start, MIN_PORT_NUMBER, MAX_PORT_NUMBER)) continue;
            result.add(start);
            if (result.size() == number) {
                stop = true;
            }
            ++start;
        }
        if (result.size() != number) {
            throw new IllegalArgumentException("Can not collect enough port in range " + MIN_PORT_NUMBER + " and " + MAX_PORT_NUMBER);
        }
        return result;
    }

    public static String getHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ServerSocket holdPort(int port) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ss;
    }

    public static void releasePort(ServerSocket ss) {
        if (ss == null) {
            return;
        }
        try {
            ss.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port, int MIN_PORT_NUMBER, int MAX_PORT_NUMBER) {
        if (port < MIN_PORT_NUMBER || port > MAX_PORT_NUMBER) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int availableAndReturn(String hostname, int MIN_PORT_NUMBER, int MAX_PORT_NUMBER) {
        boolean bindSuccess = false;
        Socket ss = null;
        Socket ss1 = null;
        AtomicInteger start = new AtomicInteger(MIN_PORT_NUMBER);
        while (!bindSuccess && start.get() < MAX_PORT_NUMBER) {
            try {
                ss = new Socket();
                ss.bind(new InetSocketAddress(hostname, start.get()));
                ss.close();
                if (hostname != "0.0.0.0") {
                    ss1 = new Socket();
                    ss1.bind(new InetSocketAddress("0.0.0.0", start.get()));
                }
                bindSuccess = true;
            }
            catch (IOException e) {
                bindSuccess = false;
                start.set(start.get() + 1);
            }
            finally {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException iOException) {}
                }
                if (ss1 == null) continue;
                try {
                    ss1.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bindSuccess) {
            return start.get();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerSocket availableAndReturn(int MIN_PORT_NUMBER, int MAX_PORT_NUMBER) {
        boolean bindSuccess = false;
        ServerSocket ss = null;
        AtomicInteger start = new AtomicInteger(MIN_PORT_NUMBER);
        while (!bindSuccess && start.get() < MAX_PORT_NUMBER) {
            try {
                ss = new ServerSocket(start.get());
                ss.setReuseAddress(true);
                bindSuccess = true;
            }
            catch (IOException e) {
                bindSuccess = false;
                start.set(start.get() + 1);
            }
            finally {
                if (ss == null || bindSuccess) continue;
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ss;
    }
}

