/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.shell.command;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;

public class NumberUtil {
    private static final String NUM_REGEX = "^(\\+|\\-)?(0+\\.[\\d]+|[1-9]+[\\d]*\\.[\\d]+|[\\d]+)$";

    public static boolean isNum(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return str.matches(NUM_REGEX);
    }

    private static void testIsNum() {
        System.out.println(!NumberUtil.isNum(null));
        System.out.println(!NumberUtil.isNum(""));
        System.out.println(!NumberUtil.isNum("NaN"));
        System.out.println(!NumberUtil.isNum(" "));
        System.out.println(!NumberUtil.isNum("-"));
        System.out.println(!NumberUtil.isNum("-adf"));
        System.out.println(NumberUtil.isNum("-123"));
        System.out.println(NumberUtil.isNum("-0.123"));
        System.out.println(NumberUtil.isNum("+0.123"));
        System.out.println(NumberUtil.isNum("0.123"));
        System.out.println(NumberUtil.isNum("234234"));
        System.out.println(NumberUtil.isNum("234234.343"));
        System.out.println(NumberUtil.isNum("234234"));
        System.out.println(NumberUtil.isNum("1324791546078"));
    }

    public static int parseNumber(Object obj) {
        int result = 0;
        try {
            result = Integer.valueOf(obj.toString());
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public static long parseLong(Object obj) {
        long result = 0L;
        try {
            result = Long.valueOf(obj.toString());
        }
        catch (Exception e) {
            result = 0L;
        }
        return result;
    }

    public static double parseDouble(Object obj) {
        double result = 0.0;
        try {
            result = Double.valueOf(obj.toString());
        }
        catch (Exception e) {
            result = 0.0;
        }
        return result;
    }

    public static float parseFloat(Object obj) {
        float result = 0.0f;
        try {
            result = Float.valueOf(obj.toString()).floatValue();
        }
        catch (Exception e) {
            result = 0.0f;
        }
        return result;
    }

    public static String toNumStr(Object obj) {
        int result = 0;
        try {
            result = Integer.valueOf(obj.toString());
        }
        catch (Exception e) {
            result = 0;
        }
        return String.valueOf(result);
    }

    public static double dealDecimal(double d, DecimalFormat df) {
        double pd = 0.0;
        try {
            pd = NumberUtil.parseDouble(df.format(d));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pd;
    }

    public static double dealDecimal(double d, int num) {
        double result = 0.0;
        try {
            StringBuffer pattern = new StringBuffer("#");
            if (num > 0) {
                pattern.append(".");
            }
            for (int i = 1; i <= num; ++i) {
                pattern.append("0");
            }
            DecimalFormat df = new DecimalFormat(pattern.toString());
            result = NumberUtil.dealDecimal(d, df);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static int getRandNum(int start, int end) {
        int result = start + new Random().nextInt(5);
        if (result > end) {
            result = end;
        }
        return result;
    }

    public static String getPercent(Object obj) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(2);
        format.format(obj);
        return format.format(obj);
    }

    public static String getNumTInt(Object obj) {
        DecimalFormat formatter = new DecimalFormat("###,###");
        return formatter.format(obj) + "";
    }

    public static String getNumInt(Object obj) {
        DecimalFormat formatter = new DecimalFormat("######");
        return formatter.format(obj) + "";
    }

    public static String getNumTPoint(Object obj) {
        DecimalFormat formatter = new DecimalFormat("###,###.###");
        return formatter.format(obj) + "";
    }

    public static double formatDaouble(double number, int digits) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        df.setMaximumFractionDigits(digits);
        return Double.parseDouble(df.format(number).replaceAll(",", ""));
    }

    public static int getIntValue(Object object) {
        if (object == null) {
            return 0;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getIntValue(Object object, int defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLongValue(Object object) {
        if (object == null) {
            return 0L;
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getLongValue(Object object, long defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getTimeValue(Object object) {
        if (object == null) {
            return 0;
        }
        try {
            String[] arr = object.toString().split(":");
            if (arr.length == 2) {
                return NumberUtil.getIntValue(arr[0]) * 60 + NumberUtil.getIntValue(arr[1]);
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static double getDoubleValue(Object object) {
        if (object == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static double getDoubleValue(Object object, double defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getPercent(String str1, String str2) {
        long long1 = NumberUtil.getLongValue(str1);
        long long2 = NumberUtil.getLongValue(str2);
        double r = 0.0;
        if (long2 > 0L && long1 > 0L) {
            r = (double)long1 * 1.0 / (double)long2;
        }
        return String.format("%.2f", r * 100.0);
    }

    public static String getPercent(String str1, String str2, int decimalNum) {
        long long1 = NumberUtil.getLongValue(str1);
        long long2 = NumberUtil.getLongValue(str2);
        double r = 0.0;
        if (long2 > 0L && long1 > 0L) {
            r = (double)long1 * 1.0 / (double)long2;
        }
        return String.format("%." + decimalNum + "f", r * 100.0);
    }

    public static void main(String[] args) {
        NumberUtil.testIsNum();
    }
}

