/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.common.utils.shell.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import tech.mlsql.common.utils.shell.command.NumberUtil;
import tech.mlsql.common.utils.shell.command.ParamOnlyParse;
import tech.mlsql.common.utils.shell.command.ParamOnlyParseIm;
import tech.mlsql.common.utils.shell.command.ParamPairParse;
import tech.mlsql.common.utils.shell.command.ParamPairParseIm;

public class ParamsUtil {
    private static final char PARAM_START_FLAG = '-';
    private static char[] PARAM_SPLIT_FLAG = new char[]{'\t', ' '};
    private static char PARAM_QUOTE_FLAG = (char)34;
    private char[] paramsCharArray;
    private String mainParam = null;
    private String startMainParam = null;
    private String endMainParam = null;
    private ParamPairParseIm paramPairParse;
    private ParamOnlyParseIm paramOnlyParse;
    private Map<String, String> paramsMap = new HashMap<String, String>();
    private String info;

    public ParamsUtil(String s, String info) {
        this.info = info;
        if (s != null && s.trim().length() > 0) {
            this.paramsCharArray = s.toCharArray();
            this.init();
            this.parse();
            if (this.hasParam("h") && info != null) {
                this.showHelp();
                System.exit(0);
            }
        }
    }

    public void showHelp() {
        if (this.info != null) {
            System.out.println("[\u4f7f\u7528\u5e2e\u52a9]");
            System.out.println(this.info);
        }
    }

    public ParamsUtil(String s) {
        this(s, null);
    }

    public ParamsUtil(String[] s) {
        this(s, null);
    }

    public ParamsUtil(String[] s, String info) {
        this(ParamsUtil.arrayToString(s, " "), info);
    }

    private void init() {
        this.paramPairParse = new ParamPairParse();
        this.paramOnlyParse = new ParamOnlyParse();
        Arrays.sort(PARAM_SPLIT_FLAG);
    }

    public static boolean isParamSplit(char c) {
        return Arrays.binarySearch(PARAM_SPLIT_FLAG, c) >= 0;
    }

    public static boolean isParamStart(char c) {
        return c == '-';
    }

    public static boolean isQuote(char c) {
        return PARAM_QUOTE_FLAG == c;
    }

    private void parse() {
        block3: {
            if (this.paramsCharArray == null) break block3;
            int len = this.paramsCharArray.length - 1;
            int mark = 0;
            do {
                char c;
                if (ParamsUtil.isParamStart(c = this.paramsCharArray[mark])) {
                    mark = this.paramPairParse.parse(this.paramsCharArray, mark + 1, this.paramsMap);
                    continue;
                }
                if (ParamsUtil.isParamSplit(c)) continue;
                StringBuilder param = new StringBuilder();
                mark = this.paramOnlyParse.parse(this.paramsCharArray, mark, param);
                if (this.startMainParam == null && this.paramsMap.size() == 0) {
                    this.startMainParam = param.toString().trim();
                    continue;
                }
                this.endMainParam = param.toString().trim();
            } while (++mark <= len);
        }
    }

    public String getParam(String key) {
        return this.paramsMap.get(key);
    }

    public int getIntParam(String key) {
        return NumberUtil.getIntValue(this.getParam(key));
    }

    public int getIntParamAndCheck(String key) throws Exception {
        if (this.hasParam(key)) {
            return NumberUtil.getIntValue(this.getParam(key));
        }
        this.showHelp();
        throw new Exception("\u53c2\u6570\u4e2d\u6ca1\u6709\u5305\u542b" + key + "\u53c2\u6570");
    }

    public void err(String key) throws Exception {
        this.showHelp();
        throw new Exception("\u53c2\u6570\u4e2d\u6ca1\u6709\u5305\u542b" + key + "\u53c2\u6570");
    }

    public int getIntParam(String key, int defaultValue) {
        return NumberUtil.getIntValue(this.getParam(key), defaultValue);
    }

    public long getLongParam(String key) {
        return NumberUtil.getLongValue(this.getParam(key));
    }

    public long getLongParamAndCheck(String key) throws Exception {
        if (this.hasParam(key)) {
            return NumberUtil.getLongValue(this.getParam(key));
        }
        this.showHelp();
        throw new Exception("\u53c2\u6570\u4e2d\u6ca1\u6709\u5305\u542b" + key + "\u53c2\u6570");
    }

    public long getLongParam(String key, long defaultValue) {
        return NumberUtil.getLongValue(this.getParam(key), defaultValue);
    }

    public double getDoubleParam(String key) {
        return NumberUtil.getDoubleValue(this.getParam(key));
    }

    public double getDoubleParamAndCheck(String key) throws Exception {
        if (this.hasParam(key)) {
            return NumberUtil.getDoubleValue(this.getParam(key));
        }
        this.showHelp();
        throw new Exception("\u53c2\u6570\u4e2d\u6ca1\u6709\u5305\u542b" + key + "\u53c2\u6570");
    }

    public double getDoubleParam(String key, double defaultValue) {
        return NumberUtil.getDoubleValue(this.getParam(key), defaultValue);
    }

    public boolean getBooleanParam(String key) {
        return "true".equals(this.getParam(key, "").toLowerCase());
    }

    public boolean getBooleanParamAndCheck(String key) throws Exception {
        if (this.hasParam(key)) {
            return "true".equals(this.getParam(key, "").toLowerCase());
        }
        this.showHelp();
        throw new Exception("\u53c2\u6570\u4e2d\u6ca1\u6709\u5305\u542b" + key + "\u53c2\u6570");
    }

    public boolean getBooleanParam(String key, boolean defaultValue) {
        if (this.hasParam(key)) {
            return this.getBooleanParam(key);
        }
        return defaultValue;
    }

    public Map<String, String> getParamsMap() {
        return this.paramsMap;
    }

    public String getMainParam() {
        if (this.endMainParam == null || this.endMainParam.isEmpty()) {
            return this.startMainParam;
        }
        return this.endMainParam;
    }

    public String getStartMainParam() {
        return this.startMainParam;
    }

    public String getEndMainParam() {
        return this.endMainParam;
    }

    public String getParam(String key, String defaultValue) {
        String value = this.paramsMap.get(key);
        return value == null || "".equals(value) ? defaultValue : value;
    }

    public boolean hasParam(String key) {
        return this.paramsMap.containsKey(key);
    }

    public boolean hasParamAndCheck(String key) throws Exception {
        if (this.paramsMap.containsKey(key)) {
            return true;
        }
        this.showHelp();
        throw new Exception("\u53c2\u6570\u4e2d\u6ca1\u6709\u5305\u542b" + key + "\u53c2\u6570");
    }

    public String getMainParamAndCheck() throws Exception {
        if (this.mainParam == null) {
            this.showHelp();
            throw new Exception("mainParam\u6ca1\u6709\u8bbe\u5b9a\u503c");
        }
        return this.mainParam;
    }

    public String getParamAndCheck(String key) throws Exception {
        String value = this.paramsMap.get(key);
        if (value == null) {
            this.showHelp();
            throw new Exception("\u53c2\u6570" + key + "\u6ca1\u6709\u8bbe\u5b9a\u503c");
        }
        return value;
    }

    public static String arrayToString(String[] s, String split) {
        if (s != null && split != null) {
            StringBuilder result = new StringBuilder();
            for (String c : s) {
                result.append(c).append(split);
            }
            if (result.length() > split.length()) {
                return result.substring(0, result.length() - split.length());
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        ParamsUtil paramsUtil = new ParamsUtil("sql ", "test asdfhasdf ");
        System.out.println(paramsUtil.getParamAndCheck("sql"));
    }
}

