/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.UpsertTableInDeltaConf;
import org.apache.spark.sql.delta.actions.Action;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3AAB\u0004\u0001%!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0011!Q\u0003A!A!\u0002\u0013Y\u0003\"\u0002\u0018\u0001\t\u0003y\u0003\"\u0002\u001b\u0001\t\u0003)$\u0001D+qg\u0016\u0014HoQ8n[&$(B\u0001\u0005\n\u0003\u0015!W\r\u001c;b\u0015\tQ1\"A\u0002tc2T!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VMZ\u0001\tI\u0016dG/\u0019'pOB\u00111\u0004H\u0007\u0002\u000f%\u0011Qd\u0002\u0002\t\t\u0016dG/\u0019'pO\u0006)!/\u001e8JIB\u0011\u0001e\n\b\u0003C\u0015\u0002\"AI\u000b\u000e\u0003\rR!\u0001J\t\u0002\rq\u0012xn\u001c;?\u0013\t1S#\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014\u0016\u0003%)\bo]3s\u0007>tg\r\u0005\u0002\u001cY%\u0011Qf\u0002\u0002\u0017+B\u001cXM\u001d;UC\ndW-\u00138EK2$\u0018mQ8oM\u00061A(\u001b8jiz\"B\u0001M\u00193gA\u00111\u0004\u0001\u0005\u00063\u0011\u0001\rA\u0007\u0005\u0006=\u0011\u0001\ra\b\u0005\u0006U\u0011\u0001\raK\u0001\u0007G>lW.\u001b;\u0015\tYJdH\u0014\t\u0003)]J!\u0001O\u000b\u0003\t1{gn\u001a\u0005\u0006u\u0015\u0001\raO\u0001\u0004ibt\u0007CA\u000e=\u0013\titAA\u000bPaRLW.[:uS\u000e$&/\u00198tC\u000e$\u0018n\u001c8\t\u000b}*\u0001\u0019\u0001!\u0002\u000f\u0005\u001cG/[8ogB\u0019\u0011IR%\u000f\u0005\t#eB\u0001\u0012D\u0013\u00051\u0012BA#\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0012%\u0003\u0007M+\u0017O\u0003\u0002F+A\u0011!\nT\u0007\u0002\u0017*\u0011qhB\u0005\u0003\u001b.\u0013a!Q2uS>t\u0007\"B(\u0006\u0001\u0004\u0001\u0016AA8q!\t\tFK\u0004\u0002\u001c%&\u00111kB\u0001\u0010\t\u0016dG/Y(qKJ\fG/[8og&\u0011QK\u0016\u0002\n\u001fB,'/\u0019;j_:T!aU\u0004")
public class UpsertCommit {
    private final DeltaLog deltaLog;
    private final String runId;
    private final UpsertTableInDeltaConf upserConf;

    public long commit(OptimisticTransaction txn, Seq<Action> actions, DeltaOperations.Operation op) {
        Object object;
        long l;
        int currentV = (int)this.deltaLog.snapshot().version();
        try {
            l = txn.commit(actions, op);
        }
        catch (Exception e) {
            Object object2 = this.upserConf.isBloomFilterEnable() ? this.cleanTmpBFIndex$1(currentV + 1) : BoxedUnit.UNIT;
            throw e;
        }
        long newV = l;
        if (newV > -1L) {
            if (this.upserConf.isBloomFilterEnable()) {
                this.mvBFIndex$1(newV);
                object = this.cleanOldBFIndex$1(newV - 1L);
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return newV;
    }

    private final Object cleanTmpBFIndex$1(long v) {
        Object object;
        try {
            Path newBFPathFs = new Path(this.deltaLog.dataPath(), new StringBuilder(11).append("_bf_index_").append(v).append("_").append(this.runId).toString());
            object = BoxesRunTime.boxToBoolean((boolean)this.deltaLog.fs().delete(newBFPathFs, true));
        }
        catch (Exception e1) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private final Object cleanOldBFIndex$1(long v) {
        Object object;
        try {
            Path newBFPathFs = new Path(this.deltaLog.dataPath(), new StringBuilder(10).append("_bf_index_").append(v).toString());
            object = BoxesRunTime.boxToBoolean((boolean)this.deltaLog.fs().delete(newBFPathFs, true));
        }
        catch (Exception e1) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private final Object mvBFIndex$1(long v) {
        Object object;
        try {
            Path newBFPathFs = new Path(this.deltaLog.dataPath(), new StringBuilder(11).append("_bf_index_").append(v).append("_").append(this.runId).toString());
            Path targetPath = new Path(this.deltaLog.dataPath(), new StringBuilder(10).append("_bf_index_").append(v).toString());
            object = BoxesRunTime.boxToBoolean((boolean)this.deltaLog.fs().rename(newBFPathFs, targetPath));
        }
        catch (Exception e1) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public UpsertCommit(DeltaLog deltaLog, String runId, UpsertTableInDeltaConf upserConf) {
        this.deltaLog = deltaLog;
        this.runId = runId;
        this.upserConf = upserConf;
    }
}

