/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.delta.sources.FullOuterJoinRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4Aa\u0003\u0007\u0001/!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!a\u0003A!A!\u0002\u0013i\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000bq\u0002A\u0011A\u001f\t\u000f\u0011\u0003!\u0019!C\u0001\u000b\"1a\n\u0001Q\u0001\n\u0019CQa\u0014\u0001\u0005\nACQA\u0018\u0001\u0005\n}CQ\u0001\u001b\u0001\u0005\u0002%\u0014A#\u00169tKJ$X*\u001a:hK*\u001bxN\u001c+p%><(BA\u0007\u000f\u0003\u0015!W\r\u001c;b\u0015\ty\u0001#A\u0002tc2T!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0004e><\bC\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\r\u0003\u001d\u0019x.\u001e:dKNL!\u0001J\u0011\u0003!\u0019+H\u000e\\(vi\u0016\u0014(j\\5o%><\u0018AB:dQ\u0016l\u0017\r\u0005\u0002(U5\t\u0001F\u0003\u0002*\u001d\u0005)A/\u001f9fg&\u00111\u0006\u000b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001\u0005;be\u001e,GOV1mk\u0016Le\u000eZ3y!\tIb&\u0003\u000205\t\u0019\u0011J\u001c;\u0002\u001f\u0011,g-Y;miRKW.\u001a.p]\u0016\u0004\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b\u001b\u001b\u0005)$B\u0001\u001c\u0017\u0003\u0019a$o\\8u}%\u0011\u0001HG\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u000295\u00051A(\u001b8jiz\"RA\u0010!B\u0005\u000e\u0003\"a\u0010\u0001\u000e\u00031AQAH\u0003A\u0002}AQ!J\u0003A\u0002\u0019BQ\u0001L\u0003A\u00025BQ\u0001M\u0003A\u0002E\n\u0001\u0002^5nKj{g.Z\u000b\u0002\rB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005kRLGNC\u0001L\u0003\u0011Q\u0017M^1\n\u00055C%\u0001\u0003+j[\u0016TvN\\3\u0002\u0013QLW.\u001a.p]\u0016\u0004\u0013!\u00039beN,'j]8o)\r\tFK\u0016\t\u00033IK!a\u0015\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006+\"\u0001\r!M\u0001\bUN|gn\u0015;s\u0011\u00159\u0006\u00021\u0001Y\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007#B\rZcm\u000b\u0016B\u0001.\u001b\u0005%1UO\\2uS>t'\u0007\u0005\u0002\u001a9&\u0011QL\u0007\u0002\u0004\u0003:L\u0018!B7fe\u001e,Gc\u00011eMB\u0011\u0011MY\u0007\u0002\u001d%\u00111M\u0004\u0002\u0004%><\b\"B3\n\u0001\u0004\u0001\u0017\u0001\u00027fMRDQaZ\u0005A\u0002\u0001\fQA]5hQR\faa\\;uaV$X#\u00011")
public class UpsertMergeJsonToRow {
    private final FullOuterJoinRow row;
    private final StructType schema;
    private final int targetValueIndex;
    private final TimeZone timeZone;

    public TimeZone timeZone() {
        return this.timeZone;
    }

    private void parseJson(String jsonStr, Function2<String, Object, BoxedUnit> callback) {
        JsonAST.JValue obj = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(jsonStr), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        ((JsonAST.JObject)obj).obj().foreach((Function1 & Serializable & scala.Serializable)f -> {
            UpsertMergeJsonToRow.$anonfun$parseJson$1(this, callback, f);
            return BoxedUnit.UNIT;
        });
    }

    private Row merge(Row left, Row right) {
        Object[] tempRow = (Object[])left.toSeq().toArray(ClassTag$.MODULE$.Any());
        this.parseJson((String)right.getAs(this.targetValueIndex), (Function2<String, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(k, v) -> {
            UpsertMergeJsonToRow.$anonfun$merge$1(this, left, tempRow, k, v);
            return BoxedUnit.UNIT;
        });
        return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)tempRow));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Row output() {
        FullOuterJoinRow fullOuterJoinRow = this.row;
        if (fullOuterJoinRow != null) {
            Row left = fullOuterJoinRow.left();
            Row right = fullOuterJoinRow.right();
            boolean bl = fullOuterJoinRow.leftPresent();
            boolean bl2 = fullOuterJoinRow.rightPresent();
            if (bl && bl2) {
                return this.merge(left, right);
            }
        }
        if (fullOuterJoinRow != null) {
            Row left = fullOuterJoinRow.left();
            boolean bl = fullOuterJoinRow.leftPresent();
            boolean bl3 = fullOuterJoinRow.rightPresent();
            if (bl && !bl3) {
                return left;
            }
        }
        if (fullOuterJoinRow == null) throw new MatchError((Object)fullOuterJoinRow);
        Row left = fullOuterJoinRow.left();
        Row right = fullOuterJoinRow.right();
        boolean bl = fullOuterJoinRow.leftPresent();
        boolean bl4 = fullOuterJoinRow.rightPresent();
        if (false != bl) throw new MatchError((Object)fullOuterJoinRow);
        if (true != bl4) throw new MatchError((Object)fullOuterJoinRow);
        return this.merge(left, right);
    }

    public static final /* synthetic */ boolean $anonfun$parseJson$2(Tuple2 f$1, StructField field) {
        String string = field.name();
        Object object = f$1._1();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ void $anonfun$parseJson$1(UpsertMergeJsonToRow $this, Function2 callback$1, Tuple2 f) {
        Object object;
        DataType dataType = ((StructField)((IterableLike)$this.schema.filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)UpsertMergeJsonToRow.$anonfun$parseJson$2(f, field)))).head()).dataType();
        JsonAST.JValue jValue = (JsonAST.JValue)f._2();
        if (jValue instanceof JsonAST.JBool) {
            JsonAST.JBool jBool = (JsonAST.JBool)jValue;
            boolean v = jBool.value();
            object = BoxesRunTime.boxToBoolean((boolean)v);
        } else {
            JsonAST.JNull$ jNull$ = package$.MODULE$.JNull();
            JsonAST.JValue jValue2 = jValue;
            if (!(jNull$ != null ? !jNull$.equals(jValue2) : jValue2 != null)) {
                object = null;
            } else if (jValue instanceof JsonAST.JDouble) {
                JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                double v = jDouble.num();
                object = BoxesRunTime.boxToDouble((double)v);
            } else if (jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt v = jInt.num();
                DataType dataType2 = dataType;
                if (!IntegerType$.MODULE$.equals(dataType2)) {
                    throw new MatchError((Object)dataType2);
                }
                BigInt bigInt = v;
                object = bigInt;
            } else if (jValue instanceof JsonAST.JLong) {
                Comparable<Date> comparable;
                JsonAST.JLong jLong = (JsonAST.JLong)jValue;
                long v = jLong.num();
                DataType dataType3 = dataType;
                if (TimestampType$.MODULE$.equals(dataType3)) {
                    comparable = new Date(v);
                } else if (DateType$.MODULE$.equals(dataType3)) {
                    comparable = new Date(v);
                } else if (LongType$.MODULE$.equals(dataType3)) {
                    comparable = BoxesRunTime.boxToLong((long)v);
                } else {
                    throw new MatchError((Object)dataType3);
                }
                object = comparable;
            } else if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String v = jString.s();
                object = v;
            } else {
                throw new MatchError((Object)jValue);
            }
        }
        Boolean value = object;
        callback$1.apply(f._1(), (Object)value);
    }

    public static final /* synthetic */ void $anonfun$merge$2(UpsertMergeJsonToRow $this, Object[] tempRow$1, String k$1, Object v$1, Tuple2 wow) {
        int index = wow._2$mcI$sp();
        Object value = wow._1();
        tempRow$1[index] = $this.schema.fieldIndex(k$1) == index ? v$1 : value;
    }

    public static final /* synthetic */ void $anonfun$merge$1(UpsertMergeJsonToRow $this, Row left$1, Object[] tempRow$1, String k, Object v) {
        ((TraversableLike)left$1.toSeq().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)wow -> {
            UpsertMergeJsonToRow.$anonfun$merge$2($this, tempRow$1, k, v, wow);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public UpsertMergeJsonToRow(FullOuterJoinRow row, StructType schema, int targetValueIndex, String defaultTimeZone) {
        this.row = row;
        this.schema = schema;
        this.targetValueIndex = targetValueIndex;
        this.timeZone = DateTimeUtils$.MODULE$.getTimeZone(defaultTimeZone);
    }
}

