/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.delta.DeltaConcurrentModificationException;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.commands.CompactTableInDelta$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaCommandsFun;
import org.apache.spark.sql.delta.commands.PrefixAddFile;
import org.apache.spark.sql.delta.files.DelayedCommitProtocol;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.DeltaInvariantCheckerExec;
import org.apache.spark.sql.delta.schema.ImplicitMetadataOperation;
import org.apache.spark.sql.delta.schema.Invariants$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import tech.mlsql.common.PathFun$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u0017/\u0001nB\u0001\u0002\u001a\u0001\u0003\u0016\u0004%\t!\u001a\u0005\tU\u0002\u0011\t\u0012)A\u0005M\"A1\u000e\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005q\u0001\tE\t\u0015!\u0003n\u0011!\t\bA!f\u0001\n\u0003\u0011\b\"CA\b\u0001\tE\t\u0015!\u0003t\u0011)\t\t\u0002\u0001BK\u0002\u0013\u0005\u00111\u0003\u0005\u000b\u00037\u0001!\u0011#Q\u0001\n\u0005U\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\t\u0019\u0005\u0001C\t\u0003\u000bBq!!\u001b\u0001\t#\tY\u0007C\u0004\u0002x\u0001!I!!\u001f\t\u000f\u0005M\u0005\u0001\"\u0005\u0002\u0016\"9\u00111\u0014\u0001\u0005\u0012\u0005u\u0005bBAQ\u0001\u0011E\u00111\u0015\u0005\n\u0003c\u0003!\u0019!C)\u0003gC\u0001\"!.\u0001A\u0003%\u0011\u0011\r\u0005\n\u0003o\u0003!\u0019!C)\u0003gC\u0001\"!/\u0001A\u0003%\u0011\u0011\r\u0005\n\u0003w\u0003\u0011\u0011!C\u0001\u0003{C\u0011\"a2\u0001#\u0003%\t!!3\t\u0013\u0005}\u0007!%A\u0005\u0002\u0005\u0005\b\"CAs\u0001E\u0005I\u0011AAt\u0011%\tY\u000fAI\u0001\n\u0003\ti\u000fC\u0005\u0002r\u0002\t\t\u0011\"\u0011\u0002t\"I!1\u0001\u0001\u0002\u0002\u0013\u0005!Q\u0001\u0005\n\u0005\u001b\u0001\u0011\u0011!C\u0001\u0005\u001fA\u0011Ba\u0007\u0001\u0003\u0003%\tE!\b\t\u0013\t%\u0002!!A\u0005\u0002\t-\u0002\"\u0003B\u0018\u0001\u0005\u0005I\u0011\tB\u0019\u000f\u001d\u0011)D\fE\u0001\u0005o1a!\f\u0018\t\u0002\te\u0002bBA\u000fC\u0011\u0005!\u0011\t\u0005\n\u0005\u0007\n#\u0019!C\u0001\u0003gD\u0001B!\u0012\"A\u0003%\u0011Q\u001f\u0005\n\u0005\u000f\n#\u0019!C\u0001\u0003gD\u0001B!\u0013\"A\u0003%\u0011Q\u001f\u0005\n\u0005\u0017\n#\u0019!C\u0001\u0003gD\u0001B!\u0014\"A\u0003%\u0011Q\u001f\u0005\b\u0005\u001f\nC\u0011\u0001B)\u0011%\u00119&IA\u0001\n\u0003\u0013I\u0006C\u0005\u0003d\u0005\n\t\u0011\"!\u0003f!I!qO\u0011\u0002\u0002\u0013%!\u0011\u0010\u0002\u0014\u0007>l\u0007/Y2u)\u0006\u0014G.Z%o\t\u0016dG/\u0019\u0006\u0003_A\n\u0001bY8n[\u0006tGm\u001d\u0006\u0003cI\nQ\u0001Z3mi\u0006T!a\r\u001b\u0002\u0007M\fHN\u0003\u00026m\u0005)1\u000f]1sW*\u0011q\u0007O\u0001\u0007CB\f7\r[3\u000b\u0003e\n1a\u001c:h\u0007\u0001\u0019\u0002\u0002\u0001\u001fG\u001dRC6,\u0019\t\u0003{\u0011k\u0011A\u0010\u0006\u0003\u007f\u0001\u000bq\u0001\\8hS\u000e\fGN\u0003\u0002B\u0005\u0006)\u0001\u000f\\1og*\u00111IM\u0001\tG\u0006$\u0018\r\\=ti&\u0011QI\u0010\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u000691m\\7nC:$'BA&3\u0003%)\u00070Z2vi&|g.\u0003\u0002N\u0011\ny!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002P%6\t\u0001K\u0003\u0002Ra\u000511o\u00195f[\u0006L!a\u0015)\u00033%k\u0007\u000f\\5dSRlU\r^1eCR\fw\n]3sCRLwN\u001c\t\u0003+Zk\u0011AL\u0005\u0003/:\u0012A\u0002R3mi\u0006\u001cu.\\7b]\u0012\u0004\"!V-\n\u0005is#\u0001\u0005#fYR\f7i\\7nC:$7OR;o!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u00182\n\u0005\rl&\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00033fYR\fGj\\4\u0016\u0003\u0019\u0004\"a\u001a5\u000e\u0003AJ!!\u001b\u0019\u0003\u0011\u0011+G\u000e^1M_\u001e\f\u0011\u0002Z3mi\u0006dun\u001a\u0011\u0002\u000f=\u0004H/[8ogV\tQ\u000e\u0005\u0002h]&\u0011q\u000e\r\u0002\r\t\u0016dG/Y(qi&|gn]\u0001\t_B$\u0018n\u001c8tA\u0005\u0001\u0002/\u0019:uSRLwN\\\"pYVlgn]\u000b\u0002gB\u0019A\u000f`@\u000f\u0005UThB\u0001<z\u001b\u00059(B\u0001=;\u0003\u0019a$o\\8u}%\ta,\u0003\u0002|;\u00069\u0001/Y2lC\u001e,\u0017BA?\u007f\u0005\r\u0019V-\u001d\u0006\u0003wv\u0003B!!\u0001\u0002\n9!\u00111AA\u0003!\t1X,C\u0002\u0002\bu\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004;\u0006\t\u0002/\u0019:uSRLwN\\\"pYVlgn\u001d\u0011\u0002\u001b\r|gNZ5hkJ\fG/[8o+\t\t)\u0002\u0005\u0004\u0002\u0002\u0005]qp`\u0005\u0005\u00033\tiAA\u0002NCB\fabY8oM&<WO]1uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003C\t\u0019#!\n\u0002(\u0005%\u0002CA+\u0001\u0011\u0015!\u0017\u00021\u0001g\u0011\u0015Y\u0017\u00021\u0001n\u0011\u0015\t\u0018\u00021\u0001t\u0011\u001d\t\t\"\u0003a\u0001\u0003+\t1A];o)\u0011\ty#!\u000f\u0011\tQd\u0018\u0011\u0007\t\u0005\u0003g\t)$D\u00013\u0013\r\t9D\r\u0002\u0004%><\bbBA\u001e\u0015\u0001\u0007\u0011QH\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003g\ty$C\u0002\u0002BI\u0012Ab\u00159be.\u001cVm]:j_:\fAa\u0018:v]R!\u0011qIA4!%a\u0016\u0011JA'\u00037\n\t'C\u0002\u0002Lu\u0013a\u0001V;qY\u0016\u001c\u0004\u0003\u0002;}\u0003\u001f\u0002B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+\u0002\u0014aB1di&|gn]\u0005\u0005\u00033\n\u0019F\u0001\u0004BGRLwN\u001c\t\u00049\u0006u\u0013bAA0;\n!Aj\u001c8h!\ra\u00161M\u0005\u0004\u0003Kj&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003wY\u0001\u0019AA\u001f\u00031!w\u000eT8h\u00072,\u0017M\\;q)\u0011\ti'a\u001d\u0011\u0007q\u000by'C\u0002\u0002ru\u0013A!\u00168ji\"9\u0011Q\u000f\u0007A\u0002\u0005m\u0013!\u0004;be\u001e,GOV3sg&|g.\u0001\u000bmSN$X\t\u001f9je\u0016$G)\u001a7uC2{wm\u001d\u000b\u0005\u0003w\n\t\nE\u0003u\u0003{\n\t)C\u0002\u0002\u0000y\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003\t17OC\u0002\u0002\fZ\na\u0001[1e_>\u0004\u0018\u0002BAH\u0003\u000b\u0013!BR5mKN#\u0018\r^;t\u0011\u001d\t)(\u0004a\u0001\u00037\n1\u0003Z8SK6|g/\u001a$jY\u0016\u001cE.Z1okB$B!!\u001c\u0002\u0018\"9\u0011\u0011\u0014\bA\u0002\u00055\u0013!B5uK6\u001c\u0018\u0001\u0003:pY2\u0014\u0017mY6\u0015\t\u00055\u0014q\u0014\u0005\b\u00033{\u0001\u0019AA'\u0003!y\u0007\u000f^5nSj,GCBAS\u0003W\u000bi\u000bE\u0004]\u0003O\u000bi%a\u0017\n\u0007\u0005%VL\u0001\u0004UkBdWM\r\u0005\b\u0003w\u0001\u0002\u0019AA\u001f\u0011\u001d\ty\u000b\u0005a\u0001\u0003C\nQ![:Uef\fabY1o\u001b\u0016\u0014x-Z*dQ\u0016l\u0017-\u0006\u0002\u0002b\u0005y1-\u00198NKJ<WmU2iK6\f\u0007%\u0001\ndC:|e/\u001a:xe&$XmU2iK6\f\u0017aE2b]>3XM]<sSR,7k\u00195f[\u0006\u0004\u0013\u0001B2paf$\"\"!\t\u0002@\u0006\u0005\u00171YAc\u0011\u001d!W\u0003%AA\u0002\u0019Dqa[\u000b\u0011\u0002\u0003\u0007Q\u000eC\u0004r+A\u0005\t\u0019A:\t\u0013\u0005EQ\u0003%AA\u0002\u0005U\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017T3AZAgW\t\ty\r\u0005\u0003\u0002R\u0006mWBAAj\u0015\u0011\t).a6\u0002\u0013Ut7\r[3dW\u0016$'bAAm;\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00171\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003GT3!\\Ag\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!;+\u0007M\fi-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005=(\u0006BA\u000b\u0003\u001b\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA{!\u0011\t9P!\u0001\u000e\u0005\u0005e(\u0002BA~\u0003{\fA\u0001\\1oO*\u0011\u0011q`\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005e\u0018\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0004!\ra&\u0011B\u0005\u0004\u0005\u0017i&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\t\u0005/\u00012\u0001\u0018B\n\u0013\r\u0011)\"\u0018\u0002\u0004\u0003:L\b\"\u0003B\r9\u0005\u0005\t\u0019\u0001B\u0004\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0004\t\u0007\u0005C\u00119C!\u0005\u000e\u0005\t\r\"b\u0001B\u0013;\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}$1E\u0001\tG\u0006tW)];bYR!\u0011\u0011\rB\u0017\u0011%\u0011IBHA\u0001\u0002\u0004\u0011\t\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003C\u0012\u0019\u0004C\u0005\u0003\u001a}\t\t\u00111\u0001\u0003\u0012\u0005\u00192i\\7qC\u000e$H+\u00192mK&sG)\u001a7uCB\u0011Q+I\n\u0005C\tm\u0012\rE\u0002]\u0005{I1Aa\u0010^\u0005\u0019\te.\u001f*fMR\u0011!qG\u0001\u0017\u0007>k\u0005+Q\"U?Z+%kU%P\u001d~{\u0005\u000bV%P\u001d\u000692iT'Q\u0003\u000e#vLV#S'&{ejX(Q)&{e\nI\u0001\u0019\u0007>k\u0005+Q\"U?:+Vj\u0018$J\u0019\u0016{\u0006+\u0012*`\t&\u0013\u0016!G\"P\u001bB\u000b5\tV0O+6{f)\u0013'F?B+%k\u0018#J%\u0002\nAdQ(N!\u0006\u001bEk\u0018*F)JKv\fV%N\u000bN{fi\u0014*`\u0019>\u001b5*A\u000fD\u001f6\u0003\u0016i\u0011+`%\u0016#&+W0U\u00136+5k\u0018$P%~cujQ&!\u0003E)\u0007\u0010\u001e:bGR\u0004\u0016\r\u001e5Qe\u00164\u0017\u000e\u001f\u000b\u0004\u007f\nM\u0003B\u0002B+S\u0001\u0007q0\u0001\u0003qCRD\u0017!B1qa2LHCCA\u0011\u00057\u0012iFa\u0018\u0003b!)AM\u000ba\u0001M\")1N\u000ba\u0001[\")\u0011O\u000ba\u0001g\"9\u0011\u0011\u0003\u0016A\u0002\u0005U\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0005O\u0012\u0019\bE\u0003]\u0005S\u0012i'C\u0002\u0003lu\u0013aa\u00149uS>t\u0007\u0003\u0003/\u0003p\u0019l7/!\u0006\n\u0007\tETL\u0001\u0004UkBdW\r\u000e\u0005\n\u0005kZ\u0013\u0011!a\u0001\u0003C\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tm\u0004\u0003BA|\u0005{JAAa \u0002z\n1qJ\u00196fGR\u0004")
public class CompactTableInDelta
extends LogicalPlan
implements RunnableCommand,
ImplicitMetadataOperation,
DeltaCommand,
DeltaCommandsFun,
scala.Serializable {
    private final DeltaLog deltaLog;
    private final DeltaOptions options;
    private final Seq<String> partitionColumns;
    private final Map<String, String> configuration;
    private final boolean canMergeSchema;
    private final boolean canOverwriteSchema;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<DeltaLog, DeltaOptions, Seq<String>, Map<String, String>>> unapply(CompactTableInDelta compactTableInDelta) {
        return CompactTableInDelta$.MODULE$.unapply(compactTableInDelta);
    }

    public static String extractPathPrefix(String string) {
        return CompactTableInDelta$.MODULE$.extractPathPrefix(string);
    }

    public static String COMPACT_RETRY_TIMES_FOR_LOCK() {
        return CompactTableInDelta$.MODULE$.COMPACT_RETRY_TIMES_FOR_LOCK();
    }

    public static String COMPACT_NUM_FILE_PER_DIR() {
        return CompactTableInDelta$.MODULE$.COMPACT_NUM_FILE_PER_DIR();
    }

    public static String COMPACT_VERSION_OPTION() {
        return CompactTableInDelta$.MODULE$.COMPACT_VERSION_OPTION();
    }

    @Override
    public Tuple2<QueryExecution, Seq<Attribute>> normalizeData(Metadata metadata, Dataset<?> data, Seq<String> partitionCols) {
        return DeltaCommandsFun.normalizeData$(this, metadata, data, partitionCols);
    }

    @Override
    public DelayedCommitProtocol getCommitter(Path outputPath) {
        return DeltaCommandsFun.getCommitter$(this, outputPath);
    }

    @Override
    public Dataset<?> convertStreamDataFrame(Dataset<?> _data) {
        return DeltaCommandsFun.convertStreamDataFrame$(this, _data);
    }

    public Seq<Expression> parsePartitionPredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePartitionPredicates$((DeltaCommand)this, (SparkSession)spark, (String)predicate);
    }

    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$((DeltaCommand)this, (SparkSession)spark, partitionColumns, predicates);
    }

    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$((DeltaCommand)this, (Path)basePath, candidateFiles);
    }

    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$((DeltaCommand)this, (DeltaLog)deltaLog, nameToAddFileMap, filesToRewrite, (long)operationTimestamp);
    }

    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$((DeltaCommand)this, (SparkSession)spark, (OptimisticTransaction)txn, (String)actionType, (Path)rootPath, inputLeafFiles, nameToAddFileMap);
    }

    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$((DeltaCommand)this, (Path)basePath, (String)filePath, nameToAddFileMap);
    }

    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$((DeltaCommand)this, (Analyzer)analyzer, (TableIdentifier)identifier);
    }

    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$((DeltaCommand)this, (Analyzer)analyzer, (TableIdentifier)tableIdent);
    }

    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$((DeltaCommand)this, (TableIdentifier)tableIdent);
    }

    public final void updateMetadata(OptimisticTransaction txn, Dataset<?> data, Seq<String> partitionColumns, Map<String, String> configuration, boolean isOverwriteMode, boolean rearrangeOnly) {
        ImplicitMetadataOperation.updateMetadata$((ImplicitMetadataOperation)this, (OptimisticTransaction)txn, data, partitionColumns, configuration, (boolean)isOverwriteMode, (boolean)rearrangeOnly);
    }

    public final boolean updateMetadata$default$6() {
        return ImplicitMetadataOperation.updateMetadata$default$6$((ImplicitMetadataOperation)this);
    }

    public final void updateMetadata(SparkSession spark, OptimisticTransaction txn, StructType schema, Seq<String> partitionColumns, Map<String, String> configuration, boolean isOverwriteMode, boolean rearrangeOnly) {
        ImplicitMetadataOperation.updateMetadata$((ImplicitMetadataOperation)this, (SparkSession)spark, (OptimisticTransaction)txn, (StructType)schema, partitionColumns, configuration, (boolean)isOverwriteMode, (boolean)rearrangeOnly);
    }

    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, (Object)data);
    }

    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$((DeltaLogging)this);
    }

    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$((DeltaLogging)this);
    }

    public void logConsole(String line) {
        DatabricksLogging.logConsole$((DatabricksLogging)this, (String)line);
    }

    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$((DatabricksLogging)this);
    }

    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$((DatabricksLogging)this);
    }

    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$((DatabricksLogging)this);
    }

    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$((DatabricksLogging)this);
    }

    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$((DatabricksLogging)this, (OpType)opType, (String)opTarget, extraTags, (boolean)isSynchronous, (boolean)alwaysRecordStats, (boolean)allowAuthTags, (boolean)killJvmIfStuck, (MetricDefinition)outputMetric, (boolean)silent, thunk);
    }

    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$((DatabricksLogging)this);
    }

    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$((DatabricksLogging)this);
    }

    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$((DeltaProgressReporter)this, (String)statusCode, (String)defaultMessage, data, body);
    }

    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$((DeltaProgressReporter)this);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CompactTableInDelta compactTableInDelta = this;
        synchronized (compactTableInDelta) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public DeltaOptions options() {
        return this.options;
    }

    public Seq<String> partitionColumns() {
        return this.partitionColumns;
    }

    public Map<String, String> configuration() {
        return this.configuration;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        Object object;
        Tuple3<Seq<Action>, Object, Object> tuple3 = this._run(sparkSession);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Seq items = (Seq)tuple3._1();
        long targetVersion = BoxesRunTime.unboxToLong((Object)tuple3._2());
        boolean commitSuccess = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)items, (Object)BoxesRunTime.boxToLong((long)targetVersion), (Object)BoxesRunTime.boxToBoolean((boolean)commitSuccess));
        Tuple3 tuple33 = tuple32;
        Seq items2 = (Seq)tuple33._1();
        long targetVersion2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        boolean commitSuccess2 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
        if (commitSuccess2) {
            this.recordDeltaOperation(this.deltaLog(), "delta.log.compact.cleanup", this.recordDeltaOperation$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.doLogCleanup(targetVersion2));
            object = this.recordDeltaOperation(this.deltaLog(), "delta.data.compact.cleanup", this.recordDeltaOperation$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.doRemoveFileCleanup((Seq<Action>)items2));
        } else {
            this.rollback((Seq<Action>)items2);
            object = BoxedUnit.UNIT;
        }
        return !commitSuccess2 ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)items2.map((Function1 & Serializable & scala.Serializable)f -> Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{f.json()}))), Seq$.MODULE$.canBuildFrom());
    }

    public Tuple3<Seq<Action>, Object, Object> _run(SparkSession sparkSession) {
        IntRef compactRetryTimesForLock = IntRef.create((int)BoxesRunTime.unboxToInt((Object)this.configuration().get((Object)CompactTableInDelta$.MODULE$.COMPACT_RETRY_TIMES_FOR_LOCK()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)CompactTableInDelta.$anonfun$_run$1(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)));
        BooleanRef success = BooleanRef.create((boolean)false);
        Tuple2<Seq<Action>, Object> tuple2 = this.optimize(sparkSession, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq actions = (Seq)tuple2._1();
        long version = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)actions, (Object)BoxesRunTime.boxToLong((long)version));
        Tuple2 tuple23 = tuple22;
        Seq actions2 = (Seq)tuple23._1();
        long version2 = tuple23._2$mcJ$sp();
        while (!success.elem && compactRetryTimesForLock.elem > 0) {
            Object object;
            try {
                object = this.deltaLog().withNewTransaction((Function1 & Serializable & scala.Serializable)txn -> {
                    CompactTableInDelta.$anonfun$_run$3(actions2, success, txn);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof ConcurrentModificationException ? true : throwable2 instanceof DeltaConcurrentModificationException;
                if (bl) {
                    this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("DeltaConcurrentModificationException throwed. ").append("tried ").append(compactRetryTimesForLock$1.elem).toString());
                    Thread.sleep(1000L);
                    --compactRetryTimesForLock.elem;
                } else {
                    if (throwable2 instanceof Exception) {
                        Exception exception = (Exception)throwable2;
                        throw exception;
                    }
                    throw throwable;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                object = BoxedUnit.UNIT;
            }
        }
        return new Tuple3((Object)actions2, (Object)BoxesRunTime.boxToLong((long)version2), (Object)BoxesRunTime.boxToBoolean((boolean)success.elem));
    }

    public void doLogCleanup(long targetVersion) {
        FileSystem fs = this.deltaLog().fs();
        IntRef numDeleted = IntRef.create((int)0);
        this.listExpiredDeltaLogs(targetVersion).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath()).foreach((Function1 & Serializable & scala.Serializable)path -> {
            CompactTableInDelta.$anonfun$doLogCleanup$2(fs, numDeleted, path);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Deleted ").append(numDeleted$1.elem).append(" log files earlier than ").append(targetVersion).toString());
    }

    private Iterator<FileStatus> listExpiredDeltaLogs(long targetVersion) {
        Option latestCheckpoint = this.deltaLog().lastCheckpoint();
        if (latestCheckpoint.isEmpty()) {
            return scala.package$.MODULE$.Iterator().empty();
        }
        Iterator files = this.deltaLog().store().listFrom(FileNames$.MODULE$.deltaFile(this.deltaLog().logPath(), 0L)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CompactTableInDelta.$anonfun$listExpiredDeltaLogs$1(f))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CompactTableInDelta.$anonfun$listExpiredDeltaLogs$2(targetVersion, f)));
        return files;
    }

    public void doRemoveFileCleanup(Seq<Action> items) {
        IntRef numDeleted = IntRef.create((int)0);
        ((IterableLike)((TraversableLike)items.filter((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)CompactTableInDelta.$anonfun$doRemoveFileCleanup$1(item)))).map((Function1 & Serializable & scala.Serializable)item -> (RemoveFile)item, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
            CompactTableInDelta.$anonfun$doRemoveFileCleanup$3(this, numDeleted, item);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Deleted ").append(numDeleted$2.elem).append("  files in optimization progress").toString());
    }

    public void rollback(Seq<Action> items) {
        IntRef numDeleted = IntRef.create((int)0);
        ((IterableLike)((TraversableLike)items.filter((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)CompactTableInDelta.$anonfun$rollback$1(item)))).map((Function1 & Serializable & scala.Serializable)item -> (AddFile)item, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
            CompactTableInDelta.$anonfun$rollback$3(this, numDeleted, item);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Deleted ").append(numDeleted$3.elem).append("  files in optimization progress").toString());
    }

    public Tuple2<Seq<Action>, Object> optimize(SparkSession sparkSession, boolean isTry) {
        Dataset dataset;
        None$ none$;
        Option replaceWhere;
        Metadata metadata = this.deltaLog().snapshot().metadata();
        long readVersion = this.deltaLog().snapshot().version();
        if (readVersion > -1L) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(51).append("\n           |").append(this.deltaLog().dataPath()).append(" is appendOnly?\n           |").append(DeltaConfigs$.MODULE$.IS_APPEND_ONLY().fromMetaData(metadata)).append("\n         ").toString())).stripMargin());
        }
        if ((replaceWhere = this.options().replaceWhere()).isDefined()) {
            Seq<Expression> predicates = this.parsePartitionPredicates(sparkSession, (String)replaceWhere.get());
            none$ = new Some(predicates);
        } else {
            none$ = None$.MODULE$;
        }
        None$ partitionFilters = none$;
        Object object = readVersion < 0L ? DeltaErrors$.MODULE$.notADeltaTableException("compact", new DeltaTableIdentifier(Option$.MODULE$.apply((Object)this.deltaLog().dataPath().toString()), (Option)None$.MODULE$)) : BoxedUnit.UNIT;
        Option latestCheckpoint = this.deltaLog().lastCheckpoint();
        if (latestCheckpoint.isEmpty()) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(145).append("\n         |Compact delta log in ").append(this.deltaLog().dataPath().toString()).append(" should at least:\n         |- have a checkpoint file after it\n         |- be earlier than `targetVersion`\n       ").toString())).stripMargin());
        }
        long version = BoxesRunTime.unboxToLong((Object)this.configuration().get((Object)CompactTableInDelta$.MODULE$.COMPACT_VERSION_OPTION()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)CompactTableInDelta.$anonfun$optimize$2(x$5))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        if (version == -1L) {
            version = readVersion;
        }
        this.deltaLog().history().checkVersionExists(version);
        ArrayBuffer newFiles = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer deletedFiles = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Snapshot snapshot = this.deltaLog().getSnapshotAt(version, (Option)None$.MODULE$, this.deltaLog().getSnapshotAt$default$3());
        None$ none$2 = partitionFilters;
        if (None$.MODULE$.equals(none$2)) {
            dataset = snapshot.allFiles();
        } else if (none$2 instanceof Some) {
            Some some = (Some)none$2;
            Seq predicates = (Seq)some.value();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CompactTableInDelta.class.getClassLoader());
            public final class Org_apache_spark_sql_delta_commands_CompactTableInDelta$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.delta.actions.AddFile").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_delta_commands_CompactTableInDelta$$typecreator4$1(CompactTableInDelta $outer) {
                }
            }
            dataset = DeltaLog$.MODULE$.filterFileList(metadata.partitionSchema(), snapshot.allFiles().toDF(), predicates, DeltaLog$.MODULE$.filterFileList$default$4()).as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_commands_CompactTableInDelta$$typecreator4$1(null))));
        } else {
            throw new MatchError((Object)none$2);
        }
        Dataset filterFiles = dataset;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CompactTableInDelta.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(CompactTableInDelta.class.getClassLoader());
        public final class Org_apache_spark_sql_delta_commands_CompactTableInDelta$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.commands.PrefixAddFile").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_commands_CompactTableInDelta$$typecreator5$1(CompactTableInDelta $outer) {
            }
        }
        public final class Org_apache_spark_sql_delta_commands_CompactTableInDelta$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.commands.PrefixAddFileList").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_commands_CompactTableInDelta$$typecreator9$1(CompactTableInDelta $outer) {
            }
        }
        Seq filesShouldBeOptimized = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filterFiles.map((Function1 & Serializable & scala.Serializable)addFile -> new PrefixAddFile(CompactTableInDelta$.MODULE$.extractPathPrefix(addFile.path()), (AddFile)addFile), sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_commands_CompactTableInDelta$$typecreator5$1(null)))).groupBy("prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.collect_list("addFile").as("addFiles"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).as(sparkSession.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_delta_commands_CompactTableInDelta$$typecreator9$1(null)))).collect())).toSeq();
        int compactNumFilePerDir = BoxesRunTime.unboxToInt((Object)this.configuration().get((Object)CompactTableInDelta$.MODULE$.COMPACT_NUM_FILE_PER_DIR()).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)CompactTableInDelta.$anonfun$optimize$5(f))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        filesShouldBeOptimized.foreach((Function1 & Serializable & scala.Serializable)fileList -> {
            BoxedUnit boxedUnit;
            List tempFiles = (List)fileList.addFiles().map((Function1 & Serializable & scala.Serializable)addFile -> new Path(this.deltaLog().dataPath(), addFile.path()).toString(), List$.MODULE$.canBuildFrom());
            if (tempFiles.length() >= compactNumFilePerDir) {
                String prefix = CompactTableInDelta$.MODULE$.extractPathPrefix(((AddFile)fileList.addFiles().head()).path());
                Map partitionValues = ((AddFile)fileList.addFiles().head()).partitionValues();
                Dataset df = sparkSession.read().parquet((Seq)tempFiles).repartition(compactNumFilePerDir);
                Path filePath = prefix.isEmpty() ? this.deltaLog().dataPath() : new Path(this.deltaLog().dataPath(), prefix);
                newFiles.$plus$plus$eq((TraversableOnce)this.writeFiles$1(filePath, df, (Option)new Some((Object)this.options()), false, metadata, snapshot).map((Function1 & Serializable & scala.Serializable)addFile -> addFile.copy(new StringOps(Predef$.MODULE$.augmentString(PathFun$.MODULE$.apply(prefix).add(addFile.path()).toPath())).stripPrefix("/"), partitionValues, addFile.copy$default$3(), addFile.copy$default$4(), addFile.copy$default$5(), addFile.copy$default$6(), addFile.copy$default$7()), Seq$.MODULE$.canBuildFrom()));
                boxedUnit = deletedFiles.$plus$plus$eq((TraversableOnce)fileList.addFiles().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.remove(), List$.MODULE$.canBuildFrom()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Add ").append(newFiles.size()).append(" files in optimization progress").toString());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Mark remove ").append(deletedFiles).append(" files in optimization progress").toString());
        return new Tuple2(newFiles.$plus$plus((GenTraversableOnce)deletedFiles, ArrayBuffer$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToLong((long)version));
    }

    public boolean canMergeSchema() {
        return this.canMergeSchema;
    }

    public boolean canOverwriteSchema() {
        return this.canOverwriteSchema;
    }

    public CompactTableInDelta copy(DeltaLog deltaLog, DeltaOptions options, Seq<String> partitionColumns, Map<String, String> configuration) {
        return new CompactTableInDelta(deltaLog, options, partitionColumns, configuration);
    }

    public DeltaLog copy$default$1() {
        return this.deltaLog();
    }

    public DeltaOptions copy$default$2() {
        return this.options();
    }

    public Seq<String> copy$default$3() {
        return this.partitionColumns();
    }

    public Map<String, String> copy$default$4() {
        return this.configuration();
    }

    public String productPrefix() {
        return "CompactTableInDelta";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Seq<String> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.deltaLog();
                break;
            }
            case 1: {
                seq = this.options();
                break;
            }
            case 2: {
                seq = this.partitionColumns();
                break;
            }
            case 3: {
                seq = this.configuration();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return seq;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CompactTableInDelta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CompactTableInDelta)) return false;
        boolean bl = true;
        if (!bl) return false;
        CompactTableInDelta compactTableInDelta = (CompactTableInDelta)x$1;
        DeltaLog deltaLog = this.deltaLog();
        DeltaLog deltaLog2 = compactTableInDelta.deltaLog();
        if (deltaLog == null) {
            if (deltaLog2 != null) {
                return false;
            }
        } else if (!deltaLog.equals(deltaLog2)) return false;
        DeltaOptions deltaOptions = this.options();
        DeltaOptions deltaOptions2 = compactTableInDelta.options();
        if (deltaOptions == null) {
            if (deltaOptions2 != null) {
                return false;
            }
        } else if (!deltaOptions.equals(deltaOptions2)) return false;
        Seq<String> seq = this.partitionColumns();
        Seq<String> seq2 = compactTableInDelta.partitionColumns();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Map<String, String> map = this.configuration();
        Map<String, String> map2 = compactTableInDelta.configuration();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!compactTableInDelta.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ int $anonfun$_run$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ void $anonfun$_run$3(Seq actions$1, BooleanRef success$1, OptimisticTransaction txn) {
        txn.readWholeTable();
        DeltaOperations.Optimize operation = new DeltaOperations.Optimize((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), 0, false);
        txn.commit(actions$1, (DeltaOperations.Operation)operation);
        success$1.elem = true;
    }

    public static final /* synthetic */ void $anonfun$doLogCleanup$2(FileSystem fs$1, IntRef numDeleted$1, Path path) {
        block0: {
            if (!fs$1.delete(path, false)) break block0;
            ++numDeleted$1.elem;
        }
    }

    private static final long getVersion$1(Path filePath) {
        return FileNames$.MODULE$.isCheckpointFile(filePath) ? FileNames$.MODULE$.checkpointVersion(filePath) : FileNames$.MODULE$.deltaVersion(filePath);
    }

    public static final /* synthetic */ boolean $anonfun$listExpiredDeltaLogs$1(FileStatus f) {
        return FileNames$.MODULE$.isCheckpointFile(f.getPath()) || FileNames$.MODULE$.isDeltaFile(f.getPath());
    }

    public static final /* synthetic */ boolean $anonfun$listExpiredDeltaLogs$2(long targetVersion$3, FileStatus f) {
        return CompactTableInDelta.getVersion$1(f.getPath()) < targetVersion$3;
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveFileCleanup$1(Action item) {
        return item instanceof RemoveFile;
    }

    public static final /* synthetic */ void $anonfun$doRemoveFileCleanup$3(CompactTableInDelta $this, IntRef numDeleted$2, RemoveFile item) {
        Path path = new Path($this.deltaLog().dataPath(), item.path());
        Path pathCrc = new Path($this.deltaLog().dataPath(), new StringBuilder(5).append(".").append(item.path()).append(".crc").toString());
        FileSystem fs = $this.deltaLog().fs();
        try {
            fs.delete(path, false);
            fs.delete(pathCrc, false);
            ++numDeleted$2.elem;
        }
        catch (Exception e) {}
    }

    public static final /* synthetic */ boolean $anonfun$rollback$1(Action item) {
        return item instanceof AddFile;
    }

    public static final /* synthetic */ void $anonfun$rollback$3(CompactTableInDelta $this, IntRef numDeleted$3, AddFile item) {
        Path path = new Path($this.deltaLog().dataPath(), item.path());
        Path pathCrc = new Path($this.deltaLog().dataPath(), new StringBuilder(5).append(".").append(item.path()).append(".crc").toString());
        FileSystem fs = $this.deltaLog().fs();
        try {
            fs.delete(path, false);
            fs.delete(pathCrc, false);
            ++numDeleted$3.elem;
        }
        catch (Exception e) {}
    }

    public static final /* synthetic */ long $anonfun$optimize$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ int $anonfun$optimize$5(String f) {
        return new StringOps(Predef$.MODULE$.augmentString(f)).toInt();
    }

    private final Seq writeFiles$1(Path outputPath, Dataset data, Option writeOptions, boolean isOptimize, Metadata metadata$1, Snapshot snapshot$1) {
        SparkSession spark = data.sparkSession();
        Tuple2<QueryExecution, Seq<Attribute>> tuple2 = this.normalizeData(metadata$1, data, (Seq<String>)metadata$1.partitionColumns());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        QueryExecution queryExecution = (QueryExecution)tuple2._1();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)queryExecution, (Object)output);
        Tuple2 tuple23 = tuple22;
        QueryExecution queryExecution2 = (QueryExecution)tuple23._1();
        Seq output2 = (Seq)tuple23._2();
        DelayedCommitProtocol committer = this.getCommitter(outputPath);
        Seq invariants = Invariants$.MODULE$.getFromSchema(metadata$1.schema(), spark);
        SQLExecution$.MODULE$.withNewExecutionId(queryExecution2, SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            FileFormatWriter.OutputSpec outputSpec = new FileFormatWriter.OutputSpec(outputPath.toString(), Predef$.MODULE$.Map().empty(), output2);
            DeltaInvariantCheckerExec physicalPlan = new DeltaInvariantCheckerExec(queryExecution2.executedPlan(), invariants);
            return FileFormatWriter$.MODULE$.write(spark, (SparkPlan)physicalPlan, snapshot$1.fileFormat(), (FileCommitProtocol)committer, outputSpec, spark.sessionState().newHadoopConfWithOptions(metadata$1.configuration()), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Option)None$.MODULE$, (Seq)Nil$.MODULE$, Predef$.MODULE$.Map().empty());
        });
        return committer.addedStatuses();
    }

    public CompactTableInDelta(DeltaLog deltaLog, DeltaOptions options, Seq<String> partitionColumns, Map<String, String> configuration) {
        this.deltaLog = deltaLog;
        this.options = options;
        this.partitionColumns = partitionColumns;
        this.configuration = configuration;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        DeltaProgressReporter.$init$((DeltaProgressReporter)this);
        DatabricksLogging.$init$((DatabricksLogging)this);
        DeltaLogging.$init$((DeltaLogging)this);
        ImplicitMetadataOperation.$init$((ImplicitMetadataOperation)this);
        DeltaCommand.$init$((DeltaCommand)this);
        DeltaCommandsFun.$init$(this);
        this.canMergeSchema = false;
        this.canOverwriteSchema = false;
    }
}

