/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.arrow;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.spark.network.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;
import tech.mlsql.arrow.Utils;
import tech.mlsql.arrow.Utils$RedirectThread$;
import tech.mlsql.arrow.api.RedirectStreams;
import tech.mlsql.arrow.python.PythonWorkerFactory$Tool$;
import tech.mlsql.common.utils.log.Logging;

public final class Utils$
implements Logging {
    public static Utils$ MODULE$;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    static {
        new Utils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    public <T> T tryWithSafeFinally(Function0<T> block, Function0<BoxedUnit> finallyBlock) {
        Object object;
        Throwable originalThrowable = null;
        try {
            try {
                object = block.apply();
            }
            catch (Throwable t) {
                originalThrowable = t;
                throw originalThrowable;
            }
        }
        catch (Throwable throwable) {
            try {
                finallyBlock.apply$mcV$sp();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (throwable3 != null) {
                    Throwable throwable4 = throwable3;
                    if (originalThrowable != null) {
                        Throwable throwable5 = originalThrowable;
                        Throwable throwable6 = throwable4;
                        if (throwable5 == null ? throwable6 != null : !throwable5.equals(throwable6)) {
                            originalThrowable.addSuppressed(throwable4);
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Suppressing exception in finally: ").append(throwable4.getMessage()).toString(), throwable4);
                            throw originalThrowable;
                        }
                    }
                }
                throw throwable2;
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            finallyBlock.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable7 = throwable;
            if (throwable7 != null) {
                Throwable throwable8 = throwable7;
                if (originalThrowable != null) {
                    Throwable throwable9 = originalThrowable;
                    Throwable throwable10 = throwable8;
                    if (throwable9 == null ? throwable10 != null : !throwable9.equals(throwable10)) {
                        originalThrowable.addSuppressed(throwable8);
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Suppressing exception in finally: ").append(throwable4.getMessage()).toString(), throwable8);
                        throw originalThrowable;
                    }
                }
            }
            throw throwable;
        }
        return (T)object2;
    }

    public <R extends Closeable, T> T tryWithResource(Function0<R> createResource, Function1<R, T> f) {
        Object object;
        try (Closeable resource = (Closeable)createResource.apply();){
            object = f.apply((Object)resource);
        }
        return (T)object;
    }

    public Option<String> getStderr(Process process, long timeoutMs) {
        boolean terminated = process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
        return terminated ? new Some((Object)Source$.MODULE$.fromInputStream(process.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n")) : None$.MODULE$;
    }

    public <T> T logUncaughtExceptions(Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), throwable3);
                throw throwable3;
            }
            throw throwable;
        }
        return (T)object;
    }

    public <T> Try<T> tryLog(Function0<T> f) {
        Success success;
        try {
            Object res = f.apply();
            success = new Success(res);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 == null) {
                throw throwable;
            }
            Throwable throwable3 = throwable2;
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), throwable3);
            Failure failure = new Failure(throwable3);
            success = failure;
        }
        return success;
    }

    public boolean isFatalError(Throwable e) {
        Throwable throwable = e;
        Option option = NonFatal$.MODULE$.unapply(throwable);
        boolean bl = !option.isEmpty() ? true : (throwable instanceof InterruptedException ? true : (throwable instanceof NotImplementedError ? true : (throwable instanceof ControlThrowable ? true : throwable instanceof LinkageError)));
        boolean bl2 = !bl;
        return bl2;
    }

    public void deleteRecursively(File file) {
        block0: {
            if (file == null) break block0;
            JavaUtils.deleteRecursively((File)file);
        }
    }

    public void redirectStream(Map<String, String> conf, InputStream stdout) {
        block4: {
            try {
                Option option = conf.get((Object)PythonWorkerFactory$Tool$.MODULE$.REDIRECT_IMPL());
                if (None$.MODULE$.equals(option)) {
                    new Utils.RedirectThread(stdout, System.err, "stdout reader  ", Utils$RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String clzz = (String)some.value();
                    RedirectStreams instance = (RedirectStreams)Class.forName(clzz).newInstance();
                    instance.setConf(conf);
                    instance.stdOut(stdout);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception in redirecting streams", e);
            }
        }
    }

    public void writeUTF(String str, DataOutputStream dataOut) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        dataOut.write(bytes);
    }

    private Utils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

