/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.WowCommandWithDestination;
import org.apache.hadoop.fs.shell.WowFsCommand;
import org.apache.hadoop.io.IOUtils;

public class WowCopyCommands {
    public static void registerCommands(CommandFactory factory) {
    }

    public static class Cp
    extends WowCommandWithDestination {
        public static final String NAME = "cp";
        public static final String USAGE = "[-f] [-p | -p[topax]] <src> ... <dst>";
        public static final String DESCRIPTION = "Copy files that match the file pattern <src> to a destination.  When copying multiple files, the destination must be a directory. Passing -p preserves status [topax] (timestamps, ownership, permission, ACLs, XAttr). If -p is specified with no <arg>, then preserves timestamps, ownership, permission. If -pa is specified, then preserves permission also because ACL is a super-set of permission. Passing -f overwrites the destination if it already exists. raw namespace extended attributes are preserved if (1) they are supported (HDFS only) and, (2) all of the source and target pathnames are in the /.reserved/raw hierarchy. raw namespace xattr preservation is determined solely by the presence (or absence) of the /.reserved/raw prefix and not by the -p option.\n";

        public Cp(Configuration conf, String basePath, PrintStream out, PrintStream error) {
            super(conf, basePath, out, error);
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            this.popPreserveOption(args);
            CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, new String[]{"f"});
            cf.parse(args);
            this.setOverwrite(cf.getOpt("f"));
            this.setRecursive(true);
            this.redefineBaseDir(args);
            this.getRemoteDestination(args);
        }

        private void popPreserveOption(List<String> args) {
            String cur;
            Iterator<String> iter = args.iterator();
            while (iter.hasNext() && !(cur = iter.next()).equals("--")) {
                if (!cur.startsWith("-p")) continue;
                iter.remove();
                if (cur.length() == 2) {
                    this.setPreserve(true);
                } else {
                    String attributes = cur.substring(2);
                    for (int index = 0; index < attributes.length(); ++index) {
                        this.preserve(WowCommandWithDestination.FileAttribute.getAttribute(attributes.charAt(index)));
                    }
                }
                return;
            }
        }
    }

    public static class Merge
    extends WowFsCommand {
        public static final String NAME = "getmerge";
        public static final String USAGE = "[-nl] <src> <localdst>";
        public static final String DESCRIPTION = "Get all the files in the directories that match the source file pattern and merge and sort them to only one file on local fs. <src> is kept.\n-nl: Add a newline character at the end of each file.";
        protected PathData dst = null;
        protected String delimiter = null;
        protected List<PathData> srcs = null;

        public Merge(Configuration conf, String basePath, PrintStream out, PrintStream error) {
            super(conf, basePath, out, error);
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            try {
                CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, new String[]{"nl"});
                cf.parse(args);
                this.redefineBaseDir(args);
                this.delimiter = cf.getOpt("nl") ? "\n" : null;
                this.dst = new PathData(new URI(args.removeLast()), this.getConf());
                if (this.dst.exists && this.dst.stat.isDirectory()) {
                    throw new PathIsDirectoryException(this.cleanPath(this.dst.toString()));
                }
                this.srcs = new LinkedList<PathData>();
            }
            catch (URISyntaxException e) {
                throw new IOException("unexpected URISyntaxException", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processArguments(LinkedList<PathData> items) throws IOException {
            super.processArguments(items);
            if (this.exitCode != 0) {
                return;
            }
            try (FSDataOutputStream out = this.dst.fs.create(this.dst.path);){
                for (PathData src : this.srcs) {
                    try (FSDataInputStream in = src.fs.open(src.path);){
                        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)this.getConf(), (boolean)false);
                        if (this.delimiter == null) continue;
                        out.write(this.delimiter.getBytes("UTF-8"));
                    }
                }
            }
        }

        protected void processNonexistentPath(PathData item) throws IOException {
            this.exitCode = 1;
            super.processNonexistentPath(item);
        }

        protected void processPath(PathData src) throws IOException {
            if (src.stat.isDirectory()) {
                if (this.getDepth() == 0) {
                    this.recursePath(src);
                }
            } else {
                this.srcs.add(src);
            }
        }
    }
}

