/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.WowFsCommand;

public class WowCount
extends WowFsCommand {
    private static final String OPTION_QUOTA = "q";
    private static final String OPTION_HUMAN = "h";
    public static final String NAME = "count";
    public static final String USAGE = "[-q] [-h] <path> ...";
    public static final String DESCRIPTION = "Count the number of directories, files and bytes under the paths\nthat match the specified file pattern.  The output columns are:\nDIR_COUNT FILE_COUNT CONTENT_SIZE FILE_NAME or\nQUOTA REMAINING_QUOTA SPACE_QUOTA REMAINING_SPACE_QUOTA \n      DIR_COUNT FILE_COUNT CONTENT_SIZE FILE_NAME\nThe -h option shows file sizes in human readable format.";
    private boolean showQuotas;
    private boolean humanReadable;

    public WowCount(Configuration conf, String basePath, PrintStream out, PrintStream error) {
        super(conf, basePath, out, error);
    }

    protected void processOptions(LinkedList<String> args) {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, new String[]{OPTION_QUOTA, OPTION_HUMAN});
        cf.parse(args);
        this.redefineBaseDir(args);
        if (args.isEmpty()) {
            args.add(this.basePath);
        }
        this.showQuotas = cf.getOpt(OPTION_QUOTA);
        this.humanReadable = cf.getOpt(OPTION_HUMAN);
    }

    protected void processPath(PathData src) throws IOException {
        ContentSummary summary = src.fs.getContentSummary(src.path);
        this.out.println(summary.toString(this.showQuotas, this.isHumanReadable()) + this.cleanPath(src.toString()));
    }

    @InterfaceAudience.Private
    boolean isShowQuotas() {
        return this.showQuotas;
    }

    @InterfaceAudience.Private
    boolean isHumanReadable() {
        return this.humanReadable;
    }
}

