/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.WowFsCommand;

public class WowDelete {

    public static class Rmdir
    extends WowFsCommand {
        public static final String NAME = "rmdir";
        public static final String USAGE = "[--ignore-fail-on-non-empty] <dir> ...";
        public static final String DESCRIPTION = "Removes the directory entry specified by each directory argument, provided it is empty.\n";
        private boolean ignoreNonEmpty = false;

        public Rmdir(Configuration conf, String basePath, PrintStream out, PrintStream error) {
            super(conf, basePath, out, error);
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, new String[]{"-ignore-fail-on-non-empty"});
            cf.parse(args);
            this.ignoreNonEmpty = cf.getOpt("-ignore-fail-on-non-empty");
            this.redefineBaseDir(args);
        }

        protected void processPath(PathData item) throws IOException {
            if (!item.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(item.toString());
            }
            if (item.fs.listStatus(item.path).length == 0) {
                if (!item.fs.delete(item.path, false)) {
                    throw new PathIOException(item.toString());
                }
            } else if (!this.ignoreNonEmpty) {
                throw new PathIsNotEmptyDirectoryException(item.toString());
            }
        }
    }

    public static class Rmr
    extends Rm {
        public static final String NAME = "rmr";

        public Rmr(Configuration conf, String basePath, PrintStream out, PrintStream error) {
            super(conf, basePath, out, error);
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-r");
            super.processOptions(args);
        }

        public String getReplacementCommand() {
            return "rm -r";
        }
    }

    public static class Rm
    extends WowFsCommand {
        public static final String NAME = "rm";
        public static final String USAGE = "[-f] [-r|-R] [-skipTrash] <src> ...";
        public static final String DESCRIPTION = "Delete all files that match the specified file pattern. Equivalent to the Unix command \"rm <src>\"\n-skipTrash: option bypasses trash, if enabled, and immediately deletes <src>\n-f: If the file does not exist, do not display a diagnostic message or modify the exit status to reflect an error.\n-[rR]:  Recursively deletes directories";
        private boolean skipTrash = false;
        private boolean deleteDirs = false;
        private boolean ignoreFNF = false;

        public Rm(Configuration conf, String basePath, PrintStream out, PrintStream error) {
            super(conf, basePath, out, error);
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, new String[]{"f", "r", "R", "skipTrash"});
            cf.parse(args);
            this.ignoreFNF = cf.getOpt("f");
            this.deleteDirs = cf.getOpt("r") || cf.getOpt("R");
            this.skipTrash = cf.getOpt("skipTrash");
            this.redefineBaseDir(args);
        }

        protected List<PathData> expandArgument(String arg) throws IOException {
            try {
                return super.expandArgument(arg);
            }
            catch (PathNotFoundException e) {
                if (!this.ignoreFNF) {
                    throw e;
                }
                return new LinkedList<PathData>();
            }
        }

        protected void processNonexistentPath(PathData item) throws IOException {
            if (!this.ignoreFNF) {
                super.processNonexistentPath(item);
            }
        }

        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory() && !this.deleteDirs) {
                throw new PathIsDirectoryException(item.toString());
            }
            if (this.moveToTrash(item)) {
                return;
            }
            if (!item.fs.delete(item.path, this.deleteDirs)) {
                throw new PathIOException(item.toString());
            }
            this.out.println("Deleted " + this.cleanPath(item.toString()));
        }

        private boolean moveToTrash(PathData item) throws IOException {
            boolean success = false;
            if (!this.skipTrash) {
                try {
                    success = Trash.moveToAppropriateTrash((FileSystem)item.fs, (Path)item.path, (Configuration)this.getConf());
                }
                catch (FileNotFoundException fnfe) {
                    throw fnfe;
                }
                catch (IOException ioe) {
                    String msg = ioe.getMessage();
                    if (ioe.getCause() != null) {
                        msg = msg + ": " + ioe.getCause().getMessage();
                    }
                    throw new IOException(msg + ". Consider using -skipTrash option", ioe);
                }
            }
            return success;
        }
    }
}

