/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.WowFsCommand;
import org.apache.hadoop.util.StringUtils;

public class WowLs
extends WowFsCommand {
    public static final String NAME = "ls";
    public static final String USAGE = "[-d] [-h] [-R] [-F] [<path> ...]";
    public static final String DESCRIPTION = "List the contents that match the specified file pattern. If path is not specified, the contents of /user/<currentUser> will be listed. Directory entries are of the form:\n\tpermissions - userId groupId sizeOfDirectory(in bytes) modificationDate(yyyy-MM-dd HH:mm) directoryName\n\nand file entries are of the form:\n\tpermissions numberOfReplicas userId groupId sizeOfFile(in bytes) modificationDate(yyyy-MM-dd HH:mm) fileName\n-d:  Directories are listed as plain files.\n-h:  Formats the sizes of files in a human-readable fashion rather than a number of bytes.\n-R:  Recursively list the contents of directories.-F:  Formats the result as json";
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    protected int maxRepl = 3;
    protected int maxLen = 10;
    protected int maxOwner = 0;
    protected int maxGroup = 0;
    protected String lineFormat;
    protected boolean dirRecurse;
    protected boolean humanReadable = false;
    protected boolean format = false;

    public WowLs(Configuration conf, String basePath, PrintStream out, PrintStream error) {
        super(conf, basePath, out, error);
    }

    protected String formatSize(long size) {
        return this.humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String((long)size, (String)"", (int)1) : String.valueOf(size);
    }

    protected void processOptions(LinkedList<String> args) throws IOException {
        CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, new String[]{"d", "h", "R", "F"});
        cf.parse(args);
        this.dirRecurse = !cf.getOpt("d");
        this.setRecursive(cf.getOpt("R") && this.dirRecurse);
        this.humanReadable = cf.getOpt("h");
        this.format = cf.getOpt("F");
        this.redefineBaseDir(args);
        if (args.isEmpty()) {
            args.add(this.basePath);
        }
    }

    protected void processPathArgument(PathData item) throws IOException {
        if (this.dirRecurse && item.stat.isDirectory()) {
            this.recursePath(item);
        } else {
            super.processPathArgument(item);
        }
    }

    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        if (!this.format && parent != null && !this.isRecursive() && items.length != 0) {
            this.out.println("Found " + items.length + " items");
        }
        this.adjustColumnWidths(items);
        super.processPaths(parent, items);
    }

    protected void processPath(PathData item) throws IOException {
        FileStatus stat = item.stat;
        String itemLength = this.formatSize(stat.getLen());
        String itemModificationTime = dateFormat.format(new Date(stat.getModificationTime()));
        String itemPath = item.toString().substring(this.basePath.length() - 1);
        String itemName = item.path.getName();
        String line = String.format(this.lineFormat, stat.isDirectory() ? "d" : "-", stat.getPermission() + (stat.getPermission().getAclBit() ? "+" : " "), stat.isFile() ? Short.valueOf(stat.getReplication()) : "-", stat.getOwner(), stat.getGroup(), itemLength, itemModificationTime, itemPath, itemName);
        if (this.format) {
            HashMap<String, String> lineMap = new HashMap<String, String>();
            String[] ss = line.split("\\s+");
            lineMap.put("permission", ss[0]);
            lineMap.put("replication", ss[1]);
            lineMap.put("owner", ss[2]);
            lineMap.put("group", ss[3]);
            lineMap.put("length", itemLength);
            lineMap.put("modification_time", itemModificationTime);
            lineMap.put("path", itemPath);
            lineMap.put("name", itemName);
            line = new Gson().toJson(lineMap);
        }
        this.out.println(line);
    }

    private void adjustColumnWidths(PathData[] items) {
        for (PathData item : items) {
            FileStatus stat = item.stat;
            this.maxRepl = this.maxLength(this.maxRepl, stat.getReplication());
            this.maxLen = this.maxLength(this.maxLen, stat.getLen());
            this.maxOwner = this.maxLength(this.maxOwner, stat.getOwner());
            this.maxGroup = this.maxLength(this.maxGroup, stat.getGroup());
        }
        StringBuilder fmt = new StringBuilder();
        fmt.append("%s%s");
        fmt.append("%" + this.maxRepl + "s ");
        fmt.append(this.maxOwner > 0 ? "%-" + this.maxOwner + "s " : "%s");
        fmt.append(this.maxGroup > 0 ? "%-" + this.maxGroup + "s " : "%s");
        fmt.append("%" + this.maxLen + "s ");
        fmt.append("%s %s %s");
        this.lineFormat = fmt.toString();
    }

    private int maxLength(int n, Object value) {
        return Math.max(n, value != null ? String.valueOf(value).length() : 0);
    }

    public static class Lsr
    extends WowLs {
        public static final String NAME = "lsr";

        public Lsr(Configuration conf, String basePath, PrintStream out, PrintStream error) {
            super(conf, basePath, out, error);
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-R");
            super.processOptions(args);
        }

        public String getReplacementCommand() {
            return "ls -R";
        }
    }
}

