/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.WowCommandWithDestination;

public class WowMoveCommands {

    public static class Rename
    extends WowCommandWithDestination {
        public static final String NAME = "mv";
        public static final String USAGE = "<src> ... <dst>";
        public static final String DESCRIPTION = "Move files that match the specified file pattern <src> to a destination <dst>.  When moving multiple files, the destination must be a directory.";

        public Rename(Configuration conf, String basePath, PrintStream out, PrintStream error) {
            super(conf, basePath, out, error);
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, new String[0]);
            cf.parse(args);
            this.redefineBaseDir(args);
            this.getRemoteDestination(args);
        }

        @Override
        protected void processPath(PathData src, PathData target) throws IOException {
            if (!src.fs.getUri().equals(target.fs.getUri())) {
                throw new PathIOException(this.cleanPath(src.toString()), "Does not match target filesystem");
            }
            if (target.exists) {
                throw new PathExistsException(this.cleanPath(target.toString()));
            }
            if (!target.fs.rename(src.path, target.path)) {
                throw new PathIOException(this.cleanPath(src.toString()));
            }
        }
    }
}

