/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.csdn.common.reflect.ReflectHelper;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.SparkOperationUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import serviceframework.dispatcher.Compositor;
import serviceframework.dispatcher.StrategyDispatcher$;
import streaming.core.strategy.platform.PlatformManager$;
import streaming.core.strategy.platform.SparkRuntime;
import streaming.dsl.MLSQLExecuteContext;
import streaming.dsl.ScriptSQLExec$;
import streaming.dsl.ScriptSQLExecListener;
import tech.mlsql.common.utils.shell.command.ParamsUtil;
import tech.mlsql.dsl.processor.PreProcessListener;
import tech.mlsql.ets.ScriptRunner$;
import tech.mlsql.job.JobManager$;
import tech.mlsql.job.MLSQLJobInfo;
import tech.mlsql.job.MLSQLJobProgress;
import tech.mlsql.job.MLSQLJobProgress$;
import tech.mlsql.job.MLSQLJobType$;

public abstract class SparkOperationUtil$class {
    public static boolean waitJobStarted(SparkOperationUtil $this, String groupId, long timeoutSec) {
        long count;
        for (count = timeoutSec; BoxesRunTime.equals((Object)JobManager$.MODULE$.getJobInfo().filter((Function1)new Serializable($this, groupId){
            public static final long serialVersionUID = 0L;
            private final String groupId$1;

            public final boolean apply(Tuple2<String, MLSQLJobInfo> f) {
                Object object = f._1();
                String string = this.groupId$1;
                return !(object != null ? !object.equals(string) : string != null);
            }
            {
                this.groupId$1 = groupId$1;
            }
        }), (Object)BoxesRunTime.boxToInteger((int)0)) && count > 0L; --count) {
            Thread.sleep(1000L);
        }
        return count > 0L;
    }

    public static long waitJobStarted$default$2(SparkOperationUtil $this) {
        return 10L;
    }

    public static boolean waitJobStartedByName(SparkOperationUtil $this, String jobName, long timeoutSec) {
        long count;
        for (count = timeoutSec; BoxesRunTime.equals((Object)JobManager$.MODULE$.getJobInfo().filter((Function1)new Serializable($this, jobName){
            public static final long serialVersionUID = 0L;
            private final String jobName$1;

            public final boolean apply(Tuple2<String, MLSQLJobInfo> f) {
                String string = ((MLSQLJobInfo)f._2()).jobName();
                String string2 = this.jobName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.jobName$1 = jobName$1;
            }
        }), (Object)BoxesRunTime.boxToInteger((int)0)) && count > 0L; --count) {
            Thread.sleep(1000L);
        }
        return count > 0L;
    }

    public static long waitJobStartedByName$default$2(SparkOperationUtil $this) {
        return 10L;
    }

    public static boolean waitWithCondition(SparkOperationUtil $this, Function0 shouldWait, long timeoutSec) {
        long count;
        for (count = timeoutSec; shouldWait.apply$mcZ$sp() && count > 0L; --count) {
            Thread.sleep(1000L);
        }
        return count > 0L;
    }

    public static long waitWithCondition$default$2(SparkOperationUtil $this) {
        return 10L;
    }

    public static boolean checkJob(SparkOperationUtil $this, SparkRuntime runtime, String groupId) {
        Row[] items = $this.executeCode(runtime, new StringOps(Predef$.MODULE$.augmentString("\n        |!show jobs;\n      ")).stripMargin());
        return ((Row[])Predef$.MODULE$.refArrayOps((Object[])items).filter((Function1)new Serializable($this, groupId){
            public static final long serialVersionUID = 0L;
            private final String groupId$2;

            public final boolean apply(Row r) {
                Object object = r.getAs("groupId");
                String string = this.groupId$2;
                return !(object != null ? !object.equals(string) : string != null);
            }
            {
                this.groupId$2 = groupId$2;
            }
        })).length == 1;
    }

    public static SparkSession getSessionByOwner(SparkOperationUtil $this, SparkRuntime runtime, String owner) {
        return runtime.getSession(owner);
    }

    public static SparkSession getSession(SparkOperationUtil $this, SparkRuntime runtime) {
        return runtime.getSession("william");
    }

    public static void autoGenerateContext(SparkOperationUtil $this, SparkRuntime runtime, String home, String user, String groupId, Map userDefinedParams) {
        ScriptSQLExecListener exec = new ScriptSQLExecListener($this.getSessionByOwner(runtime, user), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{home, user})), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        MLSQLExecuteContext context = new MLSQLExecuteContext(exec, user, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{home, user})), groupId, userDefinedParams);
        context.execListener().addEnv("SKIP_AUTH", "true");
        ScriptSQLExec$.MODULE$.setContext(context);
    }

    public static String autoGenerateContext$default$2(SparkOperationUtil $this) {
        return "/tmp";
    }

    public static String autoGenerateContext$default$3(SparkOperationUtil $this) {
        return "admin";
    }

    public static String autoGenerateContext$default$4(SparkOperationUtil $this) {
        return UUID.randomUUID().toString();
    }

    public static Map autoGenerateContext$default$5(SparkOperationUtil $this) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public static MLSQLJobInfo createJobInfoFromExistGroupId(SparkOperationUtil $this, String code) {
        MLSQLExecuteContext context = ScriptSQLExec$.MODULE$.context();
        long startTime = System.currentTimeMillis();
        return new MLSQLJobInfo(context.owner(), MLSQLJobType$.MODULE$.SCRIPT(), UUID.randomUUID().toString(), code, context.groupId(), new MLSQLJobProgress(0L, 0L, MLSQLJobProgress$.MODULE$.$lessinit$greater$default$3()), startTime, -1L);
    }

    public static Row[] executeCodeWithGroupId(SparkOperationUtil $this, SparkRuntime runtime, AtomicReference groupId, String code) {
        $this.autoGenerateContext(runtime, $this.autoGenerateContext$default$2(), $this.autoGenerateContext$default$3(), $this.autoGenerateContext$default$4(), $this.autoGenerateContext$default$5());
        groupId.set(ScriptSQLExec$.MODULE$.context().groupId());
        MLSQLJobInfo jobInfo = $this.createJobInfoFromExistGroupId(code);
        AtomicReference holder = new AtomicReference();
        ScriptRunner$.MODULE$.runJob(code, jobInfo, (Function1<Dataset<Row>, BoxedUnit>)new Serializable($this, holder){
            public static final long serialVersionUID = 0L;
            private final AtomicReference holder$2;

            public final void apply(Dataset<Row> df) {
                this.holder$2.set(df.take(100));
            }
            {
                this.holder$2 = holder$2;
            }
        });
        return (Row[])holder.get();
    }

    public static Row[] executeStreamCode(SparkOperationUtil $this, SparkRuntime runtime, String code) {
        $this.autoGenerateContext(runtime, $this.autoGenerateContext$default$2(), $this.autoGenerateContext$default$3(), $this.autoGenerateContext$default$4(), $this.autoGenerateContext$default$5());
        MLSQLJobInfo jobInfo = $this.createJobInfoFromExistGroupId(code);
        AtomicReference holder = new AtomicReference();
        ScriptRunner$.MODULE$.runJob(code, jobInfo, (Function1<Dataset<Row>, BoxedUnit>)new Serializable($this, holder){
            public static final long serialVersionUID = 0L;
            private final AtomicReference holder$3;

            public final void apply(Dataset<Row> df) {
                this.holder$3.set(df.take(100));
            }
            {
                this.holder$3 = holder$3;
            }
        });
        return (Row[])holder.get();
    }

    public static Option executeCodeWithGroupIdAsync(SparkOperationUtil $this, SparkRuntime runtime, AtomicReference groupId, String code) {
        new Thread(new Runnable($this, runtime, groupId, code){
            private final /* synthetic */ SparkOperationUtil $outer;
            private final SparkRuntime runtime$1;
            private final AtomicReference groupId$3;
            private final String code$1;

            public void run() {
                this.$outer.executeCodeWithGroupId(this.runtime$1, this.groupId$3, this.code$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.runtime$1 = runtime$1;
                this.groupId$3 = groupId$3;
                this.code$1 = code$1;
            }
        }).start();
        return None$.MODULE$;
    }

    public static Row[] executeCode(SparkOperationUtil $this, SparkRuntime runtime, String code) {
        $this.autoGenerateContext(runtime, $this.autoGenerateContext$default$2(), $this.autoGenerateContext$default$3(), $this.autoGenerateContext$default$4(), $this.autoGenerateContext$default$5());
        MLSQLJobInfo jobInfo = $this.createJobInfoFromExistGroupId(code);
        AtomicReference holder = new AtomicReference();
        ScriptRunner$.MODULE$.runJob(code, jobInfo, (Function1<Dataset<Row>, BoxedUnit>)new Serializable($this, holder){
            public static final long serialVersionUID = 0L;
            private final AtomicReference holder$1;

            public final void apply(Dataset<Row> df) {
                this.holder$1.set(df.take(100));
            }
            {
                this.holder$1 = holder$1;
            }
        });
        return (Row[])holder.get();
    }

    public static Seq executeCode2(SparkOperationUtil $this, String home, String user, SparkRuntime runtime, String code) {
        $this.autoGenerateContext(runtime, home, user, $this.autoGenerateContext$default$4(), $this.autoGenerateContext$default$5());
        MLSQLJobInfo jobInfo = $this.createJobInfoFromExistGroupId(code);
        AtomicReference holder = new AtomicReference();
        ScriptRunner$.MODULE$.runJob(code, jobInfo, (Function1<Dataset<Row>, BoxedUnit>)new Serializable($this, holder){
            public static final long serialVersionUID = 0L;
            private final AtomicReference holder$4;

            public final void apply(Dataset<Row> df) {
                Row[] data = (Row[])df.take(100);
                Seq seq = Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames()).toSeq();
                Seq[] dataWithSchema = (Seq[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])data).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(Row row) {
                        return (Seq)row.toSeq().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            /*
                             * WARNING - void declaration
                             */
                            public final String apply(Object cell) {
                                void var2_5;
                                String string;
                                Object object = cell;
                                if (object == null) {
                                    string = "null";
                                } else if (object instanceof byte[]) {
                                    byte[] byArray = (byte[])object;
                                    string = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(byArray).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(byte x$1) {
                                            return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("[", " ", "]");
                                } else {
                                    string = cell.toString();
                                }
                                String str = string;
                                return var2_5;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).$plus$colon((Object)seq, ClassTag$.MODULE$.apply(Seq.class));
                this.holder$4.set(Predef$.MODULE$.wrapRefArray((Object[])dataWithSchema));
            }
            {
                this.holder$4 = holder$4;
            }
        });
        return (Seq)holder.get();
    }

    public static PreProcessListener executeCodeWithoutPhysicalStage(SparkOperationUtil $this, SparkRuntime runtime, String code) {
        $this.autoGenerateContext(runtime, $this.autoGenerateContext$default$2(), $this.autoGenerateContext$default$3(), $this.autoGenerateContext$default$4(), $this.autoGenerateContext$default$5());
        MLSQLJobInfo jobInfo = $this.createJobInfoFromExistGroupId(code);
        ScriptSQLExec$.MODULE$.context().execListener().addEnv("SKIP_PHYSICAL", "true");
        ScriptRunner$.MODULE$.runJob(code, jobInfo, (Function1<Dataset<Row>, BoxedUnit>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Dataset<Row> df) {
            }
        });
        return (PreProcessListener)ScriptSQLExec$.MODULE$.context().execListener().preProcessListener().get();
    }

    public static void executeCodeWithCallback(SparkOperationUtil $this, SparkRuntime runtime, String code, Function1 f) {
        $this.autoGenerateContext(runtime, $this.autoGenerateContext$default$2(), $this.autoGenerateContext$default$3(), $this.autoGenerateContext$default$4(), $this.autoGenerateContext$default$5());
        MLSQLJobInfo jobInfo = $this.createJobInfoFromExistGroupId(code);
        ScriptRunner$.MODULE$.runJob(code, jobInfo, (Function1<Dataset<Row>, BoxedUnit>)f);
    }

    public static Option executeCodeAsync(SparkOperationUtil $this, SparkRuntime runtime, String code, boolean async) {
        new Thread(new Runnable($this, runtime, code){
            private final /* synthetic */ SparkOperationUtil $outer;
            private final SparkRuntime runtime$2;
            private final String code$2;

            public void run() {
                this.$outer.executeCode(this.runtime$2, this.code$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.runtime$2 = runtime$2;
                this.code$2 = code$2;
            }
        }).start();
        return None$.MODULE$;
    }

    public static boolean executeCodeAsync$default$3(SparkOperationUtil $this) {
        return false;
    }

    public static Object withContext(SparkOperationUtil $this, SparkRuntime runtime, Function1 block) {
        Object object;
        try {
            JobManager$.MODULE$.init(runtime.sparkSession(), JobManager$.MODULE$.init$default$2(), JobManager$.MODULE$.init$default$3());
            object = block.apply((Object)runtime);
        }
        finally {
            try {
                JobManager$.MODULE$.shutdown();
                StrategyDispatcher$.MODULE$.clear();
                PlatformManager$.MODULE$.clear();
                runtime.destroyRuntime(false, true);
                File db = new File("./metastore_db");
                FileUtils.deleteQuietly((File)new File("/tmp/william"));
                if (db.exists()) {
                    FileUtils.deleteDirectory((File)db);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object;
    }

    public static Object withBatchContext(SparkOperationUtil $this, SparkRuntime runtime, Function1 block) {
        Object object;
        try {
            object = block.apply((Object)runtime);
        }
        finally {
            try {
                StrategyDispatcher$.MODULE$.clear();
                PlatformManager$.MODULE$.clear();
                runtime.destroyRuntime(false, true);
                File db = new File("./metastore_db");
                if (db.exists()) {
                    FileUtils.deleteDirectory((File)db);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object;
    }

    public static List getCompositorParam(SparkOperationUtil $this, Compositor item) {
        return (List)ReflectHelper.field((Object)item, (String)"_configParams");
    }

    public static SparkRuntime setupBatchContext(SparkOperationUtil $this, String[] batchParams, String configFilePath) {
        ParamsUtil params = null;
        if (configFilePath == null) {
            params = new ParamsUtil(batchParams);
        } else {
            String[] extraParam = (String[])((Object[])new String[]{"-streaming.job.file.path", configFilePath});
            params = new ParamsUtil((String[])Predef$.MODULE$.refArrayOps((Object[])batchParams).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])extraParam), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        PlatformManager$.MODULE$.getOrCreate().run(params, false);
        SparkRuntime runtime = (SparkRuntime)PlatformManager$.MODULE$.getRuntime();
        return runtime;
    }

    public static String setupBatchContext$default$2(SparkOperationUtil $this) {
        return null;
    }

    public static void appWithBatchContext(SparkOperationUtil $this, String[] batchParams, String configFilePath) {
        SparkRuntime runtime = null;
        try {
            String[] extraParam = (String[])((Object[])new String[]{"-streaming.job.file.path", configFilePath});
            ParamsUtil params = new ParamsUtil((String[])Predef$.MODULE$.refArrayOps((Object[])batchParams).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])extraParam), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            PlatformManager$.MODULE$.getOrCreate().run(params, false);
            runtime = (SparkRuntime)PlatformManager$.MODULE$.getRuntime();
        }
        catch (Throwable throwable) {
            try {
                StrategyDispatcher$.MODULE$.clear();
                PlatformManager$.MODULE$.clear();
                Object object = runtime == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)runtime.destroyRuntime(false, true));
                FileUtils.deleteDirectory((File)new File("./metastore_db"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
        try {
            StrategyDispatcher$.MODULE$.clear();
            PlatformManager$.MODULE$.clear();
            Object object = runtime == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)runtime.destroyRuntime(false, true));
            FileUtils.deleteDirectory((File)new File("./metastore_db"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void $init$(SparkOperationUtil $this) {
    }
}

