/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.ets.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.WowCommandFactory;
import org.apache.hadoop.fs.shell.WowCopyCommands;
import org.apache.hadoop.fs.shell.WowCount;
import org.apache.hadoop.fs.shell.WowDelete;
import org.apache.hadoop.fs.shell.WowFsCommand;
import org.apache.hadoop.fs.shell.WowLs;
import org.apache.hadoop.fs.shell.WowMkdir;
import org.apache.hadoop.fs.shell.WowMoveCommands;
import org.apache.hadoop.tools.TableListing;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class WowFsShell
extends Configured
implements Tool {
    static final Log LOG = LogFactory.getLog(WowFsShell.class);
    private static final int MAX_LINE_WIDTH = 80;
    private FileSystem fs;
    protected String basePath;
    protected CommandFactory commandFactory;
    private final ByteArrayOutputStream outS = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errorS = new ByteArrayOutputStream();
    public final PrintStream out = new PrintStream(this.outS);
    public final PrintStream error = new PrintStream(this.errorS);
    private final String usagePrefix = "Usage: hadoop fs [generic options]";

    public String getOut() {
        return this._out(this.outS);
    }

    public String _out(ByteArrayOutputStream wow) {
        try {
            String temp = wow.toString("UTF8");
            wow.reset();
            return temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getError() {
        return this._out(this.errorS);
    }

    public WowFsShell() {
        this(null, null);
    }

    public WowFsShell(Configuration conf, String basePath) {
        super(conf);
        this.basePath = !StringUtils.isBlank((CharSequence)basePath) ? basePath : "/";
    }

    protected FileSystem getFS() throws IOException {
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)this.getConf());
        }
        return this.fs;
    }

    protected void init() throws IOException {
        this.getConf().setQuietMode(true);
        if (this.commandFactory == null) {
            this.commandFactory = new WowCommandFactory(this.getConf());
            this.commandFactory.addObject((Command)new Help(this.getConf(), this.basePath, this.out, this.error), new String[]{"-help"});
            this.commandFactory.addObject((Command)new Usage(this.getConf(), this.basePath, this.out, this.error), new String[]{"-usage"});
            this.commandFactory.addObject((Command)new WowLs(this.getConf(), this.basePath, this.out, this.error), new String[]{"-ls"});
            this.commandFactory.addObject((Command)new WowLs.Lsr(this.getConf(), this.basePath, this.out, this.error), new String[]{"-lsr"});
            this.commandFactory.addObject((Command)new WowDelete.Rm(this.getConf(), this.basePath, this.out, this.error), new String[]{"-rm"});
            this.commandFactory.addObject((Command)new WowDelete.Rmdir(this.getConf(), this.basePath, this.out, this.error), new String[]{"-rmdir"});
            this.commandFactory.addObject((Command)new WowDelete.Rmr(this.getConf(), this.basePath, this.out, this.error), new String[]{"-rmr"});
            this.commandFactory.addObject((Command)new WowMoveCommands.Rename(this.getConf(), this.basePath, this.out, this.error), new String[]{"-mv"});
            this.commandFactory.addObject((Command)new WowMkdir(this.getConf(), this.basePath, this.out, this.error), new String[]{"-mkdir"});
            this.commandFactory.addObject((Command)new WowCopyCommands.Merge(this.getConf(), this.basePath, this.out, this.error), new String[]{"-getmerge"});
            this.commandFactory.addObject((Command)new WowCopyCommands.Cp(this.getConf(), this.basePath, this.out, this.error), new String[]{"-cp"});
            this.commandFactory.addObject((Command)new WowCount(this.getConf(), this.basePath, this.out, this.error), new String[]{"-count"});
        }
    }

    private void printUsage(PrintStream out) {
        this.printInfo(out, null, false);
    }

    private void printUsage(PrintStream out, String cmd) {
        this.printInfo(out, cmd, false);
    }

    private void printHelp(PrintStream out) {
        this.printInfo(out, null, true);
    }

    private void printHelp(PrintStream out, String cmd) {
        this.printInfo(out, cmd, true);
    }

    private void printInfo(PrintStream out, String cmd, boolean showHelp) {
        if (cmd != null) {
            Command instance = this.commandFactory.getInstance("-" + cmd);
            if (instance == null) {
                throw new UnknownCommandException(cmd);
            }
            if (showHelp) {
                this.printInstanceHelp(out, instance);
            } else {
                this.printInstanceUsage(out, instance);
            }
        } else {
            out.println("Usage: hadoop fs [generic options]");
            ArrayList<Command> instances = new ArrayList<Command>();
            for (String name : this.commandFactory.getNames()) {
                Command instance = this.commandFactory.getInstance(name);
                if (instance.isDeprecated()) continue;
                out.println("\t[" + instance.getUsage() + "]");
                instances.add(instance);
            }
            if (showHelp) {
                for (Command instance : instances) {
                    out.println();
                    this.printInstanceHelp(out, instance);
                }
            }
            out.println();
            ToolRunner.printGenericCommandUsage((PrintStream)out);
        }
    }

    private void printInstanceUsage(PrintStream out, Command instance) {
        out.println("Usage: hadoop fs [generic options] " + instance.getUsage());
    }

    private void printInstanceHelp(PrintStream out, Command instance) {
        out.println(instance.getUsage() + " :");
        TableListing listing = null;
        String prefix = "  ";
        for (String line : instance.getDescription().split("\n")) {
            String[] segments;
            if (line.matches("^[ \t]*[-<].*$") && (segments = line.split(":")).length == 2) {
                if (listing == null) {
                    listing = this.createOptionTableListing();
                }
                listing.addRow(new String[]{segments[0].trim(), segments[1].trim()});
                continue;
            }
            if (listing != null) {
                for (String listingLine : listing.toString().split("\n")) {
                    out.println("  " + listingLine);
                }
                listing = null;
            }
            for (String descLine : WordUtils.wrap((String)line, (int)80, (String)"\n", (boolean)true).split("\n")) {
                out.println("  " + descLine);
            }
        }
        if (listing != null) {
            for (String listingLine : listing.toString().split("\n")) {
                out.println("  " + listingLine);
            }
        }
    }

    private TableListing createOptionTableListing() {
        return new TableListing.Builder().addField("").addField("", true).wrapWidth(80).build();
    }

    public int run(String[] argv) throws Exception {
        this.init();
        int exitCode = -1;
        if (argv.length < 1) {
            this.printUsage(this.error);
        } else {
            String cmd = argv[0];
            Command instance = null;
            try {
                instance = this.commandFactory.getInstance(cmd);
                if (instance == null) {
                    throw new UnknownCommandException();
                }
                exitCode = instance.run(Arrays.copyOfRange(argv, 1, argv.length));
            }
            catch (IllegalArgumentException e) {
                this.displayError(cmd, e.getLocalizedMessage());
                if (instance != null) {
                    this.printInstanceUsage(this.error, instance);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Error", (Throwable)e);
                this.displayError(cmd, "Fatal internal error");
                e.printStackTrace(this.error);
            }
        }
        return exitCode;
    }

    private void displayError(String cmd, String message) {
        for (String line : message.split("\n")) {
            this.error.println(cmd + ": " + line);
            if (cmd.charAt(0) == '-') continue;
            Command instance = null;
            instance = this.commandFactory.getInstance("-" + cmd);
            if (instance == null) continue;
            this.error.println("Did you mean -" + cmd + "?  This command begins with a dash.");
        }
    }

    public void close() throws IOException {
        this.outS.close();
        this.out.close();
        this.errorS.close();
        this.error.close();
    }

    static class UnknownCommandException
    extends IllegalArgumentException {
        private final String cmd;

        UnknownCommandException() {
            this((String)null);
        }

        UnknownCommandException(String cmd) {
            this.cmd = cmd;
        }

        @Override
        public String getMessage() {
            return (this.cmd != null ? "`" + this.cmd + "': " : "") + "Unknown command";
        }
    }

    protected class Help
    extends WowFsCommand {
        public static final String NAME = "help";
        public static final String USAGE = "[cmd ...]";
        public static final String DESCRIPTION = "Displays help for given command or all commands if none is specified.";

        public Help(Configuration conf, String basePath, PrintStream out, PrintStream error) {
            super(conf, basePath, out, error);
        }

        protected void processRawArguments(LinkedList<String> args) {
            if (args.isEmpty()) {
                WowFsShell.this.printHelp(this.out);
            } else {
                for (String arg : args) {
                    WowFsShell.this.printHelp(this.out, arg);
                }
            }
        }
    }

    protected class Usage
    extends WowFsCommand {
        public static final String NAME = "usage";
        public static final String USAGE = "[cmd ...]";
        public static final String DESCRIPTION = "Displays the usage for given command or all commands if none is specified.";

        public Usage(Configuration conf, String basePath, PrintStream out, PrintStream error) {
            super(conf, basePath, out, error);
        }

        protected void processRawArguments(LinkedList<String> args) {
            if (args.isEmpty()) {
                WowFsShell.this.printUsage(this.out);
            } else {
                for (String arg : args) {
                    WowFsShell.this.printUsage(this.out, arg);
                }
            }
        }
    }
}

