/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarInputStream;
import org.kamranzafar.jtar.TarOutputStream;
import streaming.core.HDFSTarEntry;
import tech.mlsql.tool.HDFSOperatorV2;

public class TarfileUtil {
    private static Logger logger = Logger.getLogger(TarfileUtil.class);

    public static void walk(FileSystem fs, List<FileStatus> files, Path p) throws IOException {
        FileStatus[] fileStatusArr;
        if (fs.isFile(p)) {
            files.add(fs.getFileStatus(p));
        } else if (fs.isDirectory(p) && (fileStatusArr = fs.listStatus(p)) != null && fileStatusArr.length > 0) {
            for (FileStatus cur : fileStatusArr) {
                TarfileUtil.walk(fs, files, cur.getPath());
            }
        }
    }

    public static List<String> extractTarFile(InputStream inputStream) throws IOException {
        TarInputStream tarInputStream = new TarInputStream((InputStream)new BufferedInputStream(inputStream));
        TarEntry entry = tarInputStream.getNextEntry();
        ArrayList<String> fileNames = new ArrayList<String>();
        while (entry != null) {
            fileNames.add(entry.getName());
            entry = tarInputStream.getNextEntry();
        }
        tarInputStream.close();
        inputStream.close();
        return fileNames;
    }

    public static List<String> extractTarFileFromPath(String path) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)HDFSOperatorV2.hadoopConfiguration());
        FSDataInputStream fis = fs.open(new Path(path));
        return TarfileUtil.extractTarFile((InputStream)fis);
    }

    public static int createTarFileStream(OutputStream output2, String pathStr) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)HDFSOperatorV2.hadoopConfiguration());
        String[] paths = pathStr.split(",");
        try {
            OutputStream outputStream = output2;
            TarOutputStream tarOutputStream = new TarOutputStream((OutputStream)new BufferedOutputStream(outputStream));
            ArrayList<FileStatus> files = new ArrayList<FileStatus>();
            for (String path : paths) {
                TarfileUtil.walk(fs, files, new Path(path));
            }
            if (files.size() > 0) {
                FSDataInputStream inputStream = null;
                int len = files.size();
                int i = 1;
                for (FileStatus cur : files) {
                    logger.info((Object)("[" + i++ + "/" + len + "],\u8bfb\u53d6\u6587\u4ef6" + cur));
                    inputStream = fs.open(cur.getPath());
                    String entryName = StringUtils.stripStart((String)cur.getPath().toUri().getPath(), (String)pathStr);
                    tarOutputStream.putNextEntry((TarEntry)new HDFSTarEntry(cur, entryName));
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)tarOutputStream);
                    inputStream.close();
                }
                tarOutputStream.flush();
                tarOutputStream.close();
                return 200;
            }
            return 400;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 500;
        }
    }
}

