/*
 * Decompiled with CFR 0.152.
 */
package tech.petrepopescu.logging;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import tech.petrepopescu.logging.masker.CardNumberMasker;
import tech.petrepopescu.logging.masker.EmailMasker;
import tech.petrepopescu.logging.masker.IPMasker;
import tech.petrepopescu.logging.masker.IbanMasker;
import tech.petrepopescu.logging.masker.LogMasker;
import tech.petrepopescu.logging.masker.PasswordMasker;
import tech.petrepopescu.logging.masker.SequentialLogMasker;

public class MaskingConverter {
    private static final List<Character> STOP_CHARACTERS = Arrays.asList(Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('@'), Character.valueOf('>'), Character.valueOf('='));
    private static final Map<String, LogMasker> OPTIONS_TO_MASKER = MaskingConverter.initializeDefaultMaskers();
    private static final List<LogMasker> ALL_MASKERS = OPTIONS_TO_MASKER.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    private List<LogMasker> maskers = new ArrayList<LogMasker>();
    private List<SequentialLogMasker> sequentialMaskers = new ArrayList<SequentialLogMasker>();

    public void init(List<String> options) {
        if (options != null) {
            for (String option : options) {
                if (StringUtils.startsWith((CharSequence)option, (CharSequence)"custom")) {
                    this.maskers.addAll(MaskingConverter.buildCustomMaskersList(option));
                    this.sequentialMaskers.addAll(MaskingConverter.buildCustomSequentialMaskersList(option));
                    continue;
                }
                if (option.equalsIgnoreCase("all")) {
                    this.maskers.addAll(ALL_MASKERS);
                    continue;
                }
                LogMasker masker = this.getMaskerFromOptions(option);
                this.maskers.add(masker);
            }
        }
        if (this.maskers.isEmpty()) {
            this.maskers.addAll(ALL_MASKERS);
        }
    }

    public void setMaskers(List<LogMasker> maskers) {
        this.maskers.clear();
        this.maskers.addAll(maskers);
    }

    private LogMasker getMaskerFromOptions(String option) {
        LogMasker masker;
        String args = null;
        int idxOfArgsSeparator = StringUtils.indexOf((CharSequence)option, (int)58);
        if (idxOfArgsSeparator > 0) {
            args = StringUtils.substring((String)option, (int)(idxOfArgsSeparator + 1));
            option = StringUtils.substring((String)option, (int)0, (int)idxOfArgsSeparator);
        }
        if ((masker = OPTIONS_TO_MASKER.get(option)) == null) {
            throw new ExceptionInInitializerError("Invalid option provided: " + option);
        }
        if (args != null) {
            masker.initialize(args);
        }
        return masker;
    }

    private static List<LogMasker> buildCustomMaskersList(String params) {
        String[] packages;
        int idxOfArgsSeparator = StringUtils.indexOf((CharSequence)params, (int)58);
        if (idxOfArgsSeparator < 0) {
            return Collections.emptyList();
        }
        ArrayList<LogMasker> maskers = new ArrayList<LogMasker>();
        String args = StringUtils.substring((String)params, (int)(idxOfArgsSeparator + 1));
        for (String pack : packages = StringUtils.split((String)args, (char)'|')) {
            Reflections reflections = new Reflections(pack, new Scanner[0]);
            MaskingConverter.initializeCustomLogMaskers(maskers, reflections);
        }
        return maskers;
    }

    private static void initializeCustomLogMaskers(List<LogMasker> maskers, Reflections reflections) {
        Set allClasses = reflections.getSubTypesOf(LogMasker.class);
        for (Class clazz : allClasses) {
            try {
                Constructor maskerConstructor = clazz.getConstructor(new Class[0]);
                LogMasker masker = (LogMasker)maskerConstructor.newInstance(new Object[0]);
                maskers.add(masker);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private static List<SequentialLogMasker> buildCustomSequentialMaskersList(String params) {
        String[] packages;
        int idxOfArgsSeparator = StringUtils.indexOf((CharSequence)params, (int)58);
        if (idxOfArgsSeparator < 0) {
            return Collections.emptyList();
        }
        ArrayList<SequentialLogMasker> maskers = new ArrayList<SequentialLogMasker>();
        String args = StringUtils.substring((String)params, (int)(idxOfArgsSeparator + 1));
        for (String pack : packages = StringUtils.split((String)args, (char)'|')) {
            Reflections reflections = new Reflections(pack, new Scanner[0]);
            MaskingConverter.initializeCustomSequentialLogMaskers(maskers, reflections);
        }
        return maskers;
    }

    private static void initializeCustomSequentialLogMaskers(List<SequentialLogMasker> maskers, Reflections reflections) {
        Set allClasses = reflections.getSubTypesOf(SequentialLogMasker.class);
        for (Class clazz : allClasses) {
            try {
                Constructor maskerConstructor = clazz.getConstructor(new Class[0]);
                SequentialLogMasker masker = (SequentialLogMasker)maskerConstructor.newInstance(new Object[0]);
                maskers.add(masker);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public void mask(StringBuilder stringBuilder) {
        int length = stringBuilder.length();
        for (int pos = 0; pos < length; ++pos) {
            boolean maskedThisCharacter = false;
            for (LogMasker masker : this.maskers) {
                int newPos = masker.maskData(stringBuilder, pos, length);
                maskedThisCharacter = newPos != pos;
                if (!maskedThisCharacter) continue;
                length = stringBuilder.length();
                maskedThisCharacter = true;
                break;
            }
            if (maskedThisCharacter) continue;
            while (pos < length && !Character.isWhitespace(stringBuilder.charAt(pos)) && !STOP_CHARACTERS.contains(Character.valueOf(stringBuilder.charAt(pos)))) {
                ++pos;
            }
        }
        this.maskSequential(stringBuilder);
    }

    private void maskSequential(StringBuilder builder) {
        for (SequentialLogMasker masker : this.sequentialMaskers) {
            try {
                masker.mask(builder);
            }
            catch (Exception e) {
                System.err.println("Error applying masker " + masker + ". Error: " + e.getMessage());
            }
        }
    }

    private static Map<String, LogMasker> initializeDefaultMaskers() {
        HashMap<String, LogMasker> maskers = new HashMap<String, LogMasker>();
        maskers.put("email", new EmailMasker());
        maskers.put("pass", new PasswordMasker());
        maskers.put("ip", new IPMasker());
        maskers.put("card", new CardNumberMasker());
        maskers.put("iban", new IbanMasker());
        return maskers;
    }
}

